/*
 * Decompiled with CFR 0.152.
 */
package io.milton.ftp;

import io.milton.ftp.FtpActionListener;
import io.milton.ftp.MiltonFtpFile;
import java.net.SocketAddress;
import org.apache.ftpserver.ftplet.FtpReply;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.impl.FtpHandler;
import org.apache.ftpserver.impl.FtpIoSession;
import org.apache.ftpserver.impl.FtpServerContext;
import org.apache.ftpserver.listener.Listener;
import org.apache.mina.core.session.IdleStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiltonFtpHandler
implements FtpHandler {
    private static final Logger log = LoggerFactory.getLogger(MiltonFtpFile.class);
    private final FtpHandler wrapped;
    private final FtpActionListener actionListener;

    public MiltonFtpHandler(FtpHandler wrapped, FtpActionListener actionListener) {
        this.wrapped = wrapped;
        this.actionListener = actionListener;
    }

    public void init(FtpServerContext arg0, Listener arg1) {
        this.wrapped.init(arg0, arg1);
    }

    public void sessionCreated(FtpIoSession arg0) throws Exception {
        this.wrapped.sessionCreated(arg0);
    }

    public void sessionOpened(FtpIoSession arg0) throws Exception {
        this.wrapped.sessionOpened(arg0);
    }

    public void sessionClosed(FtpIoSession arg0) throws Exception {
        this.wrapped.sessionClosed(arg0);
    }

    public void sessionIdle(FtpIoSession arg0, IdleStatus arg1) throws Exception {
        this.wrapped.sessionIdle(arg0, arg1);
    }

    public void exceptionCaught(FtpIoSession arg0, Throwable arg1) throws Exception {
        this.wrapped.exceptionCaught(arg0, arg1);
    }

    public void messageReceived(FtpIoSession session, FtpRequest request) throws Exception {
        SocketAddress sa = session.getServiceAddress();
        log.debug("message received: " + sa.toString());
        if (this.actionListener != null) {
            this.actionListener.onAction(session, request, () -> {
                try {
                    this.wrapped.messageReceived(session, request);
                }
                catch (Throwable ex) {
                    log.error("Exception", ex);
                }
            });
        } else {
            this.wrapped.messageReceived(session, request);
        }
    }

    public void messageSent(FtpIoSession ioSession, FtpReply ftpReply) throws Exception {
        this.wrapped.messageSent(ioSession, ftpReply);
    }
}

