/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http;

import io.milton.common.RangeUtils;
import io.milton.http.DateUtils;
import io.milton.http.Response;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResponse
implements Response {
    private static final Logger log = LoggerFactory.getLogger(AbstractResponse.class);
    protected Long contentLength;
    protected Response.Entity entity;

    public void setResponseHeader(Response.Header header, String value) {
        this.setNonStandardHeader(header.code, value);
    }

    public String getResponseHeader(Response.Header header) {
        return this.getNonStandardHeader(header.code);
    }

    public void setContentEncodingHeader(Response.ContentEncoding encoding) {
        this.setResponseHeader(Response.Header.CONTENT_ENCODING, encoding.code);
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public void setDateHeader(Date date) {
        this.setAnyDateHeader(Response.Header.DATE, date);
    }

    public void setContentRangeHeader(long start, long finish, Long totalLength) {
        String s = RangeUtils.toRangeString((long)start, (long)finish, (Long)totalLength);
        this.setResponseHeader(Response.Header.CONTENT_RANGE, s);
    }

    public void setContentLengthHeader(Long totalLength) {
        String s = totalLength == null ? "" : totalLength.toString();
        this.setResponseHeader(Response.Header.CONTENT_LENGTH, s);
        this.contentLength = totalLength;
    }

    public void setContentTypeHeader(String type) {
        this.setResponseHeader(Response.Header.CONTENT_TYPE, type);
    }

    public String getContentTypeHeader() {
        return this.getResponseHeader(Response.Header.CONTENT_TYPE);
    }

    public void setCacheControlMaxAgeHeader(Long delta) {
        if (delta != null) {
            this.setResponseHeader(Response.Header.CACHE_CONTROL, "public, " + Response.CacheControlResponse.MAX_AGE.code + "=" + delta);
        } else {
            this.setResponseHeader(Response.Header.CACHE_CONTROL, Response.CacheControlResponse.NO_CACHE.code);
        }
    }

    public void setCacheControlPrivateMaxAgeHeader(Long delta) {
        if (delta != null) {
            this.setResponseHeader(Response.Header.CACHE_CONTROL, Response.CacheControlResponse.PRIVATE.code + " " + Response.CacheControlResponse.MAX_AGE.code + "=" + delta);
        } else {
            this.setResponseHeader(Response.Header.CACHE_CONTROL, Response.CacheControlResponse.PRIVATE.code);
        }
    }

    public void setExpiresHeader(Date expiresAt) {
        if (expiresAt == null) {
            this.setResponseHeader(Response.Header.EXPIRES, null);
        } else {
            this.setAnyDateHeader(Response.Header.EXPIRES, expiresAt);
        }
    }

    public void setEtag(String uniqueId) {
        this.setResponseHeader(Response.Header.ETAG, uniqueId);
    }

    public void setLastModifiedHeader(Date date) {
        this.setAnyDateHeader(Response.Header.LAST_MODIFIED, date);
    }

    public void setCacheControlNoCacheHeader() {
        this.setResponseHeader(Response.Header.CACHE_CONTROL, Response.CacheControlResponse.NO_CACHE.code);
    }

    public void setLocationHeader(String redirectUrl) {
        this.setResponseHeader(Response.Header.LOCATION, redirectUrl);
    }

    public String getAcceptRanges() {
        return this.getResponseHeader(Response.Header.ACCEPT_RANGES);
    }

    public void setAcceptRanges(String s) {
        this.setResponseHeader(Response.Header.ACCEPT_RANGES, s);
    }

    public void setAllowHeader(List<String> methodsAllowed) {
        if (methodsAllowed == null || methodsAllowed.isEmpty()) {
            return;
        }
        StringBuilder sb = null;
        for (String m : methodsAllowed) {
            if (sb == null) {
                sb = new StringBuilder();
            } else {
                sb.append(", ");
            }
            sb.append(m);
        }
        this.setResponseHeader(Response.Header.ALLOW, sb == null ? "" : sb.toString());
    }

    public void setLockTokenHeader(String s) {
        this.setResponseHeader(Response.Header.LOCK_TOKEN, s);
    }

    public void setDavHeader(String supportedLevels) {
        this.setResponseHeader(Response.Header.DAV, supportedLevels);
    }

    public void setVaryHeader(String value) {
        this.setResponseHeader(Response.Header.VARY, value);
    }

    public String getAccessControlAllowOrigin() {
        return this.getResponseHeader(Response.Header.ACCESS_CONTROL_ALLOW_ORIGIN);
    }

    public void setAccessControlAllowOrigin(String s) {
        this.setResponseHeader(Response.Header.ACCESS_CONTROL_ALLOW_ORIGIN, s);
    }

    public void setEntity(Response.Entity entity) {
        this.entity = entity;
    }

    public Response.Entity getEntity() {
        return this.entity;
    }

    public void sendRedirect(String url) {
        if (log.isTraceEnabled()) {
            log.trace("sendRedirect: " + url);
        }
        this.setStatus(Response.Status.SC_MOVED_TEMPORARILY);
        this.setLocationHeader(url);
    }

    public void sendPermanentRedirect(String url) {
        if (log.isTraceEnabled()) {
            log.trace("sendPermanentRedirect: " + url);
        }
        this.setStatus(Response.Status.SC_MOVED_PERMANENTLY);
        this.setLocationHeader(url);
    }

    protected void setAnyDateHeader(Response.Header name, Date date) {
        if (date == null) {
            return;
        }
        String fmt = DateUtils.formatForHeader((Date)date);
        this.setResponseHeader(name, fmt);
    }
}

