/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http;

import io.milton.common.StringUtils;
import io.milton.http.Auth;
import io.milton.http.AuthenticationHandler;
import io.milton.http.ExternalIdentityProvider;
import io.milton.http.Request;
import io.milton.resource.GetableResource;
import io.milton.resource.Resource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationService {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationService.class);
    public static final String ATT_AUTH_STATUS = "auth.service.status";
    public static final String ATT_AUTH_CALLED = "auth.service.called";
    private final List<AuthenticationHandler> authenticationHandlers;
    private List<ExternalIdentityProvider> externalIdentityProviders;
    private boolean disableExternal;
    private final String[] browserIds = new String[]{"msie", "firefox", "chrome", "safari", "opera"};

    public AuthenticationService(List<AuthenticationHandler> authenticationHandlers) {
        this.authenticationHandlers = authenticationHandlers;
    }

    public AuthStatus authenticate(Resource resource, Request request) {
        if (request.getAttributes().containsKey(ATT_AUTH_STATUS)) {
            return (AuthStatus)request.getAttributes().get(ATT_AUTH_STATUS);
        }
        if (request.getAttributes().containsKey(ATT_AUTH_CALLED)) {
            return null;
        }
        request.getAttributes().put(ATT_AUTH_CALLED, Boolean.TRUE);
        AuthStatus authStatus = this._authenticate(resource, request);
        request.getAttributes().put(ATT_AUTH_STATUS, authStatus);
        return authStatus;
    }

    private AuthStatus _authenticate(Resource resource, Request request) {
        boolean preAuthenticated;
        log.trace("authenticate");
        Auth auth = request.getAuthorization();
        boolean bl = preAuthenticated = auth != null && auth.getTag() != null;
        if (preAuthenticated) {
            log.trace("request is pre-authenticated");
            return new AuthStatus(auth, false);
        }
        if (log.isTraceEnabled()) {
            log.trace("Checking authentication with auth handlers: " + this.authenticationHandlers.size());
            for (AuthenticationHandler h : this.authenticationHandlers) {
                log.trace(" - " + h);
            }
        }
        for (AuthenticationHandler h : this.authenticationHandlers) {
            if (h.supports(resource, request)) {
                Object loginToken = h.authenticate(resource, request);
                if (loginToken == null) {
                    log.warn("authentication failed by AuthenticationHandler:" + h.getClass());
                    return new AuthStatus(auth, true);
                }
                if (log.isTraceEnabled()) {
                    log.trace("authentication passed by: " + h.getClass());
                }
                if (auth == null) {
                    auth = new Auth(Auth.Scheme.FORM, null, loginToken);
                    request.setAuthorization(auth);
                }
                auth.setTag(loginToken);
                continue;
            }
            if (!log.isTraceEnabled()) continue;
            log.trace("handler does not support this resource and request. handler: " + h.getClass() + " resource: " + resource.getClass());
        }
        if (auth != null) {
            return new AuthStatus(auth, false);
        }
        log.trace("authentication did not locate a user, because no handler accepted the request");
        return null;
    }

    public List<String> getChallenges(Resource resource, Request request) {
        ArrayList<String> challenges = new ArrayList<String>();
        for (AuthenticationHandler h : this.authenticationHandlers) {
            if (h.isCompatible(resource, request)) {
                log.debug("challenge for auth: " + h.getClass());
                h.appendChallenges(resource, request, challenges);
                continue;
            }
            log.debug("not challenging for auth: " + h.getClass() + " for resource type: " + (Serializable)(resource == null ? "" : resource.getClass()));
        }
        return challenges;
    }

    public List<AuthenticationHandler> getAuthenticationHandlers() {
        return this.authenticationHandlers;
    }

    public List<ExternalIdentityProvider> getExternalIdentityProviders() {
        return this.externalIdentityProviders;
    }

    public void setExternalIdentityProviders(List<ExternalIdentityProvider> externalIdentityProviders) {
        this.externalIdentityProviders = externalIdentityProviders;
    }

    public boolean isDisableExternal() {
        return this.disableExternal;
    }

    public void setDisableExternal(boolean disableExternal) {
        this.disableExternal = disableExternal;
    }

    public boolean canUseExternalAuth(Resource resource, Request request) {
        if (this.isDisableExternal()) {
            log.trace("auth svc has disabled external auth");
            return false;
        }
        if (this.getExternalIdentityProviders() == null || this.getExternalIdentityProviders().isEmpty()) {
            log.trace("auth service has no external auth providers");
            return false;
        }
        if (resource instanceof GetableResource) {
            GetableResource gr = (GetableResource)resource;
            String ct = gr.getContentType("text/html");
            if (ct == null || !ct.contains("html")) {
                log.trace("is not of content type html");
                return false;
            }
        } else {
            log.trace("is not getable");
            return false;
        }
        String ua = request.getUserAgentHeader();
        if (StringUtils.contains((String)ua.toLowerCase(), (String[])this.browserIds)) {
            log.trace("is a known web browser, so can offer external auth");
            return true;
        }
        log.trace("not a known web browser, so cannot offer external auth");
        return false;
    }

    public boolean authenticateDetailsPresent(Request request) {
        for (AuthenticationHandler h : this.authenticationHandlers) {
            if (!h.credentialsPresent(request)) continue;
            return true;
        }
        return false;
    }

    public static class AuthStatus {
        public final Auth auth;
        public final boolean loginFailed;

        public AuthStatus(Auth auth, boolean loginFailed) {
            this.auth = auth;
            this.loginFailed = loginFailed;
        }

        public String toString() {
            if (this.auth == null) {
                return "AuthStatus: no creds";
            }
            if (this.loginFailed) {
                return "AuthStatus: login failed: " + this.auth.getUser();
            }
            return "AuthStatus: logged in: " + this.auth.getUser();
        }
    }
}

