/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http;

import io.milton.common.LogUtils;
import io.milton.common.Path;
import io.milton.http.Auth;
import io.milton.http.AuthenticationService;
import io.milton.http.AuthorisationListener;
import io.milton.http.ConditionalCompatibleResource;
import io.milton.http.HttpManager;
import io.milton.http.LockToken;
import io.milton.http.Request;
import io.milton.http.Response;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.http11.Http11ResponseHandler;
import io.milton.http.quota.DefaultStorageChecker;
import io.milton.http.quota.StorageChecker;
import io.milton.resource.CollectionResource;
import io.milton.resource.LockableResource;
import io.milton.resource.Resource;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandlerHelper {
    private static final Logger log = LoggerFactory.getLogger(HandlerHelper.class);
    private final AuthenticationService authenticationService;
    private final List<StorageChecker> storageCheckers;
    private final AuthorisationListener authorisationListener;
    private boolean enableExpectContinue = true;

    public HandlerHelper(AuthenticationService authenticationService, List<StorageChecker> storageCheckers) {
        this.authenticationService = authenticationService;
        this.storageCheckers = storageCheckers;
        this.authorisationListener = null;
    }

    public HandlerHelper(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
        this.storageCheckers = new ArrayList<StorageChecker>();
        this.storageCheckers.add(new DefaultStorageChecker());
        this.authorisationListener = null;
    }

    public HandlerHelper(AuthenticationService authenticationService, AuthorisationListener authorisationListener) {
        this.authenticationService = authenticationService;
        this.storageCheckers = new ArrayList<StorageChecker>();
        this.storageCheckers.add(new DefaultStorageChecker());
        this.authorisationListener = authorisationListener;
    }

    public boolean checkExpects(Http11ResponseHandler responseHandler, Request request, Response response) {
        if (this.enableExpectContinue) {
            String s = request.getExpectHeader();
            LogUtils.trace((Logger)log, (Object[])new Object[]{"checkExpects", s});
            if (s != null && s.length() > 0) {
                response.setStatus(Response.Status.SC_CONTINUE);
                return false;
            }
            return true;
        }
        return true;
    }

    public AuthenticationService.AuthStatus checkAuthentication(HttpManager manager, Resource resource, Request request) {
        log.trace("checkAuthentication");
        AuthenticationService.AuthStatus authStatus = this.authenticationService.authenticate(resource, request);
        if (authStatus == null) {
            log.trace("checkAuthentication: null authStatus");
            return null;
        }
        log.trace("checkAuthentication: authStatus.failed =" + authStatus.loginFailed);
        return authStatus;
    }

    public boolean checkAuthorisation(HttpManager manager, Resource resource, Request request) {
        Auth auth;
        AuthenticationService.AuthStatus authStatus = this.checkAuthentication(manager, resource, request);
        log.trace("checkAuthorisation: " + authStatus);
        if (authStatus != null && authStatus.loginFailed) {
            log.trace("checkAuthorisation: loginFailed");
            return false;
        }
        if (authStatus != null) {
            log.trace("checkAuthorisation: got auth object");
            auth = authStatus.auth;
        } else {
            log.trace("checkAuthorisation: authStatus is null, no authentication was attempted");
            auth = null;
        }
        return this.checkAuthorisation(manager, resource, request, request.getMethod(), auth);
    }

    public boolean checkAuthorisation(HttpManager manager, Resource resource, Request request, Request.Method method, Auth auth) {
        boolean authorised = resource.authorise(request, method, auth);
        if (this.authorisationListener != null) {
            authorised = this.authorisationListener.onAuthorisationResult(request, method, auth, authorised);
        }
        if (!authorised) {
            if (log.isWarnEnabled()) {
                log.warn("authorisation declined, requesting authentication: " + request.getAbsolutePath() + ". resource type: " + resource.getClass().getCanonicalName());
            }
            if (auth != null) {
                if (log.isTraceEnabled()) {
                    log.trace("  - auth: " + auth.getUser() + " tag: " + auth.getTag());
                }
            } else {
                log.trace("  - anonymous request rejected");
            }
            return false;
        }
        log.trace("checkAuthorisation: request permitted");
        return true;
    }

    public boolean doCheckRedirect(Http11ResponseHandler responseHandler, Request request, Response response, Resource resource) throws NotAuthorizedException, BadRequestException {
        String redirectUrl = resource.checkRedirect(request);
        if (redirectUrl != null && redirectUrl.length() > 0) {
            responseHandler.respondRedirect(response, request, redirectUrl);
            return true;
        }
        return false;
    }

    public boolean isLocked(Resource inResource) {
        if (!(inResource instanceof LockableResource)) {
            return false;
        }
        LockableResource lr = (LockableResource)inResource;
        LockToken token = lr.getCurrentLock();
        return token != null;
    }

    public boolean isLockedOut(Request inRequest, Resource inResource) {
        if (!(inResource instanceof LockableResource)) {
            return false;
        }
        LockableResource lr = (LockableResource)inResource;
        LockToken token = lr.getCurrentLock();
        if (token != null) {
            Auth auth = inRequest.getAuthorization();
            String sUser = null;
            if (auth != null) {
                sUser = auth.getUser();
            }
            if (token.info == null) {
                log.warn("Found a lock on this resource, but it has no info property so is ignored");
                return false;
            }
            String lockedByUser = token.info.lockedByUser;
            if (lockedByUser == null) {
                log.warn("Resource is locked with a null user. Ignoring the lock");
                return false;
            }
            if (!lockedByUser.equals(sUser)) {
                String ifHeader;
                if (log.isInfoEnabled()) {
                    if (auth == null) {
                        log.trace("lock owned by: " + lockedByUser);
                    } else {
                        log.trace("lock owned by: " + lockedByUser + " not by " + auth.getUser());
                    }
                }
                if ((ifHeader = inRequest.getIfHeader()) != null && ifHeader.contains(token.tokenId)) {
                    log.trace("Request contains valid If lock-token so operation is permitted");
                    return false;
                }
                String lockToken = inRequest.getLockTokenHeader();
                if (lockToken != null && lockToken.contains(token.tokenId)) {
                    log.trace("Request contains valid lock-token so operation is permitted");
                    return false;
                }
                log.warn("Locked out. ifHeader=" + ifHeader + " lock-token header=" + lockToken + ", but actual token: " + token.tokenId + " LockedByUser=" + lockedByUser + " RequestUser=" + sUser);
                return true;
            }
        }
        return false;
    }

    public boolean missingLock(Request inRequest, Resource inParentcol) {
        String value = inRequest.getIfHeader();
        if (value != null && value.contains("(<DAV:no-lock>)")) {
            log.info("Contained valid token. so is unlocked");
            return true;
        }
        return false;
    }

    public StorageChecker.StorageErrorReason checkStorageOnReplace(Request request, CollectionResource parentCol, Resource replaced, String host) {
        for (StorageChecker sc : this.storageCheckers) {
            StorageChecker.StorageErrorReason res = sc.checkStorageOnReplace(request, parentCol, replaced, host);
            if (res == null) continue;
            log.warn("insufficient storage reason: " + res + " reported by: " + sc.getClass());
            return res;
        }
        return null;
    }

    public StorageChecker.StorageErrorReason checkStorageOnAdd(Request request, CollectionResource nearestParent, Path parentPath, String host) {
        for (StorageChecker sc : this.storageCheckers) {
            StorageChecker.StorageErrorReason res = sc.checkStorageOnAdd(request, nearestParent, parentPath, host);
            if (res == null) continue;
            log.warn("insufficient storage reason: " + res + " reported by: " + sc.getClass());
            return res;
        }
        return null;
    }

    public boolean isNotCompatible(Resource r, Request.Method m) {
        if (r instanceof ConditionalCompatibleResource) {
            ConditionalCompatibleResource ccr = (ConditionalCompatibleResource)r;
            return !ccr.isCompatible(m);
        }
        return false;
    }

    public boolean isEnableExpectContinue() {
        return this.enableExpectContinue;
    }

    public void setEnableExpectContinue(boolean enableExpectContinue) {
        this.enableExpectContinue = enableExpectContinue;
    }
}

