/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http;

import io.milton.http.ResourceFactory;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.resource.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipleResourceFactory
implements ResourceFactory {
    private final Logger log = LoggerFactory.getLogger(MultipleResourceFactory.class);
    protected final List<ResourceFactory> factories;
    protected Map<String, ResourceFactory> mapOfFactoriesByHost;

    public MultipleResourceFactory() {
        this.factories = new ArrayList<ResourceFactory>();
    }

    public MultipleResourceFactory(List<ResourceFactory> factories) {
        this.factories = factories;
    }

    public Resource getResource(String host, String url) throws NotAuthorizedException, BadRequestException {
        Resource theResource;
        if (this.log.isTraceEnabled()) {
            this.log.trace("getResource: " + url);
        }
        ResourceFactory hostRf = null;
        if (this.mapOfFactoriesByHost != null) {
            hostRf = this.mapOfFactoriesByHost.get(host);
        }
        if ((theResource = hostRf != null ? hostRf.getResource(host, url) : this.findFromFactories(host, url)) == null) {
            this.log.debug("no resource factory supplied a resouce");
        }
        return theResource;
    }

    public void add(ResourceFactory rf) {
        this.factories.add(rf);
    }

    public void addAsFirst(ResourceFactory rf) {
        this.factories.add(0, rf);
    }

    public Map<String, ResourceFactory> getMapOfFactoriesByHost() {
        return this.mapOfFactoriesByHost;
    }

    public void setMapOfFactoriesByHost(Map<String, ResourceFactory> mapOfFactoriesByHost) {
        this.mapOfFactoriesByHost = mapOfFactoriesByHost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource findFromFactories(String host, String url) throws NotAuthorizedException, BadRequestException {
        for (ResourceFactory rf : this.factories) {
            long tm = System.currentTimeMillis();
            try {
                Resource r = rf.getResource(host, url);
                if (r == null) continue;
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Found resource: " + r.getClass() + " from factory: " + rf.getClass());
                }
                Resource resource = r;
                return resource;
            }
            finally {
                tm = System.currentTimeMillis() - tm;
                if (tm <= 1000L) continue;
                this.log.info("Slow lookup of {}ms in resourcefactory {}", (Object)tm, (Object)rf);
            }
        }
        return null;
    }
}

