/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.annotated;

import io.milton.annotations.Copy;
import io.milton.http.Request;
import io.milton.http.annotated.AbstractAnnotationHandler;
import io.milton.http.annotated.AnnoResource;
import io.milton.http.annotated.AnnotationResourceFactory;
import io.milton.http.annotated.ControllerMethod;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.ConflictException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.resource.CollectionResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyAnnotationHandler
extends AbstractAnnotationHandler {
    private static final Logger log = LoggerFactory.getLogger(CopyAnnotationHandler.class);

    public CopyAnnotationHandler(AnnotationResourceFactory outer) {
        super(outer, Copy.class, Request.Method.COPY);
    }

    void execute(AnnoResource res, CollectionResource rDest, String newName) throws NotAuthorizedException, BadRequestException, ConflictException {
        log.trace("execute COPY method");
        Object source = res.getSource();
        ControllerMethod cm = this.getBestMethod(source.getClass());
        if (cm == null) {
            throw new RuntimeException("Method not found: " + this.getClass() + " - " + source.getClass());
        }
        try {
            Object destObject = null;
            if (rDest instanceof AnnoResource) {
                AnnoResource arDest = (AnnoResource)rDest;
                destObject = arDest.getSource();
            }
            this.invoke(cm, res, newName, rDest, destObject);
        }
        catch (BadRequestException | ConflictException | NotAuthorizedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

