/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.annotated;

import io.milton.annotations.Get;
import io.milton.common.JsonResult;
import io.milton.common.ModelAndView;
import io.milton.common.StreamUtils;
import io.milton.http.HttpManager;
import io.milton.http.Range;
import io.milton.http.Request;
import io.milton.http.annotated.AbstractAnnotationHandler;
import io.milton.http.annotated.AnnoResource;
import io.milton.http.annotated.AnnotationResourceFactory;
import io.milton.http.annotated.ControllerMethod;
import io.milton.http.annotated.JsonWriter;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.exceptions.NotFoundException;
import io.milton.http.template.TemplateProcessor;
import io.milton.principal.DiscretePrincipal;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetAnnotationHandler
extends AbstractAnnotationHandler {
    private static final Logger log = LoggerFactory.getLogger(GetAnnotationHandler.class);

    public GetAnnotationHandler(AnnotationResourceFactory outer) {
        super(outer, Get.class, Request.Method.GET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(AnnoResource resource, OutputStream out, Range range, Map<String, String> params, String contentType) throws IOException, NotAuthorizedException, BadRequestException, NotFoundException {
        Object source = resource.getSource();
        ControllerMethod cm = this.getBestMethod(source.getClass(), contentType, params, null);
        if (cm == null) {
            throw new RuntimeException("Method not found: " + this.getClass() + " - " + source.getClass());
        }
        log.trace("execute GET method: " + cm.method.getName());
        try {
            Object result = this.invoke(cm, resource, range, params, contentType, out);
            if (result != null) {
                log.trace("method returned a value, so write it to output");
                if (result instanceof String) {
                    ModelAndView modelAndView = new ModelAndView("resource", source, result.toString());
                    this.processTemplate(modelAndView, resource, out);
                } else if (result instanceof JsonResult) {
                    JsonResult jsonr = (JsonResult)result;
                    JsonWriter jsonWriter = new JsonWriter();
                    jsonWriter.write(jsonr, out);
                } else if (result instanceof InputStream) {
                    InputStream contentIn = (InputStream)result;
                    if (range != null) {
                        StreamUtils.readTo((InputStream)contentIn, (OutputStream)out, (boolean)true, (boolean)false, (Long)range.getStart(), (Long)range.getFinish());
                    } else {
                        try {
                            IOUtils.copy((InputStream)contentIn, (OutputStream)out);
                        }
                        finally {
                            IOUtils.closeQuietly((InputStream)contentIn);
                        }
                    }
                } else if (result instanceof byte[]) {
                    byte[] bytes = (byte[])result;
                    out.write(bytes);
                } else if (result instanceof ModelAndView) {
                    this.processTemplate((ModelAndView)result, resource, out);
                } else {
                    throw new RuntimeException("Unsupported return type from method: " + cm.method.getName() + " in " + cm.controller.getClass() + " should return String or byte[]");
                }
            }
            out.flush();
        }
        catch (BadRequestException | NotAuthorizedException | NotFoundException | IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void processTemplate(ModelAndView modelAndView, AnnoResource resource, OutputStream out) {
        Object principal;
        TemplateProcessor templateProc = this.annoResourceFactory.getViewResolver().resolveView(modelAndView.getView());
        modelAndView.getModel().put("page", resource);
        if (HttpManager.request().getAuthorization() != null && (principal = HttpManager.request().getAuthorization().getTag()) instanceof DiscretePrincipal) {
            modelAndView.getModel().put("principal", principal);
        }
        templateProc.execute(modelAndView.getModel(), out);
    }
}

