/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.annotated;

import io.milton.annotations.PrincipalSearch;
import io.milton.common.Path;
import io.milton.http.Request;
import io.milton.http.annotated.AbstractAnnotationHandler;
import io.milton.http.annotated.AnnoAddressBookResource;
import io.milton.http.annotated.AnnoCollectionResource;
import io.milton.http.annotated.AnnotationResourceFactory;
import io.milton.http.annotated.CommonResource;
import io.milton.http.annotated.ControllerMethod;
import io.milton.http.annotated.ResourceList;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.principal.PrincipalSearchCriteria;
import io.milton.resource.Resource;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrincipalSearchAnnotationHandler
extends AbstractAnnotationHandler {
    private static final Logger log = LoggerFactory.getLogger(AnnotationResourceFactory.class);

    public PrincipalSearchAnnotationHandler(AnnotationResourceFactory outer) {
        super(outer, PrincipalSearch.class, new Request.Method[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<? extends Resource> execute(AnnoAddressBookResource addressBookRes, PrincipalSearchCriteria crit) {
        Object source = addressBookRes.getSource();
        try {
            Object value = null;
            ControllerMethod cm = this.getBestMethod(source.getClass());
            if (cm == null) {
                Method m = this.annoResourceFactory.findMethodForAnno(source.getClass(), this.annoClass);
                if (m == null) return null;
                value = m.invoke(source, crit);
            } else {
                value = this.invoke(cm, addressBookRes, crit);
            }
            if (value == null) return null;
            return this.toResourceList(addressBookRes, value);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception executing " + this.getClass() + " - " + source.getClass(), e);
        }
    }

    private ResourceList toResourceList(AnnoAddressBookResource addressBookRes, Object value) throws NotAuthorizedException, BadRequestException {
        ResourceList list = new ResourceList();
        if (value == null) {
            log.warn("Got null from principal search");
        } else if (list instanceof Collection) {
            Collection col = (Collection)value;
            for (Object o : col) {
                CommonResource commonResource = this.toResource(addressBookRes, o);
            }
        }
        return list;
    }

    private CommonResource toResource(AnnoAddressBookResource addressBookRes, Object o) throws NotAuthorizedException, BadRequestException {
        if (o instanceof CommonResource) {
            return (CommonResource)o;
        }
        if (o instanceof Resource) {
            Resource r = (Resource)o;
            log.warn("Got an incompatible Resource={} with name={}, should be implementation of CommonResource", o.getClass(), (Object)r.getName());
            return null;
        }
        if (o instanceof Path) {
            Path path = (Path)o;
            AnnoCollectionResource fromCol = path.isRelative() ? addressBookRes : addressBookRes.getRoot();
            Resource r = this.annoResourceFactory.findFromRoot(fromCol, path);
            return this.toResource(addressBookRes, r);
        }
        if (o instanceof String) {
            String s = (String)o;
            Path path = Path.path((String)s);
            return this.toResource(addressBookRes, path);
        }
        log.warn("Got an incompatible search result with class={}. I dont know how to convert this to a CommonResource. Return a String href or Path (path to resource), or a source object, or a CommonResource", o.getClass());
        return null;
    }
}

