/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.fs;

import io.milton.common.ContentTypeUtils;
import io.milton.common.RangeUtils;
import io.milton.common.ReadingException;
import io.milton.common.WritingException;
import io.milton.http.Auth;
import io.milton.http.PropertyManager;
import io.milton.http.Range;
import io.milton.http.Request;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.ConflictException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.exceptions.NotFoundException;
import io.milton.http.fs.FileContentService;
import io.milton.http.fs.FileSystemResourceFactory;
import io.milton.http.fs.FsResource;
import io.milton.property.PropertySource;
import io.milton.resource.CopyableResource;
import io.milton.resource.DeletableResource;
import io.milton.resource.GetableResource;
import io.milton.resource.MoveableResource;
import io.milton.resource.MultiNamespaceCustomPropertyResource;
import io.milton.resource.PropFindableResource;
import io.milton.resource.ReplaceableResource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FsFileResource
extends FsResource
implements CopyableResource,
DeletableResource,
GetableResource,
MoveableResource,
PropFindableResource,
ReplaceableResource,
MultiNamespaceCustomPropertyResource {
    private static final Logger log = LoggerFactory.getLogger(FsFileResource.class);
    private final FileContentService contentService;

    public FsFileResource(String host, FileSystemResourceFactory factory, File file, FileContentService contentService) {
        super(host, factory, file);
        this.contentService = contentService;
    }

    public Long getContentLength() {
        return this.file.length();
    }

    public String getContentType(String preferredList) {
        String mime = ContentTypeUtils.findContentTypes((File)this.file);
        String s = ContentTypeUtils.findAcceptableContentType((String)mime, (String)preferredList);
        if (log.isTraceEnabled()) {
            log.trace("getContentType: preferred: {} mime: {} selected: {}", new Object[]{preferredList, mime, s});
        }
        return s;
    }

    public String checkRedirect(Request arg0) {
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendContent(OutputStream out, Range range, Map<String, String> params, String contentType) throws IOException, NotFoundException {
        InputStream in = null;
        try {
            in = this.contentService.getFileContent(this.file);
            if (range != null) {
                log.debug("sendContent: ranged content: " + this.file.getAbsolutePath());
                RangeUtils.writeRange((InputStream)in, (Range)range, (OutputStream)out);
            } else {
                log.debug("sendContent: send whole file " + this.file.getAbsolutePath());
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
            out.flush();
        }
        catch (FileNotFoundException e) {
            try {
                throw new NotFoundException("Couldnt locate content");
                catch (ReadingException | WritingException e2) {
                    throw new IOException(e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
    }

    public Long getMaxAgeSeconds(Auth auth) {
        return this.factory.maxAgeSeconds(this);
    }

    @Override
    protected void doCopy(File dest) {
        try {
            FileUtils.copyFile((File)this.file, (File)dest);
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed doing copy to: " + dest.getAbsolutePath(), ex);
        }
    }

    public void replaceContent(InputStream in, Long length) throws BadRequestException, ConflictException, NotAuthorizedException {
        try {
            this.contentService.setFileContent(this.file, in);
            this.factory.getWsManager().ifPresent(wsManager -> wsManager.notifyUpdated(this.factory.toResourcePath(this.file)));
        }
        catch (IOException ex) {
            throw new BadRequestException("Couldnt write to: " + this.file.getAbsolutePath(), (Throwable)ex);
        }
    }

    public Object getProperty(QName name) {
        PropertyManager propertyManager = this.factory.getPropertyManager();
        if (propertyManager != null) {
            return propertyManager.getProperty(name, (MultiNamespaceCustomPropertyResource)this);
        }
        return null;
    }

    public void setProperty(QName name, Object value) throws PropertySource.PropertySetException, NotAuthorizedException {
        PropertyManager propertyManager = this.factory.getPropertyManager();
        if (propertyManager != null) {
            propertyManager.setProperty(name, value, (MultiNamespaceCustomPropertyResource)this);
            this.factory.getWsManager().ifPresent(wsManager -> wsManager.notifyUpdated(this.factory.toResourcePath(this.file)));
        }
    }

    public PropertySource.PropertyMetaData getPropertyMetaData(QName name) {
        PropertyManager propertyManager = this.factory.getPropertyManager();
        if (propertyManager != null) {
            return propertyManager.getPropertyMetaData(name, (MultiNamespaceCustomPropertyResource)this);
        }
        return null;
    }

    public List<QName> getAllPropertyNames() {
        PropertyManager propertyManager = this.factory.getPropertyManager();
        if (propertyManager != null) {
            return propertyManager.getAllPropertyNames((MultiNamespaceCustomPropertyResource)this);
        }
        return null;
    }
}

