/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.fs;

import io.milton.cache.CacheManager;
import io.milton.http.Auth;
import io.milton.http.HttpManager;
import io.milton.http.LockInfo;
import io.milton.http.LockManager;
import io.milton.http.LockResult;
import io.milton.http.LockTimeout;
import io.milton.http.LockToken;
import io.milton.http.Request;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.resource.LockableResource;
import io.milton.resource.Resource;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleLockManager
implements LockManager {
    private static final Logger log = LoggerFactory.getLogger(SimpleLockManager.class);
    private final Map<String, String> locksByUniqueId;
    private final Map<String, String> locksByToken;

    private static CurrentLock toCurrentLock(String formattedLock) {
        if (formattedLock == null) {
            return null;
        }
        try {
            String[] arr = formattedLock.split("\n");
            String id = arr[0];
            String tokenId = arr[1];
            long tm = Long.parseLong(arr[2]);
            Date dt = new Date(tm);
            String lockedBy = arr[3];
            Long secs = null;
            if (arr.length > 4 && arr[4] != null) {
                secs = Long.parseLong(arr[4]);
            }
            return new CurrentLock(id, tokenId, dt, lockedBy, secs);
        }
        catch (Throwable e) {
            log.error("Exception parsing lock: " + formattedLock, e);
            return null;
        }
    }

    private static String toString(CurrentLock lock) {
        String id = lock.id;
        String token = lock.token.tokenId;
        long tm = lock.token.getFrom().getTime();
        String lockedBy = lock.lockedByUser;
        Long secs = lock.token.timeout.getSeconds();
        return id + "\n" + token + "\n" + tm + "\n" + lockedBy + "\n" + (Serializable)(secs != null ? secs : "");
    }

    public SimpleLockManager(CacheManager cacheManager) {
        this.locksByUniqueId = cacheManager.getMap("fuse-locks-byuniqueId");
        this.locksByToken = cacheManager.getMap("fuse-locks-bytoken");
    }

    public LockResult lock(LockTimeout timeout, LockInfo lockInfo, LockableResource r) {
        return this.lock(timeout, lockInfo, r.getUniqueId());
    }

    public LockResult lock(LockTimeout timeout, LockInfo lockInfo, String uniqueId) {
        String token = UUID.randomUUID().toString();
        return this.lock(timeout, lockInfo, uniqueId, token);
    }

    private LockResult lock(LockTimeout timeout, LockInfo lockInfo, LockableResource r, String token) {
        return this.lock(timeout, lockInfo, r.getUniqueId(), token);
    }

    public synchronized LockResult lock(LockTimeout timeout, LockInfo lockInfo, String uniqueId, String token) {
        Auth auth;
        LockToken currentLock = this.currentLock(uniqueId);
        if (currentLock != null) {
            return LockResult.failed((LockResult.FailureReason)LockResult.FailureReason.ALREADY_LOCKED);
        }
        LockToken newToken = new LockToken(token, lockInfo, timeout);
        String lockedByUser = lockInfo.lockedByUser;
        Request req = HttpManager.request();
        if (req != null && (auth = req.getAuthorization()) != null && auth.getUser() != null) {
            lockedByUser = auth.getUser();
        }
        log.info("Lock as user {}", (Object)lockedByUser);
        CurrentLock newLock = new CurrentLock(uniqueId, newToken, lockedByUser);
        String sNewLock = newLock.toString();
        this.locksByUniqueId.put(uniqueId, sNewLock);
        this.locksByToken.put(token, sNewLock);
        return LockResult.success((LockToken)newToken);
    }

    public synchronized LockResult refresh(String tokenId, LockTimeout timeout, LockableResource resource) {
        String sCurLock = this.locksByToken.get(tokenId);
        CurrentLock curLock = null;
        if (sCurLock != null) {
            curLock = SimpleLockManager.toCurrentLock(sCurLock);
        }
        if (curLock == null && (sCurLock = this.locksByUniqueId.get(resource.getUniqueId())) != null) {
            curLock = SimpleLockManager.toCurrentLock(sCurLock);
        }
        if (curLock == null || curLock.token == null) {
            log.warn("attempt to refresh missing token/etaqg: " + tokenId + " on resource: " + resource.getName() + " will create a new lock");
            String lockedByUser = null;
            Auth auth = HttpManager.request().getAuthorization();
            if (auth != null) {
                lockedByUser = auth.getUser();
            } else {
                log.warn("No user in context, lock wont be very effective");
            }
            LockInfo lockInfo = new LockInfo(LockInfo.LockScope.EXCLUSIVE, LockInfo.LockType.WRITE, lockedByUser, LockInfo.LockDepth.ZERO);
            return this.lock(timeout, lockInfo, resource, UUID.randomUUID().toString());
        }
        curLock.token.setTimeout(timeout);
        curLock.token.setFrom(new Date());
        return LockResult.success((LockToken)curLock.token);
    }

    public synchronized void unlock(String tokenId, LockableResource r) throws NotAuthorizedException {
        LockToken lockToken = this.currentLock(r.getUniqueId());
        if (lockToken == null) {
            log.debug("not locked");
            return;
        }
        if (!lockToken.tokenId.equals(tokenId)) {
            throw new NotAuthorizedException("Non-matching tokens: " + tokenId + " != " + lockToken.tokenId, (Resource)r);
        }
        this.removeLock(lockToken);
    }

    private LockToken currentLock(String uniqueId) {
        String sCurLock = this.locksByUniqueId.get(uniqueId);
        if (sCurLock == null) {
            return null;
        }
        CurrentLock curLock = SimpleLockManager.toCurrentLock(sCurLock);
        if (curLock == null) {
            return null;
        }
        LockToken token = curLock.token;
        if (token.isExpired()) {
            this.removeLock(token);
            return null;
        }
        return token;
    }

    private void removeLock(LockToken token) {
        log.debug("removeLock: " + token.tokenId);
        String sCurrentLock = this.locksByToken.get(token.tokenId);
        if (sCurrentLock != null) {
            CurrentLock currentLock = SimpleLockManager.toCurrentLock(sCurrentLock);
            this.locksByUniqueId.remove(currentLock.id);
            this.locksByToken.remove(currentLock.token.tokenId);
        } else {
            log.warn("couldnt find lock: " + token.tokenId);
        }
    }

    public LockToken getCurrentToken(LockableResource r) {
        if (r == null) {
            return null;
        }
        if (r.getUniqueId() == null) {
            log.warn("No uniqueID for resource: " + r.getName() + " :: " + r.getClass());
            return null;
        }
        String sLock = this.locksByUniqueId.get(r.getUniqueId());
        if (sLock == null) {
            return null;
        }
        CurrentLock lock = SimpleLockManager.toCurrentLock(sLock);
        if (lock == null) {
            return null;
        }
        LockToken token = new LockToken();
        token.info = new LockInfo(LockInfo.LockScope.EXCLUSIVE, LockInfo.LockType.WRITE, lock.lockedByUser, LockInfo.LockDepth.ZERO);
        token.info.lockedByUser = lock.lockedByUser;
        token.timeout = lock.token.timeout;
        token.tokenId = lock.token.tokenId;
        return token;
    }

    public Map<String, String> getLocksByUniqueId() {
        return this.locksByUniqueId;
    }

    public void clearLocks() {
        log.warn("CLEARING LOCKS!!!");
        this.locksByToken.clear();
        this.locksByUniqueId.clear();
    }

    public static class CurrentLock {
        final String id;
        final LockToken token;
        final String lockedByUser;

        public CurrentLock(String uniqueId, LockToken token, String lockedByUser) {
            this.id = uniqueId;
            this.token = token;
            this.lockedByUser = lockedByUser;
        }

        public CurrentLock(String uniqueId, String tokenId, Date from, String lockedByUser, Long seconds) {
            this.id = uniqueId;
            this.lockedByUser = lockedByUser;
            LockTimeout timeout = new LockTimeout(seconds);
            LockInfo info = new LockInfo(LockInfo.LockScope.EXCLUSIVE, LockInfo.LockType.WRITE, lockedByUser, LockInfo.LockDepth.ZERO);
            this.token = new LockToken(tokenId, info, timeout);
            this.token.setFrom(from);
        }

        public String toString() {
            return SimpleLockManager.toString(this);
        }
    }
}

