/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.fs;

import io.milton.http.Auth;
import io.milton.http.Request;
import io.milton.http.SecurityManager;
import io.milton.http.http11.auth.DigestGenerator;
import io.milton.http.http11.auth.DigestResponse;
import io.milton.resource.Resource;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleSecurityManager
implements SecurityManager {
    private static final Logger log = LoggerFactory.getLogger(SimpleSecurityManager.class);
    private String realm;
    private Map<String, String> nameAndPasswords;
    private DigestGenerator digestGenerator;

    public SimpleSecurityManager() {
        this.digestGenerator = new DigestGenerator();
    }

    public SimpleSecurityManager(DigestGenerator digestGenerator) {
        this.digestGenerator = digestGenerator;
    }

    public SimpleSecurityManager(String realm, Map<String, String> nameAndPasswords) {
        this.realm = realm;
        this.nameAndPasswords = nameAndPasswords;
        this.digestGenerator = new DigestGenerator();
    }

    public Object getUserByName(String name) {
        String actualPassword = this.nameAndPasswords.get(name);
        if (actualPassword != null) {
            return name;
        }
        return null;
    }

    @Override
    public Object authenticate(String user, String password) {
        String actualPassword;
        log.debug("authenticate: " + user + " - " + password);
        if (user.contains("@")) {
            user = user.substring(0, user.indexOf("@"));
        }
        if ((actualPassword = this.nameAndPasswords.get(user)) == null) {
            log.debug("user not found: " + user);
            return null;
        }
        return actualPassword.equals(password) ? user : null;
    }

    @Override
    public Object authenticate(DigestResponse digestRequest) {
        String clientResponse;
        if (this.digestGenerator == null) {
            throw new RuntimeException("No digest generator is configured");
        }
        String actualPassword = this.nameAndPasswords.get(digestRequest.getUser());
        String serverResponse = this.digestGenerator.generateDigest(digestRequest, actualPassword);
        if (serverResponse.equals(clientResponse = digestRequest.getResponseDigest())) {
            return "ok";
        }
        return null;
    }

    @Override
    public boolean authorise(Request request, Request.Method method, Auth auth, Resource resource) {
        if (auth == null) {
            log.trace("authorise: declining because there is no auth object");
            return false;
        }
        if (auth.getTag() == null) {
            log.trace("authorise: declining because there is no auth.getTag() object");
            return false;
        }
        log.trace("authorise: permitting because there is an authenticated user associated with this request");
        return true;
    }

    @Override
    public String getRealm(String host) {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public void setNameAndPasswords(Map<String, String> nameAndPasswords) {
        this.nameAndPasswords = nameAndPasswords;
    }

    public void setDigestGenerator(DigestGenerator digestGenerator) {
        this.digestGenerator = digestGenerator;
    }

    @Override
    public boolean isDigestAllowed() {
        return this.digestGenerator != null;
    }

    public DigestGenerator getDigestGenerator() {
        return this.digestGenerator;
    }
}

