/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.http11.auth;

import io.milton.http.Auth;
import io.milton.http.Request;
import io.milton.http.SecurityManager;
import io.milton.http.http11.auth.DigestResponse;
import io.milton.resource.Resource;
import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapSecurityManager
implements SecurityManager {
    private static final Logger log = LoggerFactory.getLogger(LdapSecurityManager.class);
    private String ldapUrl = "LDAP://localhost/CN=App1,DC=FM,DC=COM";
    private String realm = "aRealm";
    private boolean enableDigest = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object authenticate(DigestResponse digestRequest) {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", this.ldapUrl);
        env.put("java.naming.security.authentication", "DIGEST-MD5");
        env.put("java.naming.security.principal", digestRequest.getUser());
        env.put("java.naming.security.credentials", digestRequest.getResponseDigest());
        InitialDirContext ctx = null;
        try {
            InitialDirContext initialDirContext = ctx = new InitialDirContext(env);
            return initialDirContext;
        }
        catch (NamingException ex) {
            log.warn("login failed", (Throwable)ex);
            Object var5_6 = null;
            return var5_6;
        }
        finally {
            this.close(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object authenticate(String user, String password) {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", this.ldapUrl);
        env.put("java.naming.security.principal", user);
        env.put("java.naming.security.credentials", password);
        InitialDirContext ctx = null;
        try {
            InitialDirContext initialDirContext = ctx = new InitialDirContext(env);
            return initialDirContext;
        }
        catch (NamingException ex) {
            ex.printStackTrace();
            Object var6_7 = null;
            return var6_7;
        }
        finally {
            this.close(ctx);
        }
    }

    @Override
    public boolean authorise(Request request, Request.Method method, Auth auth, Resource resource) {
        DirContext ctx = (DirContext)auth.getTag();
        return ctx != null;
    }

    @Override
    public String getRealm(String host) {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    @Override
    public boolean isDigestAllowed() {
        return this.enableDigest;
    }

    public void setEnableDigest(boolean enableDigest) {
        this.enableDigest = enableDigest;
    }

    public boolean isEnableDigest() {
        return this.enableDigest;
    }

    public String getLdapUrl() {
        return this.ldapUrl;
    }

    public void setLdapUrl(String ldapUrl) {
        this.ldapUrl = ldapUrl;
    }

    private void close(DirContext ctx) {
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
    }
}

