/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.json;

import io.milton.event.Event;
import io.milton.event.EventManager;
import io.milton.event.NewFolderEvent;
import io.milton.http.FileItem;
import io.milton.http.Range;
import io.milton.http.Request;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.ConflictException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.json.JsonResource;
import io.milton.resource.CollectionResource;
import io.milton.resource.MakeCollectionableResource;
import io.milton.resource.PostableResource;
import io.milton.resource.Resource;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MkcolJsonResource
extends JsonResource
implements PostableResource {
    private static final Logger log = LoggerFactory.getLogger(MkcolJsonResource.class);
    private final MakeCollectionableResource wrapped;
    private final String href;
    private final EventManager eventManager;

    public MkcolJsonResource(MakeCollectionableResource makeCollectionableResource, String href, EventManager eventManager) {
        super((Resource)makeCollectionableResource, Request.Method.PUT.code, null);
        this.eventManager = eventManager;
        this.wrapped = makeCollectionableResource;
        this.href = href;
    }

    public String processForm(Map<String, String> parameters, Map<String, FileItem> files) throws BadRequestException, NotAuthorizedException {
        try {
            CollectionResource col = this.wrapped.createCollection(parameters.get("name"));
            if (this.eventManager != null) {
                this.eventManager.fireEvent((Event)new NewFolderEvent(col));
            }
            return null;
        }
        catch (ConflictException ex) {
            throw new BadRequestException((Resource)this.wrapped, "A conflict occured. The folder might already exist");
        }
    }

    public void sendContent(OutputStream out, Range range, Map<String, String> params, String contentType) throws IOException, NotAuthorizedException, BadRequestException {
    }

    @Override
    public Request.Method applicableMethod() {
        return Request.Method.MKCOL;
    }
}

