/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.report;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class ReportUtils {
    public static Element find(Element root, String name, Namespace ns) {
        Element elChild;
        for (Object child : root.getChildren()) {
            if (!(child instanceof Element) || !(elChild = (Element)child).getName().equals(name) || ns != null && !ns.getURI().equals(elChild.getNamespaceURI())) continue;
            return elChild;
        }
        for (Object child : root.getChildren()) {
            Element found;
            if (!(child instanceof Element) || (found = ReportUtils.find(elChild = (Element)child, name, ns)) == null) continue;
            return found;
        }
        return null;
    }

    public static List<Element> findAll(Element root, String name, Namespace ns) {
        ArrayList<Element> list = new ArrayList<Element>();
        ReportUtils._findAll(root, name, ns, list);
        return list;
    }

    private static void _findAll(Element root, String name, Namespace ns, List<Element> list) {
        Element elChild;
        for (Object child : root.getChildren()) {
            if (!(child instanceof Element) || !(elChild = (Element)child).getName().equals(name) || ns != null && !ns.getURI().equals(elChild.getNamespaceURI())) continue;
            list.add(elChild);
        }
        for (Object child : root.getChildren()) {
            if (!(child instanceof Element)) continue;
            elChild = (Element)child;
            ReportUtils._findAll(elChild, name, ns, list);
        }
    }

    public static Element findRecursively(Element node, String name) {
        List list = node.getChildren();
        Iterator itr = list.iterator();
        Element childElement = null;
        while (itr.hasNext()) {
            childElement = (Element)itr.next();
            if (!name.equals(childElement.getName())) continue;
            return childElement;
        }
        if (childElement == null) {
            return null;
        }
        return ReportUtils.findRecursively(childElement, name);
    }

    public static Set<QName> getProps(Document doc, Namespace propNs) {
        Element elProp = doc.getRootElement().getChild("prop", propNs);
        if (elProp == null) {
            throw new RuntimeException("No prop element");
        }
        HashSet<QName> set = new HashSet<QName>();
        for (Object o : elProp.getChildren()) {
            if (!(o instanceof Element)) continue;
            Element el = (Element)o;
            String local = el.getName();
            String ns = el.getNamespaceURI();
            set.add(new QName(ns, local, el.getNamespacePrefix()));
        }
        return set;
    }
}

