/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.webdav;

import io.milton.common.LogUtils;
import io.milton.common.Utils;
import io.milton.http.Response;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.values.ValueAndType;
import io.milton.http.webdav.PropFindPropertyBuilder;
import io.milton.http.webdav.PropFindResponse;
import io.milton.http.webdav.PropertiesRequest;
import io.milton.property.PropertySource;
import io.milton.resource.CollectionResource;
import io.milton.resource.PropFindableResource;
import io.milton.resource.Resource;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPropFindPropertyBuilder
implements PropFindPropertyBuilder {
    private static final Logger log = LoggerFactory.getLogger(DefaultPropFindPropertyBuilder.class);
    private final List<PropertySource> propertySources;

    public DefaultPropFindPropertyBuilder(List<PropertySource> propertySources) {
        this.propertySources = propertySources;
    }

    @Override
    public List<PropFindResponse> buildProperties(PropFindableResource pfr, int depth, PropertiesRequest parseResult, String url) throws URISyntaxException, NotAuthorizedException, BadRequestException {
        LogUtils.trace((Logger)log, (Object[])new Object[]{"buildProperties: ", pfr.getClass(), "url:", url});
        url = DefaultPropFindPropertyBuilder.fixUrlForWindows(url);
        ArrayList<PropFindResponse> propFindResponses = new ArrayList<PropFindResponse>();
        this.appendResponses(propFindResponses, pfr, depth, parseResult, url);
        return propFindResponses;
    }

    @Override
    public ValueAndType getProperty(QName field, Resource resource) throws NotAuthorizedException, BadRequestException {
        for (PropertySource source : this.propertySources) {
            PropertySource.PropertyMetaData meta = source.getPropertyMetaData(field, resource);
            if (meta == null || meta.isUnknown()) continue;
            Object val = source.getProperty(field, resource);
            return new ValueAndType(val, meta.getValueType());
        }
        LogUtils.trace((Logger)log, (Object[])new Object[]{"getProperty: property not found", field, "resource", resource.getClass(), "property sources", this.propertySources});
        return null;
    }

    private void appendResponses(List<PropFindResponse> responses, PropFindableResource resource, int requestedDepth, PropertiesRequest parseResult, String encodedCollectionUrl) throws URISyntaxException, NotAuthorizedException, BadRequestException {
        String collectionHref = this.suffixSlash(resource, encodedCollectionUrl);
        URI parentUri = new URI(collectionHref);
        collectionHref = parentUri.toASCIIString();
        this.processResource(responses, resource, parseResult, collectionHref, requestedDepth, 0, collectionHref);
    }

    @Override
    public void processResource(List<PropFindResponse> responses, PropFindableResource resource, PropertiesRequest parseResult, String href, int requestedDepth, int currentDepth, String collectionHref) throws NotAuthorizedException, BadRequestException {
        LinkedHashMap<QName, ValueAndType> knownProperties = new LinkedHashMap<QName, ValueAndType>();
        ArrayList<PropFindResponse.NameAndError> unknownProperties = new ArrayList<PropFindResponse.NameAndError>();
        if (resource instanceof CollectionResource && !((String)href).endsWith("/")) {
            href = (String)href + "/";
        }
        boolean isPropname = parseResult.isPropname();
        Set<QName> requestedFields = parseResult.isAllProp() || isPropname ? this.findAllProps(resource) : parseResult.getNames();
        for (QName field : requestedFields) {
            LogUtils.trace((Logger)log, (Object[])new Object[]{"processResource: find property:", field});
            if (field.getLocalPart().equals("href")) {
                knownProperties.put(field, isPropname ? null : new ValueAndType(href, String.class));
                continue;
            }
            boolean found = false;
            for (PropertySource source : this.propertySources) {
                LogUtils.trace((Logger)log, (Object[])new Object[]{"look for field", field, " in property source", source.getClass()});
                PropertySource.PropertyMetaData meta = source.getPropertyMetaData(field, (Resource)resource);
                if (meta == null || meta.isUnknown()) continue;
                try {
                    if (isPropname) {
                        knownProperties.put(field, null);
                    } else {
                        Object val = source.getProperty(field, (Resource)resource);
                        LogUtils.trace((Logger)log, (Object[])new Object[]{"processResource: got value", val, "from source", source.getClass()});
                        if (val == null) {
                            knownProperties.put(field, new ValueAndType(val, meta.getValueType()));
                        } else {
                            knownProperties.put(field, new ValueAndType(val, val.getClass()));
                        }
                    }
                }
                catch (NotAuthorizedException ex) {
                    unknownProperties.add(new PropFindResponse.NameAndError(field, "Not authorised"));
                }
                found = true;
                break;
            }
            if (found) continue;
            if (log.isDebugEnabled()) {
                log.debug("property not found in any property source: " + field.toString());
            }
            unknownProperties.add(new PropFindResponse.NameAndError(field, null));
        }
        if (log.isDebugEnabled() && unknownProperties.size() > 0) {
            log.debug("some properties could not be resolved. Listing property sources:");
            for (PropertySource ps : this.propertySources) {
                log.debug(" - " + ps.getClass().getCanonicalName());
            }
        }
        EnumMap<Response.Status, ArrayList<PropFindResponse.NameAndError>> errorProperties = new EnumMap<Response.Status, ArrayList<PropFindResponse.NameAndError>>(Response.Status.class);
        errorProperties.put(Response.Status.SC_NOT_FOUND, unknownProperties);
        PropFindResponse r = new PropFindResponse((String)href, knownProperties, errorProperties);
        responses.add(r);
        if (requestedDepth > currentDepth && resource instanceof CollectionResource) {
            CollectionResource col = (CollectionResource)resource;
            for (Resource child : Optional.ofNullable(col.getChildren()).orElse(List.of())) {
                if (!(child instanceof PropFindableResource)) continue;
                String childName = child.getName();
                if (childName == null) {
                    log.warn("null name for resource of type: " + child.getClass() + " in folder: " + (String)href + " WILL NOT be returned in PROPFIND response!!");
                    continue;
                }
                String childHref = (String)href + Utils.percentEncode((String)childName);
                this.processResource(responses, (PropFindableResource)child, parseResult, childHref, requestedDepth, currentDepth + 1, (String)href);
            }
        }
    }

    private String suffixSlash(PropFindableResource resource, String s) {
        if (resource instanceof CollectionResource && !((String)s).endsWith("/")) {
            s = (String)s + "/";
        }
        return s;
    }

    @Override
    public Set<QName> findAllProps(PropFindableResource resource) throws NotAuthorizedException, BadRequestException {
        LinkedHashSet<QName> names = new LinkedHashSet<QName>();
        for (PropertySource source : this.propertySources) {
            List allprops = source.getAllPropertyNames((Resource)resource);
            if (allprops == null) continue;
            names.addAll(allprops);
        }
        return names;
    }

    public static String fixUrlForWindows(String url) {
        return url.replace("&", "%26");
    }
}

