/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.webdav;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;

public class PropertiesRequest {
    private final boolean allProp;
    private final boolean propname;
    private final Map<QName, Property> properties;

    public static PropertiesRequest toProperties(Set<QName> set) {
        HashSet<Property> props = new HashSet<Property>();
        for (QName n : set) {
            props.add(new Property(n, null));
        }
        return new PropertiesRequest(props);
    }

    public PropertiesRequest(boolean allProp, boolean propname) {
        this.allProp = allProp;
        this.propname = propname;
        this.properties = new HashMap<QName, Property>();
    }

    public PropertiesRequest(Collection<Property> set) {
        this.allProp = false;
        this.propname = false;
        this.properties = new HashMap<QName, Property>();
        for (Property p : set) {
            this.properties.put(p.getName(), p);
        }
    }

    public Property get(QName name) {
        return this.properties.get(name);
    }

    public void add(QName name) {
        this.properties.put(name, new Property(name, null));
    }

    public boolean isAllProp() {
        return this.allProp;
    }

    public boolean isPropname() {
        return this.propname;
    }

    public Set<QName> getNames() {
        return this.properties.keySet();
    }

    public Collection<Property> getProperties() {
        return this.properties.values();
    }

    public static class Property {
        private final QName name;
        private final Map<QName, Property> nested;

        public Property(QName name, Set<Property> nestedSet) {
            this.name = name;
            this.nested = new HashMap<QName, Property>();
            if (nestedSet != null) {
                for (Property p : nestedSet) {
                    this.nested.put(p.name, p);
                }
            }
        }

        public QName getName() {
            return this.name;
        }

        public Collection<Property> getNested() {
            return this.nested.values();
        }

        public Map<QName, Property> getNestedMap() {
            return this.nested;
        }
    }
}

