/*
 * Decompiled with CFR 0.152.
 */
package io.milton.ldap;

import com.sun.jndi.ldap.BerDecoder;
import io.milton.common.LogUtils;
import io.milton.ldap.CompoundLdapFilter;
import io.milton.ldap.Conditions;
import io.milton.ldap.LdapFilter;
import io.milton.ldap.LdapPrincipal;
import io.milton.ldap.LdapPropertyMapper;
import io.milton.ldap.LdapResponseHandler;
import io.milton.ldap.SimpleLdapFilter;
import io.milton.ldap.UserFactory;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapParser {
    private static final Logger log = LoggerFactory.getLogger(LdapParser.class);
    private final LdapPropertyMapper propertyMapper;
    private final LdapResponseHandler helper;
    private final UserFactory userFactory;
    private final Conditions conditions;

    public LdapParser(LdapPropertyMapper propertyMapper, LdapResponseHandler helper, UserFactory userFactory) {
        this.propertyMapper = propertyMapper;
        this.helper = helper;
        this.userFactory = userFactory;
        this.conditions = new Conditions(propertyMapper);
    }

    public LdapFilter parseFilter(BerDecoder reqBer, LdapPrincipal user, String userName) throws IOException {
        LdapFilter ldapFilter;
        if (reqBer.peekByte() == 135) {
            String attributeName = reqBer.parseStringWithTag(135, this.helper.isLdapV3(), null).toLowerCase();
            ldapFilter = new SimpleLdapFilter(this.propertyMapper, this.userFactory, attributeName);
        } else {
            int[] seqSize = new int[1];
            int ldapFilterType = reqBer.parseSeq(seqSize);
            int end = reqBer.getParsePosition() + seqSize[0];
            ldapFilter = this.parseNestedFilter(reqBer, ldapFilterType, end, user, userName);
        }
        return ldapFilter;
    }

    private LdapFilter parseNestedFilter(BerDecoder reqBer, int ldapFilterType, int end, LdapPrincipal user, String userName) throws IOException {
        LdapFilter nestedFilter;
        if (ldapFilterType == 161 || ldapFilterType == 160 || ldapFilterType == 162) {
            nestedFilter = new CompoundLdapFilter(this.conditions, ldapFilterType);
            while (reqBer.getParsePosition() < end && reqBer.bytesLeft() > 0) {
                if (reqBer.peekByte() == 135) {
                    String attributeName = reqBer.parseStringWithTag(135, this.helper.isLdapV3(), null).toLowerCase();
                    nestedFilter.add(new SimpleLdapFilter(this.propertyMapper, this.userFactory, attributeName));
                    continue;
                }
                int[] seqSize = new int[1];
                int ldapFilterOperator = reqBer.parseSeq(seqSize);
                int subEnd = reqBer.getParsePosition() + seqSize[0];
                LdapFilter f2 = this.parseNestedFilter(reqBer, ldapFilterOperator, subEnd, user, userName);
                nestedFilter.add(f2);
            }
        } else {
            nestedFilter = this.parseSimpleFilter(reqBer, ldapFilterType, user, userName);
        }
        return nestedFilter;
    }

    private LdapFilter parseSimpleFilter(BerDecoder reqBer, int ldapFilterOperator, LdapPrincipal user, String userName) throws IOException {
        String attributeName = reqBer.parseString(this.helper.isLdapV3()).toLowerCase();
        int ldapFilterMode = 0;
        StringBuilder value = new StringBuilder();
        if (ldapFilterOperator == 164) {
            int[] seqSize = new int[1];
            reqBer.parseSeq(seqSize);
            int end = reqBer.getParsePosition() + seqSize[0];
            while (reqBer.getParsePosition() < end && reqBer.bytesLeft() > 0) {
                ldapFilterMode = reqBer.peekByte();
                if (value.length() > 0) {
                    value.append(' ');
                }
                value.append(reqBer.parseStringWithTag(ldapFilterMode, this.helper.isLdapV3(), null));
            }
        } else if (ldapFilterOperator == 163) {
            value.append(reqBer.parseString(this.helper.isLdapV3()));
        } else {
            log.warn("LOG_LDAP_UNSUPPORTED_FILTER_VALUE");
        }
        String sValue = value.toString();
        if ("uid".equalsIgnoreCase(attributeName) && sValue.equals(userName) && sValue.equals(userName)) {
            sValue = user.getName();
            LogUtils.debug((Logger)log, (Object[])new Object[]{"LOG_LDAP_REPLACED_UID_FILTER", userName, sValue});
        }
        return new SimpleLdapFilter(this.propertyMapper, this.userFactory, attributeName, sValue, ldapFilterOperator, ldapFilterMode);
    }

    public Set<String> parseReturningAttributes(BerDecoder reqBer) throws IOException {
        HashSet<String> returningAttributes = new HashSet<String>();
        int[] seqSize = new int[1];
        reqBer.parseSeq(seqSize);
        int end = reqBer.getParsePosition() + seqSize[0];
        while (reqBer.getParsePosition() < end && reqBer.bytesLeft() > 0) {
            returningAttributes.add(reqBer.parseString(this.helper.isLdapV3()).toLowerCase());
        }
        return returningAttributes;
    }
}

