/*
 * Decompiled with CFR 0.152.
 */
package io.milton.servlet;

import io.milton.http.AbstractResponse;
import io.milton.http.BeanCookie;
import io.milton.http.Cookie;
import io.milton.http.Response;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletResponse
extends AbstractResponse {
    private static final Logger log = LoggerFactory.getLogger(ServletResponse.class);
    private static final ThreadLocal<HttpServletResponse> tlResponse = new ThreadLocal();
    private final HttpServletResponse r;
    private Response.Status status;
    private final Map<String, String> headers = new HashMap<String, String>();

    public static HttpServletResponse getResponse() {
        return tlResponse.get();
    }

    public ServletResponse(HttpServletResponse r) {
        this.r = r;
        tlResponse.set(r);
    }

    @Override
    protected void setAnyDateHeader(Response.Header name, Date date) {
        if (date != null) {
            this.r.setDateHeader(name.code, date.getTime());
        } else {
            this.r.setHeader(name.code, null);
        }
    }

    public String getNonStandardHeader(String code) {
        return this.headers.get(code);
    }

    public void setNonStandardHeader(String name, String value) {
        this.r.addHeader(name, value);
        this.headers.put(name, value);
    }

    public void setStatus(Response.Status status) {
        this.r.setStatus(status.code);
        this.status = status;
    }

    public Response.Status getStatus() {
        return this.status;
    }

    public OutputStream getOutputStream() {
        try {
            return this.r.getOutputStream();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void close() {
        try {
            this.r.flushBuffer();
        }
        catch (Throwable ex) {
            log.trace("exception closing and flushing", ex);
        }
    }

    public void sendError(Response.Status status, String message) {
        log.warn("sendError: " + status);
        try {
            this.r.sendError(status.code, message);
        }
        catch (IOException ex) {
            log.error("Failed to send error", (Throwable)ex);
        }
        try {
            this.r.getOutputStream().close();
            log.info("Closed outputstream after sendError");
        }
        catch (IOException e) {
            log.warn("Failed to close outputstream after sendError");
        }
    }

    @Override
    public void sendRedirect(String url) {
        String u = this.r.encodeRedirectURL(url);
        try {
            this.r.sendRedirect(u);
        }
        catch (IOException ex) {
            log.warn("exception sending redirect", (Throwable)ex);
        }
    }

    public Map<String, String> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    public void setAuthenticateHeader(List<String> challenges) {
        for (String ch : challenges) {
            this.r.addHeader(Response.Header.WWW_AUTHENTICATE.code, ch);
        }
    }

    public Cookie setCookie(Cookie cookie) {
        String h = BeanCookie.toHeader((Cookie)cookie);
        this.r.addHeader("Set-Cookie", h);
        return cookie;
    }

    public Cookie setCookie(String name, String value) {
        BeanCookie c = new BeanCookie(name);
        c.setValue(value);
        c.setPath("/");
        this.setCookie((Cookie)c);
        return c;
    }
}

