/*
 * Decompiled with CFR 0.152.
 */
package io.milton.servlet;

import io.milton.http.HttpManager;
import io.milton.servlet.ServletRequest;
import io.milton.servlet.ServletResponse;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringAwareMiltonServlet
implements Servlet {
    private final Logger log = LoggerFactory.getLogger(SpringAwareMiltonServlet.class);
    ServletConfig config;
    ApplicationContext context;
    HttpManager httpManager;
    private ServletContext servletContext;
    private static final ThreadLocal<HttpServletRequest> originalRequest = new ThreadLocal();
    private static final ThreadLocal<HttpServletResponse> originalResponse = new ThreadLocal();

    public static HttpServletRequest request() {
        return originalRequest.get();
    }

    public static HttpServletResponse response() {
        return originalResponse.get();
    }

    public static void forward(String url) {
        try {
            SpringAwareMiltonServlet.request().getRequestDispatcher(url).forward((jakarta.servlet.ServletRequest)originalRequest.get(), (jakarta.servlet.ServletResponse)originalResponse.get());
        }
        catch (ServletException | IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void init(ServletConfig config) throws ServletException {
        try {
            this.config = config;
            this.servletContext = config.getServletContext();
            this.context = new ClassPathXmlApplicationContext(new String[]{"applicationContext.xml"});
            this.httpManager = (HttpManager)this.context.getBean("milton.http.manager");
        }
        catch (Throwable ex) {
            this.log.error("Exception starting milton servlet", ex);
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(jakarta.servlet.ServletRequest servletRequest, jakarta.servlet.ServletResponse servletResponse) throws ServletException, IOException {
        HttpServletRequest req = (HttpServletRequest)servletRequest;
        HttpServletResponse resp = (HttpServletResponse)servletResponse;
        try {
            originalRequest.set(req);
            originalResponse.set(resp);
            ServletRequest request = new ServletRequest(req, this.servletContext);
            ServletResponse response = new ServletResponse(resp);
            this.httpManager.process(request, response);
        }
        finally {
            originalRequest.remove();
            originalResponse.remove();
            ServletRequest.clearThreadLocals();
            servletResponse.getOutputStream().flush();
            servletResponse.flushBuffer();
        }
    }

    public String getServletInfo() {
        return "SpringAwareMiltonServlet";
    }

    public ServletConfig getServletConfig() {
        return this.config;
    }

    public void destroy() {
    }
}

