/*
 * Decompiled with CFR 0.152.
 */
package io.milton.servlet;

import io.milton.config.HttpManagerBuilder;
import io.milton.http.HttpManager;
import io.milton.http.ResourceFactory;
import io.milton.http.webdav.WebDavResponseHandler;
import io.milton.servlet.Config;
import io.milton.servlet.MiltonConfigurator;
import jakarta.servlet.ServletException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringResourceFactoryFactory
implements MiltonConfigurator {
    ApplicationContext context;
    private final HttpManagerBuilder configurer = new HttpManagerBuilder();
    private HttpManager httpManager;

    @Override
    public HttpManager configure(Config config) throws ServletException {
        this.context = new ClassPathXmlApplicationContext(new String[]{"applicationContext.xml"});
        ResourceFactory rf = (ResourceFactory)this.context.getBean("milton.resource.factory");
        WebDavResponseHandler davResponseHandler = (WebDavResponseHandler)this.context.getBean("milton.response.handler");
        this.configurer.setMainResourceFactory(rf);
        this.configurer.setWebdavResponseHandler(davResponseHandler);
        this.httpManager = this.configurer.buildHttpManager();
        return this.httpManager;
    }

    @Override
    public void shutdown() {
        if (this.httpManager != null) {
            this.httpManager.shutdown();
        }
    }
}

