/*
 * Decompiled with CFR 0.152.
 */
package io.milton.servlet;

import io.milton.servlet.MiltonUtils;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticResourceFilter
implements Filter {
    private final Logger log = LoggerFactory.getLogger(StaticResourceFilter.class);
    private FilterConfig filterConfig = null;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        Object s = MiltonUtils.stripContext(req);
        this.log.debug("url: " + (String)s);
        s = "WEB-INF/static/" + (String)s;
        this.log.debug("check path: " + (String)s);
        String path = this.filterConfig.getServletContext().getRealPath((String)s);
        this.log.debug("real path: " + path);
        File f = null;
        if (path != null && path.length() > 0) {
            f = new File(path);
        }
        if (f != null && f.exists() && !f.isDirectory()) {
            this.log.debug("static file exists. forwarding..");
            req.getRequestDispatcher((String)s).forward(request, response);
        } else {
            this.log.debug("static file does not exist, continuing chain..");
            chain.doFilter(request, response);
        }
    }

    public FilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    public void destroy() {
    }

    public void init(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
    }
}

