/*
 * Decompiled with CFR 0.152.
 */
package io.milton.ftp;

import io.milton.common.Path;
import io.milton.ftp.MiltonFtpFile;
import io.milton.ftp.MiltonUser;
import io.milton.http.ResourceFactory;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.resource.CollectionResource;
import io.milton.resource.Resource;
import org.apache.ftpserver.ftplet.FileSystemView;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiltonFsView
implements FileSystemView {
    private static final Logger log = LoggerFactory.getLogger(MiltonFsView.class);
    private final String host;
    private final Path homePath;
    private final ResourceFactory resourceFactory;
    private final MiltonUser user;
    private Path currentPath;

    public MiltonFsView(Path homePath, String host, ResourceFactory resourceFactory, MiltonUser user) {
        this.user = user;
        if (homePath.isRelative()) {
            throw new IllegalArgumentException("homePath must be absolute");
        }
        this.host = host;
        this.homePath = homePath;
        this.currentPath = homePath;
        this.resourceFactory = resourceFactory;
    }

    public FtpFile getHomeDirectory() throws FtpException {
        try {
            Resource home = this.resourceFactory.getResource(this.host, this.homePath.toString());
            return this.wrap(this.homePath, home);
        }
        catch (BadRequestException | NotAuthorizedException ex) {
            throw new FtpException(ex);
        }
    }

    public FtpFile getWorkingDirectory() throws FtpException {
        return this.wrap(this.currentPath, (Resource)this.getWorkingDir());
    }

    public boolean changeWorkingDirectory(String dir) throws FtpException {
        try {
            log.debug("cd: " + dir + " from " + this.currentPath);
            Path p = this.evaluateRelativePath(this.currentPath, dir);
            ResourceAndPath rp = this.getResource(p);
            if (rp.resource == null) {
                log.debug("not found: " + p);
                return false;
            }
            if (rp.resource instanceof CollectionResource) {
                this.currentPath = rp.path;
                log.debug("currentPath is now: " + this.currentPath);
                return true;
            }
            log.debug("not a collection: " + rp.resource.getName());
            return false;
        }
        catch (BadRequestException | NotAuthorizedException ex) {
            throw new FtpException(ex);
        }
    }

    public FtpFile getFile(String path) throws FtpException {
        try {
            log.debug("getFile: " + (String)path);
            if (((String)path).startsWith(".")) {
                path = this.currentPath.toString() + ((String)path).substring(1);
                log.debug("getFile2: " + (String)path);
            }
            Path p = Path.path((String)path);
            ResourceAndPath rp = this.getResource(p);
            if (rp.resource == null) {
                log.debug("returning new file");
                return new MiltonFtpFile(this, rp.path, this.getWorkingDir(), null, this.user);
            }
            return new MiltonFtpFile(this, rp.path, rp.resource, this.user);
        }
        catch (BadRequestException | NotAuthorizedException ex) {
            throw new FtpException(ex);
        }
    }

    private CollectionResource getWorkingDir() throws FtpException {
        try {
            Resource working = this.resourceFactory.getResource(this.host, this.currentPath.toString());
            if (working instanceof CollectionResource) {
                return (CollectionResource)working;
            }
            return null;
        }
        catch (BadRequestException | NotAuthorizedException e) {
            throw new FtpException(e);
        }
    }

    public boolean isRandomAccessible() throws FtpException {
        return true;
    }

    public void dispose() {
    }

    public ResourceAndPath getResource(Path p) throws NotAuthorizedException, BadRequestException {
        log.debug("getResource: " + p);
        if (p.isRelative()) {
            p = Path.path((String)(this.currentPath.toString() + "/" + p.toString()));
            Resource r = this.resourceFactory.getResource(this.user.domain, p.toString());
            return new ResourceAndPath(r, p);
        }
        Resource r = this.resourceFactory.getResource(this.user.domain, p.toString());
        return new ResourceAndPath(r, p);
    }

    public FtpFile wrap(Path path, Resource r) {
        return new MiltonFtpFile(this, path, r, this.user);
    }

    private Path evaluateRelativePath(Path currentPath, String dir) {
        Path changeTo = Path.path((String)dir);
        if (changeTo.isRelative()) {
            Path p = currentPath;
            for (String part : changeTo.getParts()) {
                if (part.equals("..")) {
                    p = p.getParent();
                    continue;
                }
                if (part.equals(".")) continue;
                p = p.child(part);
            }
            return p;
        }
        return changeTo;
    }

    public static class ResourceAndPath {
        final Resource resource;
        final Path path;

        public ResourceAndPath(Resource r, Path p) {
            if (p == null) {
                throw new IllegalArgumentException("path may not be null");
            }
            if (p.isRelative()) {
                throw new IllegalArgumentException("path must be absolute");
            }
            this.resource = r;
            this.path = p;
        }
    }
}

