/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.annotated;

import io.milton.annotations.AccessControlList;
import io.milton.annotations.Post;
import io.milton.http.Auth;
import io.milton.http.HttpManager;
import io.milton.http.Request;
import io.milton.http.annotated.AbstractAnnotationHandler;
import io.milton.http.annotated.AnnoCollectionResource;
import io.milton.http.annotated.AnnoResource;
import io.milton.http.annotated.AnnotationResourceFactory;
import io.milton.http.annotated.ControllerMethod;
import io.milton.resource.AccessControlledResource;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessControlListAnnotationHandler
extends AbstractAnnotationHandler {
    private static final Logger log = LoggerFactory.getLogger(AccessControlListAnnotationHandler.class);

    public AccessControlListAnnotationHandler(AnnotationResourceFactory outer) {
        super(outer, AccessControlList.class, new Request.Method[0]);
    }

    public Set<AccessControlledResource.Priviledge> availablePrivs(Object curUser, AnnoResource res, Auth auth) {
        Set<AccessControlledResource.Priviledge> privs = this.directPrivs(curUser, res, auth);
        if (privs != null) {
            return privs;
        }
        for (AnnoCollectionResource p = res.getParent(); p != null; p = p.getParent()) {
            privs = this.directPrivs(curUser, p, auth);
            if (privs == null) continue;
            return privs;
        }
        if (curUser != null) {
            log.info("No explicit AccessControl annotation found, so defaulting to full access for logged in user");
            privs = new HashSet<AccessControlledResource.Priviledge>();
            privs.add(AccessControlledResource.Priviledge.ALL);
        }
        return privs;
    }

    public Set<AccessControlledResource.Priviledge> directPrivs(Object curUser, AnnoResource res, Auth auth) {
        EnumSet<AccessControlledResource.Priviledge> acl = EnumSet.noneOf(AccessControlledResource.Priviledge.class);
        Object source = res.getSource();
        List<ControllerMethod> availMethods = this.getMethods(source.getClass());
        if (availMethods.isEmpty()) {
            log.warn("No ACL methods were found");
            return null;
        }
        try {
            for (ControllerMethod cm : availMethods) {
                this.addPrivsFromMethod(cm.method, cm.controller, acl, curUser, res, auth);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return acl;
    }

    private void addPrivsFromMethod(Method method, Object target, Set<AccessControlledResource.Priviledge> acl, Object curUser, AnnoResource res, Auth auth) throws Exception {
        Class<?> pt;
        Object currentUserSource = null;
        if (curUser != null) {
            if (curUser instanceof AnnoResource) {
                AnnoResource ar = (AnnoResource)curUser;
                currentUserSource = ar.getSource();
            } else {
                currentUserSource = curUser;
            }
        }
        if (method.getParameterTypes().length < 2) {
            return;
        }
        if (currentUserSource != null && !(pt = method.getParameterTypes()[1]).isAssignableFrom(currentUserSource.getClass())) {
            log.info("ACL method second arg {} is not assignable from current user type {}", pt, currentUserSource.getClass());
            return;
        }
        Object[] args = this.annoResourceFactory.buildInvokeArgsExt(res, currentUserSource, true, method, curUser, res, auth);
        Object result = method.invoke(target, args);
        if (result != null) {
            if (result instanceof Collection) {
                Collection col = (Collection)result;
                for (Object o : col) {
                    if (!(o instanceof AccessControlledResource.Priviledge)) continue;
                    AccessControlledResource.Priviledge p = (AccessControlledResource.Priviledge)o;
                    acl.add(p);
                }
            } else if (result instanceof AccessControlledResource.Priviledge) {
                AccessControlledResource.Priviledge p = (AccessControlledResource.Priviledge)result;
                acl.add(p);
            }
        }
    }

    public AccessControlledResource.Priviledge requiredPriv(AnnoResource res, Request.Method httpMethod, Request request) {
        if (httpMethod.equals((Object)Request.Method.POST)) {
            AccessControlledResource.Priviledge p = this.getRequiredPostPriviledge(request, res);
            if (p == null) {
                p = AccessControlledResource.Priviledge.READ_CONTENT;
            }
            return p;
        }
        if (httpMethod == Request.Method.ACL) {
            return AccessControlledResource.Priviledge.READ_ACL;
        }
        if (httpMethod == Request.Method.UNLOCK) {
            return AccessControlledResource.Priviledge.UNLOCK;
        }
        if (httpMethod == Request.Method.PROPFIND) {
            return AccessControlledResource.Priviledge.READ_PROPERTIES;
        }
        if (httpMethod.isWrite) {
            return AccessControlledResource.Priviledge.WRITE_CONTENT;
        }
        return AccessControlledResource.Priviledge.READ_CONTENT;
    }

    private AccessControlledResource.Priviledge getRequiredPostPriviledge(Request request, AnnoResource res) {
        ControllerMethod cm = this.annoResourceFactory.postAnnotationHandler.getPostMethod(res, request, HttpManager.request().getParams());
        if (cm == null) {
            return null;
        }
        Post p = cm.method.getAnnotation(Post.class);
        if (p != null) {
            return p.requiredPriviledge();
        }
        return null;
    }
}

