/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.annotated.scheduling;

import io.milton.http.annotated.CTagAnnotationHandler;
import io.milton.http.annotated.scheduling.BaseSchedulingResource;
import io.milton.http.caldav.CalendarSearchService;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.principal.CalDavPrincipal;
import io.milton.resource.CalendarCollection;
import io.milton.resource.PropFindableResource;
import io.milton.resource.Resource;
import java.util.Date;
import java.util.List;
import java.util.Optional;

public class SchedulingInboxResource
extends BaseSchedulingResource
implements CalendarCollection,
PropFindableResource {
    public SchedulingInboxResource(CalDavPrincipal principal, CalendarSearchService calendarSearchService, String name) {
        super(principal, calendarSearchService, name);
    }

    public Resource child(String childName) throws NotAuthorizedException, BadRequestException {
        for (Resource r : Optional.ofNullable(this.getChildren()).orElse(List.of())) {
            if (!r.getName().equals(childName)) continue;
            return r;
        }
        return null;
    }

    public List<? extends Resource> getChildren() throws NotAuthorizedException, BadRequestException {
        return this.calendarSearchService.findAttendeeResources(this.principal);
    }

    public String getCTag() {
        try {
            String ctag = this.calendarSearchService.findAttendeeResourcesCTag(this.principal);
            if (ctag == null) {
                ctag = CTagAnnotationHandler.deriveCtag(this);
            }
            return ctag;
        }
        catch (BadRequestException | NotAuthorizedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Date getCreateDate() {
        return this.principal.getCreateDate();
    }
}

