/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.webdav;

import io.milton.http.Response;
import io.milton.http.XmlWriter;
import io.milton.http.values.ValueAndType;
import io.milton.http.values.ValueWriters;
import io.milton.http.webdav.PropFindResponse;
import io.milton.http.webdav.WebDavProtocol;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.io.output.ByteArrayOutputStream;

public class PropFindXmlGeneratorHelper {
    private ValueWriters valueWriters;

    public PropFindXmlGeneratorHelper() {
    }

    public PropFindXmlGeneratorHelper(ValueWriters valueWriters) {
        this.valueWriters = valueWriters;
    }

    Map<String, String> findNameSpaces(List<PropFindResponse> propFindResponses) {
        int i = 1;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(WebDavProtocol.NS_DAV.getName(), WebDavProtocol.NS_DAV.getPrefix());
        map.put("urn:ietf:params:xml:ns:caldav", "cal");
        map.put("http://calendarserver.org/ns/", "cs");
        map.put("urn:ietf:params:xml:ns:carddav", "card");
        for (PropFindResponse r : propFindResponses) {
            for (QName p : r.getKnownProperties().keySet()) {
                String uri = p.getNamespaceURI();
                if (map.containsKey(uri)) continue;
                map.put(uri, "ns" + i++);
            }
        }
        return map;
    }

    String generateNamespaceDeclarations(Map<String, String> mapOfNamespaces) {
        StringBuilder decs = new StringBuilder();
        for (String uri : mapOfNamespaces.keySet()) {
            String prefix = mapOfNamespaces.get(uri);
            decs.append(" xmlns:").append(prefix).append("=\"").append(uri).append("\"");
        }
        return decs.toString();
    }

    void appendResponses(XmlWriter writer, List<PropFindResponse> propFindResponses, Map<String, String> mapOfNamespaces, boolean writeErrorProps) {
        for (PropFindResponse r : propFindResponses) {
            this.appendResponse(writer, r, mapOfNamespaces, writeErrorProps);
        }
    }

    public void appendResponse(XmlWriter writer, PropFindResponse r, Map<String, String> mapOfNamespaces, boolean writeErrorProps) {
        XmlWriter.Element el = writer.begin(WebDavProtocol.NS_DAV.getPrefix(), "response");
        el.open();
        writer.writeProperty(WebDavProtocol.NS_DAV.getPrefix(), "href", r.getHref());
        if (r.getStatus() != null) {
            writer.writeProperty(WebDavProtocol.NS_DAV.getPrefix(), "status", r.getStatus().toString());
        } else {
            this.sendKnownProperties(writer, mapOfNamespaces, r.getKnownProperties(), r.getHref());
            if (r.getErrorProperties() != null && writeErrorProps) {
                for (Response.Status status : r.getErrorProperties().keySet()) {
                    List props = (List)r.getErrorProperties().get(status);
                    this.sendErrorProperties(status, writer, mapOfNamespaces, props);
                }
            }
        }
        el.close();
    }

    private void sendKnownProperties(XmlWriter writer, Map<String, String> mapOfNamespaces, Map<QName, ValueAndType> properties, String href) {
        this.sendProperties(Response.Status.SC_OK, writer, mapOfNamespaces, properties, href);
    }

    private void sendProperties(Response.Status status, XmlWriter writer, Map<String, String> mapOfNamespaces, Map<QName, ValueAndType> properties, String href) {
        if (!properties.isEmpty()) {
            XmlWriter.Element elPropStat = writer.begin(WebDavProtocol.NS_DAV.getPrefix(), "propstat").open();
            XmlWriter.Element elProp = writer.begin(WebDavProtocol.NS_DAV.getPrefix(), "prop").open();
            for (QName qname : properties.keySet()) {
                String prefix = mapOfNamespaces.get(qname.getNamespaceURI());
                ValueAndType val = properties.get(qname);
                if (val == null) {
                    writer.writeProperty(prefix, qname.getLocalPart());
                    continue;
                }
                this.valueWriters.writeValue(writer, qname, prefix, val, href, mapOfNamespaces);
            }
            elProp.close();
            writer.writeProperty(WebDavProtocol.NS_DAV.getPrefix(), "status", status.toString());
            elPropStat.close();
        }
    }

    private void sendErrorProperties(Response.Status status, XmlWriter writer, Map<String, String> mapOfNamespaces, List<PropFindResponse.NameAndError> properties) {
        if (!properties.isEmpty()) {
            XmlWriter.Element elPropStat = writer.begin(WebDavProtocol.NS_DAV.getPrefix(), "propstat").open();
            XmlWriter.Element elProp = writer.begin(WebDavProtocol.NS_DAV.getPrefix(), "prop").open();
            for (PropFindResponse.NameAndError ne : properties) {
                QName qname = ne.getName();
                String prefix = mapOfNamespaces.get(qname.getNamespaceURI());
                writer.writeProperty(prefix, qname.getLocalPart());
            }
            elProp.close();
            writer.writeProperty(WebDavProtocol.NS_DAV.getPrefix(), "status", status.toString());
            elPropStat.close();
        }
    }

    void write(ByteArrayOutputStream out, OutputStream outputStream) {
        try {
            String xml = out.toString("UTF-8");
            outputStream.write(xml.getBytes("UTF-8"));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public ValueWriters getValueWriters() {
        return this.valueWriters;
    }

    public void setValueWriters(ValueWriters valueWriters) {
        this.valueWriters = valueWriters;
    }
}

