/*
 * Decompiled with CFR 0.152.
 */
package io.milton.simpleton;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Stage<V extends Runnable>
implements Runnable,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(Stage.class);
    final String name;
    final LinkedBlockingQueue<V> queue;
    final List<Thread> threads;
    final int capacity;
    final int maxThreads;
    final boolean blockOnAdd;
    int threadCounter;

    public Stage(String name, int capacity, int maxThreads, boolean blockOnAdd) {
        this.name = name;
        this.capacity = capacity;
        this.blockOnAdd = blockOnAdd;
        this.maxThreads = maxThreads;
        this.queue = new LinkedBlockingQueue(capacity);
        this.threads = new ArrayList<Thread>();
        for (int i = 0; i < maxThreads; ++i) {
            this.addThread();
        }
    }

    protected void addThread() {
        Thread t = new Thread((Runnable)this, "Stage-" + this.name + "-" + this.threadCounter++);
        this.threads.add(t);
        log.debug(this.name + " added thread: " + this.threads.size());
        t.start();
    }

    public String getName() {
        return this.name;
    }

    public void enqueue(V v) {
        log.debug("queue size: " + this.queue.size() + " capacity: " + this.capacity);
        if (this.queue.size() > this.capacity / 2 && this.threads.size() < this.maxThreads) {
            this.addThread();
        }
        try {
            if (this.blockOnAdd) {
                this.queue.put(v);
            } else {
                this.queue.add(v);
            }
        }
        catch (InterruptedException ex) {
            log.warn("interrupted", (Throwable)ex);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            boolean done = false;
            while (!done) {
                Runnable v = (Runnable)this.queue.take();
                try {
                    v.run();
                }
                catch (Exception e) {
                    log.error("exception processing: " + v.getClass(), (Throwable)e);
                }
            }
            this.threads.remove(Thread.currentThread());
            log.debug(this.name + " thread stopped: " + this.threads.size());
        }
        catch (InterruptedException ex) {
            log.warn("interrupted", (Throwable)ex);
        }
        catch (Exception e) {
            log.error("exception has killed stage", (Throwable)e);
        }
    }

    @Override
    public void close() throws IOException {
        for (Thread t : this.threads) {
            t.interrupt();
        }
    }
}

