/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.bulkwriter.storage.client;

import com.azure.core.credential.TokenCredential;
import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import io.milvus.bulkwriter.storage.StorageClient;
import io.milvus.common.utils.ExceptionUtils;
import java.io.InputStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureStorageClient
implements StorageClient {
    private static final Logger logger = LoggerFactory.getLogger(AzureStorageClient.class);
    private final BlobServiceClient blobServiceClient;

    private AzureStorageClient(BlobServiceClient blobServiceClient) {
        this.blobServiceClient = blobServiceClient;
    }

    public static AzureStorageClient getStorageClient(String connStr, String accountUrl, TokenCredential credential) {
        BlobServiceClientBuilder blobServiceClientBuilder = new BlobServiceClientBuilder();
        if (credential != null) {
            blobServiceClientBuilder.credential(credential);
        }
        if (StringUtils.isNotEmpty((CharSequence)connStr)) {
            blobServiceClientBuilder.connectionString(connStr);
        } else if (StringUtils.isNotEmpty((CharSequence)accountUrl)) {
            blobServiceClientBuilder.endpoint(accountUrl);
        } else {
            ExceptionUtils.throwUnExpectedException((String)"Illegal connection parameters");
        }
        BlobServiceClient blobServiceClient = blobServiceClientBuilder.buildClient();
        logger.info("Azure blob storage client successfully initialized");
        return new AzureStorageClient(blobServiceClient);
    }

    @Override
    public Long getObjectEntity(String bucketName, String objectKey) {
        BlobClient blobClient = this.blobServiceClient.getBlobContainerClient(bucketName).getBlobClient(objectKey);
        return blobClient.getProperties().getBlobSize();
    }

    @Override
    public void putObjectStream(InputStream inputStream, long contentLength, String bucketName, String objectKey) {
        BlobClient blobClient = this.blobServiceClient.getBlobContainerClient(bucketName).getBlobClient(objectKey);
        blobClient.upload(inputStream, contentLength);
    }

    @Override
    public boolean checkBucketExist(String bucketName) {
        BlobContainerClient blobContainerClient = this.blobServiceClient.getBlobContainerClient(bucketName);
        return blobContainerClient.exists();
    }
}

