/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.client;

import io.milvus.client.IndexType;
import javax.annotation.Nonnull;

public class Index {
    private final String collectionName;
    private final IndexType indexType;
    private final String paramsInJson;

    private Index(@Nonnull Builder builder) {
        this.collectionName = builder.collectionName;
        this.indexType = builder.indexType;
        this.paramsInJson = builder.paramsInJson;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public IndexType getIndexType() {
        return this.indexType;
    }

    public String getParamsInJson() {
        return this.paramsInJson;
    }

    public String toString() {
        return "Index {collectionName=" + this.collectionName + ", indexType=" + (Object)((Object)this.indexType) + ", params=" + this.paramsInJson + '}';
    }

    public static class Builder {
        private final String collectionName;
        private final IndexType indexType;
        private String paramsInJson;

        public Builder(@Nonnull String collectionName, @Nonnull IndexType indexType) {
            this.collectionName = collectionName;
            this.indexType = indexType;
        }

        public Builder withParamsInJson(@Nonnull String paramsInJson) {
            this.paramsInJson = paramsInJson;
            return this;
        }

        public Index build() {
            return new Index(this);
        }
    }
}

