/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.client;

import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public class ConnectParam {
    private final String host;
    private final int port;
    private final long connectTimeoutNanos;
    private final long keepAliveTimeNanos;
    private final long keepAliveTimeoutNanos;
    private final boolean keepAliveWithoutCalls;
    private final long idleTimeoutNanos;

    private ConnectParam(@Nonnull Builder builder) {
        this.host = builder.host;
        this.port = builder.port;
        this.connectTimeoutNanos = builder.connectTimeoutNanos;
        this.keepAliveTimeNanos = builder.keepAliveTimeNanos;
        this.keepAliveTimeoutNanos = builder.keepAliveTimeoutNanos;
        this.keepAliveWithoutCalls = builder.keepAliveWithoutCalls;
        this.idleTimeoutNanos = builder.idleTimeoutNanos;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public long getConnectTimeout(@Nonnull TimeUnit timeUnit) {
        return timeUnit.convert(this.connectTimeoutNanos, TimeUnit.NANOSECONDS);
    }

    public long getKeepAliveTime(@Nonnull TimeUnit timeUnit) {
        return timeUnit.convert(this.keepAliveTimeNanos, TimeUnit.NANOSECONDS);
    }

    public long getKeepAliveTimeout(@Nonnull TimeUnit timeUnit) {
        return timeUnit.convert(this.keepAliveTimeoutNanos, TimeUnit.NANOSECONDS);
    }

    public boolean isKeepAliveWithoutCalls() {
        return this.keepAliveWithoutCalls;
    }

    public long getIdleTimeout(@Nonnull TimeUnit timeUnit) {
        return timeUnit.convert(this.idleTimeoutNanos, TimeUnit.NANOSECONDS);
    }

    public static class Builder {
        private String host = "localhost";
        private int port = 19530;
        private long connectTimeoutNanos = TimeUnit.NANOSECONDS.convert(10L, TimeUnit.SECONDS);
        private long keepAliveTimeNanos = Long.MAX_VALUE;
        private long keepAliveTimeoutNanos = TimeUnit.NANOSECONDS.convert(20L, TimeUnit.SECONDS);
        private boolean keepAliveWithoutCalls = false;
        private long idleTimeoutNanos = TimeUnit.NANOSECONDS.convert(24L, TimeUnit.HOURS);

        public Builder withHost(@Nonnull String host) {
            this.host = host;
            return this;
        }

        public Builder withPort(int port) throws IllegalArgumentException {
            if (port < 0 || port > 65535) {
                throw new IllegalArgumentException("Port is out of range!");
            }
            this.port = port;
            return this;
        }

        public Builder withConnectTimeout(long connectTimeout, @Nonnull TimeUnit timeUnit) throws IllegalArgumentException {
            if (connectTimeout <= 0L) {
                throw new IllegalArgumentException("Connect timeout must be positive!");
            }
            this.connectTimeoutNanos = timeUnit.toNanos(connectTimeout);
            return this;
        }

        public Builder withKeepAliveTime(long keepAliveTime, @Nonnull TimeUnit timeUnit) throws IllegalArgumentException {
            if (keepAliveTime <= 0L) {
                throw new IllegalArgumentException("Keepalive time must be positive!");
            }
            this.keepAliveTimeNanos = timeUnit.toNanos(keepAliveTime);
            return this;
        }

        public Builder withKeepAliveTimeout(long keepAliveTimeout, @Nonnull TimeUnit timeUnit) throws IllegalArgumentException {
            if (keepAliveTimeout <= 0L) {
                throw new IllegalArgumentException("Keepalive timeout must be positive!");
            }
            this.keepAliveTimeoutNanos = timeUnit.toNanos(keepAliveTimeout);
            return this;
        }

        public Builder keepAliveWithoutCalls(boolean enable) {
            this.keepAliveWithoutCalls = enable;
            return this;
        }

        public Builder withIdleTimeout(long idleTimeout, TimeUnit timeUnit) throws IllegalArgumentException {
            if (idleTimeout <= 0L) {
                throw new IllegalArgumentException("Idle timeout must be positive!");
            }
            this.idleTimeoutNanos = timeUnit.toNanos(idleTimeout);
            return this;
        }

        public ConnectParam build() {
            return new ConnectParam(this);
        }
    }
}

