/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.client;

import java.util.Arrays;
import java.util.Optional;

public class Response {
    private final Status status;
    private final String message;

    public Response(Status status, String message) {
        this.status = status;
        this.message = message;
    }

    public Response(Status status) {
        this.status = status;
        this.message = status == Status.CLIENT_NOT_CONNECTED ? "You are not connected to Milvus server" : "Success!";
    }

    public Status getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean ok() {
        return this.status == Status.SUCCESS;
    }

    public String toString() {
        return String.format("Response {code = %s, message = \"%s\"}", this.status.name(), this.message);
    }

    public static enum Status {
        SUCCESS(0),
        UNEXPECTED_ERROR(1),
        CONNECT_FAILED(2),
        PERMISSION_DENIED(3),
        COLLECTION_NOT_EXISTS(4),
        ILLEGAL_ARGUMENT(5),
        ILLEGAL_DIMENSION(7),
        ILLEGAL_INDEX_TYPE(8),
        ILLEGAL_COLLECTION_NAME(9),
        ILLEGAL_TOPK(10),
        ILLEGAL_ROWRECORD(11),
        ILLEGAL_VECTOR_ID(12),
        ILLEGAL_SEARCH_RESULT(13),
        FILE_NOT_FOUND(14),
        META_FAILED(15),
        CACHE_FAILED(16),
        CANNOT_CREATE_FOLDER(17),
        CANNOT_CREATE_FILE(18),
        CANNOT_DELETE_FOLDER(19),
        CANNOT_DELETE_FILE(20),
        BUILD_INDEX_ERROR(21),
        ILLEGAL_NLIST(22),
        ILLEGAL_METRIC_TYPE(23),
        OUT_OF_MEMORY(24),
        RPC_ERROR(-1),
        CLIENT_NOT_CONNECTED(-2),
        UNKNOWN(-3),
        VERSION_MISMATCH(-4);

        private final int code;

        private Status(int code) {
            this.code = code;
        }

        public static Status valueOf(int val) {
            Optional<Status> search = Arrays.stream(Status.values()).filter(status -> status.code == val).findFirst();
            return search.orElse(UNKNOWN);
        }

        public int getCode() {
            return this.code;
        }
    }
}

