/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.client;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class SearchParam {
    private final String collectionName;
    private final List<List<Float>> floatVectors;
    private final List<ByteBuffer> binaryVectors;
    private final List<String> partitionTags;
    private final long topK;
    private final String paramsInJson;

    private SearchParam(@Nonnull Builder builder) {
        this.collectionName = builder.collectionName;
        this.floatVectors = builder.floatVectors;
        this.binaryVectors = builder.binaryVectors;
        this.partitionTags = builder.partitionTags;
        this.topK = builder.topK;
        this.paramsInJson = builder.paramsInJson;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public List<List<Float>> getFloatVectors() {
        return this.floatVectors;
    }

    public List<ByteBuffer> getBinaryVectors() {
        return this.binaryVectors;
    }

    public List<String> getPartitionTags() {
        return this.partitionTags;
    }

    public long getTopK() {
        return this.topK;
    }

    public String getParamsInJson() {
        return this.paramsInJson;
    }

    public static class Builder {
        private final String collectionName;
        private List<List<Float>> floatVectors = new ArrayList<List<Float>>();
        private List<ByteBuffer> binaryVectors = new ArrayList<ByteBuffer>();
        private List<String> partitionTags = new ArrayList<String>();
        private long topK = 1024L;
        private String paramsInJson;

        public Builder(@Nonnull String collectionName) {
            this.collectionName = collectionName;
        }

        public Builder withFloatVectors(@Nonnull List<List<Float>> floatVectors) {
            this.floatVectors = floatVectors;
            return this;
        }

        public Builder withBinaryVectors(@Nonnull List<ByteBuffer> binaryVectors) {
            this.binaryVectors = binaryVectors;
            return this;
        }

        public Builder withPartitionTags(@Nonnull List<String> partitionTags) {
            this.partitionTags = partitionTags;
            return this;
        }

        public Builder withTopK(long topK) {
            this.topK = topK;
            return this;
        }

        public Builder withParamsInJson(@Nonnull String paramsInJson) {
            this.paramsInJson = paramsInJson;
            return this;
        }

        public SearchParam build() {
            return new SearchParam(this);
        }
    }
}

