/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.client;

import com.google.protobuf.ByteString;
import io.grpc.StatusRuntimeException;
import io.milvus.client.MilvusClient;
import io.milvus.exception.ClientNotConnectedException;
import io.milvus.exception.IllegalResponseException;
import io.milvus.exception.ParamException;
import io.milvus.grpc.AlterAliasRequest;
import io.milvus.grpc.BoolArray;
import io.milvus.grpc.BoolResponse;
import io.milvus.grpc.CalcDistanceRequest;
import io.milvus.grpc.CalcDistanceResults;
import io.milvus.grpc.CollectionSchema;
import io.milvus.grpc.CreateAliasRequest;
import io.milvus.grpc.CreateCollectionRequest;
import io.milvus.grpc.CreateIndexRequest;
import io.milvus.grpc.CreatePartitionRequest;
import io.milvus.grpc.DataType;
import io.milvus.grpc.DeleteRequest;
import io.milvus.grpc.DescribeCollectionRequest;
import io.milvus.grpc.DescribeCollectionResponse;
import io.milvus.grpc.DescribeIndexRequest;
import io.milvus.grpc.DescribeIndexResponse;
import io.milvus.grpc.DoubleArray;
import io.milvus.grpc.DropAliasRequest;
import io.milvus.grpc.DropCollectionRequest;
import io.milvus.grpc.DropIndexRequest;
import io.milvus.grpc.DropPartitionRequest;
import io.milvus.grpc.DslType;
import io.milvus.grpc.ErrorCode;
import io.milvus.grpc.FieldData;
import io.milvus.grpc.FieldSchema;
import io.milvus.grpc.FloatArray;
import io.milvus.grpc.FlushRequest;
import io.milvus.grpc.FlushResponse;
import io.milvus.grpc.GetCollectionStatisticsRequest;
import io.milvus.grpc.GetCollectionStatisticsResponse;
import io.milvus.grpc.GetCompactionPlansRequest;
import io.milvus.grpc.GetCompactionPlansResponse;
import io.milvus.grpc.GetCompactionStateRequest;
import io.milvus.grpc.GetCompactionStateResponse;
import io.milvus.grpc.GetFlushStateRequest;
import io.milvus.grpc.GetFlushStateResponse;
import io.milvus.grpc.GetIndexBuildProgressRequest;
import io.milvus.grpc.GetIndexBuildProgressResponse;
import io.milvus.grpc.GetIndexStateRequest;
import io.milvus.grpc.GetIndexStateResponse;
import io.milvus.grpc.GetMetricsRequest;
import io.milvus.grpc.GetMetricsResponse;
import io.milvus.grpc.GetPartitionStatisticsRequest;
import io.milvus.grpc.GetPartitionStatisticsResponse;
import io.milvus.grpc.GetPersistentSegmentInfoRequest;
import io.milvus.grpc.GetPersistentSegmentInfoResponse;
import io.milvus.grpc.GetQuerySegmentInfoRequest;
import io.milvus.grpc.GetQuerySegmentInfoResponse;
import io.milvus.grpc.HasCollectionRequest;
import io.milvus.grpc.HasPartitionRequest;
import io.milvus.grpc.IndexState;
import io.milvus.grpc.InsertRequest;
import io.milvus.grpc.IntArray;
import io.milvus.grpc.KeyValuePair;
import io.milvus.grpc.LoadBalanceRequest;
import io.milvus.grpc.LoadCollectionRequest;
import io.milvus.grpc.LoadPartitionsRequest;
import io.milvus.grpc.LongArray;
import io.milvus.grpc.ManualCompactionRequest;
import io.milvus.grpc.ManualCompactionResponse;
import io.milvus.grpc.MilvusServiceGrpc;
import io.milvus.grpc.MsgBase;
import io.milvus.grpc.MsgType;
import io.milvus.grpc.MutationResult;
import io.milvus.grpc.PlaceholderGroup;
import io.milvus.grpc.PlaceholderType;
import io.milvus.grpc.PlaceholderValue;
import io.milvus.grpc.QueryRequest;
import io.milvus.grpc.QueryResults;
import io.milvus.grpc.ReleaseCollectionRequest;
import io.milvus.grpc.ReleasePartitionsRequest;
import io.milvus.grpc.ScalarField;
import io.milvus.grpc.SearchRequest;
import io.milvus.grpc.SearchResults;
import io.milvus.grpc.ShowCollectionsRequest;
import io.milvus.grpc.ShowCollectionsResponse;
import io.milvus.grpc.ShowPartitionsRequest;
import io.milvus.grpc.ShowPartitionsResponse;
import io.milvus.grpc.ShowType;
import io.milvus.grpc.Status;
import io.milvus.grpc.StringArray;
import io.milvus.grpc.VectorField;
import io.milvus.grpc.VectorsArray;
import io.milvus.param.R;
import io.milvus.param.RpcStatus;
import io.milvus.param.alias.AlterAliasParam;
import io.milvus.param.alias.CreateAliasParam;
import io.milvus.param.alias.DropAliasParam;
import io.milvus.param.collection.CreateCollectionParam;
import io.milvus.param.collection.DescribeCollectionParam;
import io.milvus.param.collection.DropCollectionParam;
import io.milvus.param.collection.FieldType;
import io.milvus.param.collection.FlushParam;
import io.milvus.param.collection.GetCollectionStatisticsParam;
import io.milvus.param.collection.HasCollectionParam;
import io.milvus.param.collection.LoadCollectionParam;
import io.milvus.param.collection.ReleaseCollectionParam;
import io.milvus.param.collection.ShowCollectionsParam;
import io.milvus.param.control.GetCompactionPlansParam;
import io.milvus.param.control.GetCompactionStateParam;
import io.milvus.param.control.GetFlushStateParam;
import io.milvus.param.control.GetMetricsParam;
import io.milvus.param.control.GetPersistentSegmentInfoParam;
import io.milvus.param.control.GetQuerySegmentInfoParam;
import io.milvus.param.control.LoadBalanceParam;
import io.milvus.param.control.ManualCompactionParam;
import io.milvus.param.dml.CalcDistanceParam;
import io.milvus.param.dml.DeleteParam;
import io.milvus.param.dml.InsertParam;
import io.milvus.param.dml.QueryParam;
import io.milvus.param.dml.SearchParam;
import io.milvus.param.index.CreateIndexParam;
import io.milvus.param.index.DescribeIndexParam;
import io.milvus.param.index.DropIndexParam;
import io.milvus.param.index.GetIndexBuildProgressParam;
import io.milvus.param.index.GetIndexStateParam;
import io.milvus.param.partition.CreatePartitionParam;
import io.milvus.param.partition.DropPartitionParam;
import io.milvus.param.partition.GetPartitionStatisticsParam;
import io.milvus.param.partition.HasPartitionParam;
import io.milvus.param.partition.LoadPartitionsParam;
import io.milvus.param.partition.ReleasePartitionsParam;
import io.milvus.param.partition.ShowPartitionsParam;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMilvusGrpcClient
implements MilvusClient {
    private static final Logger logger = LoggerFactory.getLogger(AbstractMilvusGrpcClient.class);
    private static final Set<DataType> vectorDataType = new HashSet<DataType>(){
        {
            this.add(DataType.FloatVector);
            this.add(DataType.BinaryVector);
        }
    };

    protected abstract MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub();

    protected abstract MilvusServiceGrpc.MilvusServiceFutureStub futureStub();

    protected abstract boolean clientIsReady();

    private List<KeyValuePair> assembleKvPair(Map<String, String> sourceMap) {
        ArrayList<KeyValuePair> result = new ArrayList<KeyValuePair>();
        if (MapUtils.isNotEmpty(sourceMap)) {
            sourceMap.forEach((key, value) -> {
                KeyValuePair kv = KeyValuePair.newBuilder().setKey((String)key).setValue((String)value).build();
                result.add(kv);
            });
        }
        return result;
    }

    private FieldData genFieldData(String fieldName, DataType dataType, List<?> objects) {
        if (objects == null) {
            throw new ParamException("Cannot generate FieldData from null object");
        }
        FieldData.Builder builder = FieldData.newBuilder();
        if (vectorDataType.contains((Object)dataType)) {
            if (dataType == DataType.FloatVector) {
                ArrayList floats = new ArrayList();
                for (Object object : objects) {
                    if (object instanceof List) {
                        List list = (List)object;
                        floats.addAll(list);
                        continue;
                    }
                    throw new ParamException("The type of FloatVector must be List<Float>");
                }
                int dim = floats.size() / objects.size();
                FloatArray floatArray = FloatArray.newBuilder().addAllData(floats).build();
                VectorField vectorField = VectorField.newBuilder().setDim(dim).setFloatVector(floatArray).build();
                return builder.setFieldName(fieldName).setType(DataType.FloatVector).setVectors(vectorField).build();
            }
            if (dataType == DataType.BinaryVector) {
                ByteBuffer totalBuf = null;
                int dim = 0;
                for (Object object : objects) {
                    ByteBuffer buf = (ByteBuffer)object;
                    if (totalBuf == null) {
                        totalBuf = ByteBuffer.allocate(buf.position() * objects.size());
                        totalBuf.put(buf.array());
                        dim = buf.position() * 8;
                        continue;
                    }
                    totalBuf.put(buf.array());
                }
                assert (totalBuf != null);
                ByteString byteString = ByteString.copyFrom((byte[])totalBuf.array());
                VectorField vectorField = VectorField.newBuilder().setDim(dim).setBinaryVector(byteString).build();
                return builder.setFieldName(fieldName).setType(DataType.BinaryVector).setVectors(vectorField).build();
            }
        } else {
            switch (dataType) {
                case None: 
                case UNRECOGNIZED: {
                    throw new ParamException("Cannot support this dataType:" + (Object)((Object)dataType));
                }
                case Int64: {
                    List longs = objects.stream().map(p -> (Long)p).collect(Collectors.toList());
                    LongArray longArray = LongArray.newBuilder().addAllData(longs).build();
                    ScalarField scalarField1 = ScalarField.newBuilder().setLongData(longArray).build();
                    return builder.setFieldName(fieldName).setType(dataType).setScalars(scalarField1).build();
                }
                case Int32: 
                case Int16: 
                case Int8: {
                    List integers = objects.stream().map(p -> p instanceof Short ? ((Short)p).intValue() : ((Integer)p).intValue()).collect(Collectors.toList());
                    IntArray intArray = IntArray.newBuilder().addAllData(integers).build();
                    ScalarField scalarField2 = ScalarField.newBuilder().setIntData(intArray).build();
                    return builder.setFieldName(fieldName).setType(dataType).setScalars(scalarField2).build();
                }
                case Bool: {
                    List booleans = objects.stream().map(p -> (Boolean)p).collect(Collectors.toList());
                    BoolArray boolArray = BoolArray.newBuilder().addAllData(booleans).build();
                    ScalarField scalarField3 = ScalarField.newBuilder().setBoolData(boolArray).build();
                    return builder.setFieldName(fieldName).setType(dataType).setScalars(scalarField3).build();
                }
                case Float: {
                    List floats = objects.stream().map(p -> (Float)p).collect(Collectors.toList());
                    FloatArray floatArray = FloatArray.newBuilder().addAllData(floats).build();
                    ScalarField scalarField4 = ScalarField.newBuilder().setFloatData(floatArray).build();
                    return builder.setFieldName(fieldName).setType(dataType).setScalars(scalarField4).build();
                }
                case Double: {
                    List doubles = objects.stream().map(p -> (Double)p).collect(Collectors.toList());
                    DoubleArray doubleArray = DoubleArray.newBuilder().addAllData(doubles).build();
                    ScalarField scalarField5 = ScalarField.newBuilder().setDoubleData(doubleArray).build();
                    return builder.setFieldName(fieldName).setType(dataType).setScalars(scalarField5).build();
                }
                case String: {
                    List<String> strings = objects.stream().map(p -> (String)p).collect(Collectors.toList());
                    StringArray stringArray = StringArray.newBuilder().addAllData(strings).build();
                    ScalarField scalarField6 = ScalarField.newBuilder().setStringData(stringArray).build();
                    return builder.setFieldName(fieldName).setType(dataType).setScalars(scalarField6).build();
                }
            }
        }
        return null;
    }

    private void waitForLoadingCollection(String collectionName, List<String> partitionNames, long waitingInterval, long timeout) throws IllegalResponseException {
        block17: {
            long tsBegin = System.currentTimeMillis();
            if (partitionNames == null || partitionNames.isEmpty()) {
                ShowCollectionsRequest showCollectionRequest = ShowCollectionsRequest.newBuilder().addCollectionNames(collectionName).setType(ShowType.InMemory).build();
                while (true) {
                    long tsNow;
                    if ((tsNow = System.currentTimeMillis()) - tsBegin >= timeout * 1000L) {
                        this.logWarning("Waiting load thread is timeout, loading process may not be finished", new Object[0]);
                        break block17;
                    }
                    ShowCollectionsResponse response = this.blockingStub().showCollections(showCollectionRequest);
                    int namesCount = response.getCollectionNamesCount();
                    int percentagesCount = response.getInMemoryPercentagesCount();
                    if (namesCount != 1) {
                        throw new IllegalResponseException("ShowCollectionsResponse is illegal. Collection count: " + namesCount);
                    }
                    if (namesCount != percentagesCount) {
                        String msg = "ShowCollectionsResponse is illegal. Collection count: " + namesCount + " memory percentages count: " + percentagesCount;
                        throw new IllegalResponseException(msg);
                    }
                    long percentage = response.getInMemoryPercentages(0);
                    String responseCollection = response.getCollectionNames(0);
                    if (responseCollection.compareTo(collectionName) == 0 && percentage >= 100L) break block17;
                    try {
                        this.logInfo("Waiting load, interval: {} ms, percentage: {}%", waitingInterval, percentage);
                        TimeUnit.MILLISECONDS.sleep(waitingInterval);
                    }
                    catch (InterruptedException e) {
                        this.logWarning("Waiting load thread is interrupted, loading process may not be finished", new Object[0]);
                        break block17;
                    }
                }
            }
            ShowPartitionsRequest showPartitionsRequest = ShowPartitionsRequest.newBuilder().setCollectionName(collectionName).addAllPartitionNames(partitionNames).setType(ShowType.InMemory).build();
            while (true) {
                int percentagesCount;
                long tsNow;
                if ((tsNow = System.currentTimeMillis()) - tsBegin >= timeout * 1000L) {
                    this.logWarning("Waiting load thread is timeout, loading process may not be finished", new Object[0]);
                    break;
                }
                ShowPartitionsResponse response = this.blockingStub().showPartitions(showPartitionsRequest);
                int namesCount = response.getPartitionNamesCount();
                if (namesCount != (percentagesCount = response.getInMemoryPercentagesCount())) {
                    String msg = "ShowPartitionsResponse is illegal. Partition count: " + namesCount + " memory percentages count: " + percentagesCount;
                    throw new IllegalResponseException(msg);
                }
                HashMap<String, Long> percentages = new HashMap<String, Long>();
                for (int i = 0; i < response.getInMemoryPercentagesCount(); ++i) {
                    percentages.put(response.getPartitionNames(i), response.getInMemoryPercentages(i));
                }
                String partitionNoMemState = "";
                String partitionNotFullyLoad = "";
                boolean allLoaded = true;
                for (String name : partitionNames) {
                    if (!percentages.containsKey(name)) {
                        allLoaded = false;
                        partitionNoMemState = name;
                        break;
                    }
                    if ((Long)percentages.get(name) >= 100L) continue;
                    allLoaded = false;
                    partitionNotFullyLoad = name;
                    break;
                }
                if (allLoaded) break;
                try {
                    String msg = "Waiting load, interval: " + waitingInterval + "ms.";
                    if (!partitionNoMemState.isEmpty()) {
                        msg = msg + "Partition " + partitionNoMemState + " has no memory state.";
                    }
                    if (!partitionNotFullyLoad.isEmpty()) {
                        msg = msg + "Partition " + partitionNotFullyLoad + " has not fully loaded.";
                    }
                    this.logInfo(msg, new Object[0]);
                    TimeUnit.MILLISECONDS.sleep(waitingInterval);
                }
                catch (InterruptedException e) {
                    this.logWarning("Waiting load thread is interrupted, load process may not be finished", new Object[0]);
                    break;
                }
            }
        }
    }

    private void waitForFlush(FlushResponse flushResponse, long waitingInterval, long timeout) {
        long tsBegin = System.currentTimeMillis();
        Map<String, LongArray> collectionSegIDs = flushResponse.getCollSegIDsMap();
        collectionSegIDs.forEach((collectionName, segmentIDs) -> {
            while (segmentIDs.getDataCount() > 0) {
                String msg;
                long tsNow = System.currentTimeMillis();
                if (tsNow - tsBegin >= timeout * 1000L) {
                    this.logWarning("Waiting flush thread is timeout, flush process may not be finished", new Object[0]);
                    break;
                }
                GetFlushStateRequest getFlushStateRequest = GetFlushStateRequest.newBuilder().addAllSegmentIDs(segmentIDs.getDataList()).build();
                GetFlushStateResponse response = this.blockingStub().getFlushState(getFlushStateRequest);
                if (response.getFlushed()) {
                    msg = segmentIDs.getDataCount() + " segments of " + collectionName + " has been flushed.";
                    this.logInfo(msg, new Object[0]);
                    break;
                }
                try {
                    msg = "Waiting flush for " + collectionName + ", interval: " + waitingInterval + "ms. ";
                    this.logInfo(msg, new Object[0]);
                    TimeUnit.MILLISECONDS.sleep(waitingInterval);
                }
                catch (InterruptedException e) {
                    this.logWarning("Waiting flush thread is interrupted, flush process may not be finished", new Object[0]);
                    break;
                }
            }
        });
    }

    private R<Boolean> waitForIndex(String collectionName, String fieldName, long waitingInterval, long timeout) {
        long tsBegin = System.currentTimeMillis();
        while (true) {
            String msg;
            long tsNow;
            if ((tsNow = System.currentTimeMillis()) - tsBegin >= timeout * 1000L) {
                String msg2 = "Waiting index thread is timeout, index process may not be finished";
                this.logWarning(msg2, new Object[0]);
                return R.failed(R.Status.Success, msg2);
            }
            GetIndexStateRequest request = GetIndexStateRequest.newBuilder().setCollectionName(collectionName).setFieldName(fieldName).build();
            GetIndexStateResponse response = this.blockingStub().getIndexState(request);
            if (response.getState() == IndexState.Finished) break;
            if (response.getState() == IndexState.Failed) {
                msg = "Index failed: " + response.getFailReason();
                this.logError(msg, new Object[0]);
                return R.failed(R.Status.UnexpectedError, msg);
            }
            try {
                msg = "Waiting index, interval: " + waitingInterval + "ms. ";
                this.logInfo(msg, new Object[0]);
                TimeUnit.MILLISECONDS.sleep(waitingInterval);
            }
            catch (InterruptedException e) {
                String msg3 = "Waiting index thread is interrupted, index process may not be finished";
                this.logWarning(msg3, new Object[0]);
                return R.failed(R.Status.Success, msg3);
            }
        }
        return R.failed(R.Status.Success, "Waiting index thread exist");
    }

    @Override
    public R<Boolean> hasCollection(@NonNull HasCollectionParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            HasCollectionRequest hasCollectionRequest = HasCollectionRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).build();
            BoolResponse response = this.blockingStub().hasCollection(hasCollectionRequest);
            if (response.getStatus().getErrorCode() == ErrorCode.Success) {
                this.logInfo("HasCollectionRequest successfully!", new Object[0]);
                Boolean value = Optional.of(response).map(BoolResponse::getValue).orElse(false);
                return R.success(value);
            }
            this.logError("HasCollectionRequest failed!\n{}", response.getStatus().getReason());
            return R.failed(R.Status.valueOf(response.getStatus().getErrorCode().getNumber()), response.getStatus().getReason());
        }
        catch (StatusRuntimeException e) {
            this.logError("HasCollectionRequest RPC failed:\n{}", e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("HasCollectionRequest failed:\n{}", e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> createCollection(@NonNull CreateCollectionParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            CollectionSchema.Builder collectionSchemaBuilder = CollectionSchema.newBuilder();
            collectionSchemaBuilder.setName(requestParam.getCollectionName()).setDescription(requestParam.getDescription());
            long fieldID = 0L;
            for (FieldType fieldType : requestParam.getFieldTypes()) {
                FieldSchema.Builder fieldSchemaBuilder = FieldSchema.newBuilder().setFieldID(fieldID).setName(fieldType.getName()).setIsPrimaryKey(fieldType.isPrimaryKey()).setDescription(fieldType.getDescription()).setDataType(fieldType.getDataType()).setAutoID(fieldType.isAutoID());
                List<KeyValuePair> typeParamsList = this.assembleKvPair(fieldType.getTypeParams());
                if (CollectionUtils.isNotEmpty(typeParamsList)) {
                    typeParamsList.forEach(fieldSchemaBuilder::addTypeParams);
                }
                collectionSchemaBuilder.addFields(fieldSchemaBuilder.build());
                ++fieldID;
            }
            CreateCollectionRequest createCollectionRequest = CreateCollectionRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).setShardsNum(requestParam.getShardsNum()).setSchema(collectionSchemaBuilder.build().toByteString()).build();
            Status response = this.blockingStub().createCollection(createCollectionRequest);
            if (response.getErrorCode() == ErrorCode.Success) {
                this.logInfo("CreateCollectionRequest successfully! Collection name:{}", requestParam.getCollectionName());
                return R.success(new RpcStatus("Success"));
            }
            this.logError("CreateCollectionRequest failed!\n{}", response.getReason());
            return R.failed(R.Status.valueOf(response.getErrorCode().getNumber()), response.getReason());
        }
        catch (StatusRuntimeException e) {
            this.logError("CreateCollectionRequest RPC failed! Collection name:{}\n{}", requestParam.getCollectionName(), e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("CreateCollectionRequest failed! Collection name:{}\n{}", requestParam.getCollectionName(), e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> dropCollection(@NonNull DropCollectionParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            DropCollectionRequest dropCollectionRequest = DropCollectionRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).build();
            Status response = this.blockingStub().dropCollection(dropCollectionRequest);
            if (response.getErrorCode() == ErrorCode.Success) {
                this.logInfo("DropCollectionRequest successfully! Collection name:{}", requestParam.getCollectionName());
                return R.success(new RpcStatus("Success"));
            }
            this.logError("DropCollectionRequest failed! Collection name:{}\n{}", requestParam.getCollectionName(), response.getReason());
            return R.failed(R.Status.valueOf(response.getErrorCode().getNumber()), response.getReason());
        }
        catch (StatusRuntimeException e) {
            this.logError("DropCollectionRequest RPC failed! Collection name:{}\n{}", requestParam.getCollectionName(), e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("DropCollectionRequest failed! Collection name:{}\n{}", requestParam.getCollectionName(), e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> loadCollection(@NonNull LoadCollectionParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            LoadCollectionRequest loadCollectionRequest = LoadCollectionRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).build();
            Status response = this.blockingStub().loadCollection(loadCollectionRequest);
            if (response.getErrorCode() != ErrorCode.Success) {
                return R.failed(R.Status.valueOf(response.getErrorCode().getNumber()), response.getReason());
            }
            if (requestParam.isSyncLoad()) {
                this.waitForLoadingCollection(requestParam.getCollectionName(), null, requestParam.getSyncLoadWaitingInterval(), requestParam.getSyncLoadWaitingTimeout());
            }
            this.logInfo("LoadCollectionRequest successfully! Collection name:{}", requestParam.getCollectionName());
            return R.success(new RpcStatus("Success"));
        }
        catch (StatusRuntimeException e) {
            this.logError("LoadCollectionRequest RPC failed! Collection name:{}\n{}", requestParam.getCollectionName(), e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (IllegalResponseException e) {
            this.logError("LoadCollectionRequest failed! Collection name:{}\n{}", requestParam.getCollectionName(), e.getStatus().toString());
            return R.failed(e);
        }
        catch (Exception e) {
            this.logError("LoadCollectionRequest failed! Collection name:{}\n{}", requestParam.getCollectionName(), e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> releaseCollection(@NonNull ReleaseCollectionParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            ReleaseCollectionRequest releaseCollectionRequest = ReleaseCollectionRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).build();
            Status response = this.blockingStub().releaseCollection(releaseCollectionRequest);
            if (response.getErrorCode() == ErrorCode.Success) {
                this.logInfo("ReleaseCollectionRequest successfully! Collection name:{}", requestParam.getCollectionName());
                return R.success(new RpcStatus("Success"));
            }
            this.logError("ReleaseCollectionRequest failed! Collection name:{}\n{}", requestParam.getCollectionName(), response.getReason());
            return R.failed(R.Status.valueOf(response.getErrorCode().getNumber()), response.getReason());
        }
        catch (StatusRuntimeException e) {
            this.logError("ReleaseCollectionRequest RPC failed! Collection name:{}\n{}", requestParam.getCollectionName(), e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("ReleaseCollectionRequest failed! Collection name:{}\n{}", requestParam.getCollectionName(), e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<DescribeCollectionResponse> describeCollection(@NonNull DescribeCollectionParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            DescribeCollectionRequest describeCollectionRequest = DescribeCollectionRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).build();
            DescribeCollectionResponse response = this.blockingStub().describeCollection(describeCollectionRequest);
            if (response.getStatus().getErrorCode() == ErrorCode.Success) {
                this.logInfo("DescribeCollectionRequest successfully!", new Object[0]);
                return R.success(response);
            }
            this.logError("DescribeCollectionRequest failed!\n{}", response.getStatus().getReason());
            return R.failed(R.Status.valueOf(response.getStatus().getErrorCode().getNumber()), response.getStatus().getReason());
        }
        catch (StatusRuntimeException e) {
            this.logError("DescribeCollectionRequest RPC failed:\n{}", e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("DescribeCollectionRequest failed:\n{}", e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<GetCollectionStatisticsResponse> getCollectionStatistics(@NonNull GetCollectionStatisticsParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            R<FlushResponse> response;
            if (requestParam.isFlushCollection() && (response = this.flush(FlushParam.newBuilder().addCollectionName(requestParam.getCollectionName()).withSyncFlush(Boolean.TRUE).build())).getStatus().intValue() != R.Status.Success.getCode()) {
                return R.failed(R.Status.valueOf(response.getStatus()), response.getMessage());
            }
            GetCollectionStatisticsRequest getCollectionStatisticsRequest = GetCollectionStatisticsRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).build();
            GetCollectionStatisticsResponse response2 = this.blockingStub().getCollectionStatistics(getCollectionStatisticsRequest);
            if (response2.getStatus().getErrorCode() == ErrorCode.Success) {
                this.logInfo("GetCollectionStatisticsRequest successfully!", new Object[0]);
                return R.success(response2);
            }
            this.logError("GetCollectionStatisticsRequest failed!\n{}", response2.getStatus().getReason());
            return R.failed(R.Status.valueOf(response2.getStatus().getErrorCode().getNumber()), response2.getStatus().getReason());
        }
        catch (StatusRuntimeException e) {
            this.logError("GetCollectionStatisticsRequest RPC failed:\n{}", e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("GetCollectionStatisticsRequest failed:\n{}", e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<ShowCollectionsResponse> showCollections(@NonNull ShowCollectionsParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            ShowCollectionsRequest showCollectionsRequest = ShowCollectionsRequest.newBuilder().addAllCollectionNames(requestParam.getCollectionNames()).setType(requestParam.getShowType()).build();
            ShowCollectionsResponse response = this.blockingStub().showCollections(showCollectionsRequest);
            if (response.getStatus().getErrorCode() == ErrorCode.Success) {
                this.logInfo("ShowCollectionsRequest successfully!", new Object[0]);
                return R.success(response);
            }
            this.logError("ShowCollectionsRequest failed!\n{}", response.getStatus().getReason());
            return R.failed(R.Status.valueOf(response.getStatus().getErrorCode().getNumber()), response.getStatus().getReason());
        }
        catch (StatusRuntimeException e) {
            this.logError("ShowCollectionsRequest RPC failed:\n{}", e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("ShowCollectionsRequest failed:\n{}", e.getMessage());
            return R.failed(e);
        }
    }

    private R<FlushResponse> flush(@NonNull FlushParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            MsgBase msgBase = MsgBase.newBuilder().setMsgType(MsgType.Flush).build();
            FlushRequest flushRequest = FlushRequest.newBuilder().setBase(msgBase).addAllCollectionNames(requestParam.getCollectionNames()).build();
            FlushResponse response = this.blockingStub().flush(flushRequest);
            if (requestParam.getSyncFlush() == Boolean.TRUE) {
                this.waitForFlush(response, requestParam.getSyncFlushWaitingInterval(), requestParam.getSyncFlushWaitingTimeout());
            }
            this.logInfo("FlushRequest successfully! Collection names:{}", requestParam.getCollectionNames());
            return R.success(response);
        }
        catch (StatusRuntimeException e) {
            this.logError("FlushRequest RPC failed! Collection names:{}\n{}", requestParam.getCollectionNames(), e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("FlushRequest failed! Collection names:{}\n{}", requestParam.getCollectionNames(), e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> createPartition(@NonNull CreatePartitionParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            CreatePartitionRequest createPartitionRequest = CreatePartitionRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).setPartitionName(requestParam.getPartitionName()).build();
            Status response = this.blockingStub().createPartition(createPartitionRequest);
            if (response.getErrorCode() == ErrorCode.Success) {
                this.logInfo("CreatePartitionRequest successfully! Collection name:{}, partition name:{}", requestParam.getCollectionName(), requestParam.getPartitionName());
                return R.success(new RpcStatus("Success"));
            }
            this.logError("CreatePartitionRequest failed! Collection name:{}, partition name:{}\n{}", requestParam.getCollectionName(), requestParam.getPartitionName(), response.getReason());
            return R.failed(R.Status.valueOf(response.getErrorCode().getNumber()), response.getReason());
        }
        catch (StatusRuntimeException e) {
            this.logError("CreatePartitionRequest RPC failed! Collection name:{}, partition name:{}\n{}", requestParam.getCollectionName(), requestParam.getPartitionName(), e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("CreatePartitionRequest failed! Collection name:{}, partition name:{}\n{}", requestParam.getCollectionName(), requestParam.getPartitionName(), e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> dropPartition(@NonNull DropPartitionParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            DropPartitionRequest dropPartitionRequest = DropPartitionRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).setPartitionName(requestParam.getPartitionName()).build();
            Status response = this.blockingStub().dropPartition(dropPartitionRequest);
            if (response.getErrorCode() == ErrorCode.Success) {
                this.logInfo("DropPartitionRequest successfully! Collection name:{}, partition name:{}", requestParam.getCollectionName(), requestParam.getPartitionName());
                return R.success(new RpcStatus("Success"));
            }
            this.logError("DropPartitionRequest failed! Collection name:{}, partition name:{}\n{}", requestParam.getCollectionName(), requestParam.getPartitionName(), response.getReason());
            return R.failed(R.Status.valueOf(response.getErrorCode().getNumber()), response.getReason());
        }
        catch (StatusRuntimeException e) {
            this.logError("DropPartitionRequest RPC failed! Collection name:{}, partition name:{}\n{}", requestParam.getCollectionName(), requestParam.getPartitionName(), e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("DropPartitionRequest failed! Collection name:{}, partition name:{}\n{}", requestParam.getCollectionName(), requestParam.getPartitionName(), e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<Boolean> hasPartition(@NonNull HasPartitionParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            HasPartitionRequest hasPartitionRequest = HasPartitionRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).setPartitionName(requestParam.getPartitionName()).build();
            BoolResponse response = this.blockingStub().hasPartition(hasPartitionRequest);
            if (response.getStatus().getErrorCode() == ErrorCode.Success) {
                this.logInfo("HasPartitionRequest successfully!", new Object[0]);
                Boolean result = response.getValue();
                return R.success(result);
            }
            this.logError("HasPartitionRequest failed!\n{}", response.getStatus().getReason());
            return R.failed(R.Status.valueOf(response.getStatus().getErrorCode().getNumber()), response.getStatus().getReason());
        }
        catch (StatusRuntimeException e) {
            this.logError("HasPartitionRequest RPC failed:\n{}", e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("HasPartitionRequest failed:\n{}", e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> loadPartitions(@NonNull LoadPartitionsParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            LoadPartitionsRequest loadPartitionsRequest = LoadPartitionsRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).addAllPartitionNames(requestParam.getPartitionNames()).build();
            Status response = this.blockingStub().loadPartitions(loadPartitionsRequest);
            if (response.getErrorCode() != ErrorCode.Success) {
                return R.failed(R.Status.valueOf(response.getErrorCode().getNumber()), response.getReason());
            }
            if (requestParam.isSyncLoad()) {
                this.waitForLoadingCollection(requestParam.getCollectionName(), requestParam.getPartitionNames(), requestParam.getSyncLoadWaitingInterval(), requestParam.getSyncLoadWaitingTimeout());
            }
            this.logInfo("LoadPartitionsRequest successfully! Collection name:{}, partition names:{}", requestParam.getCollectionName(), requestParam.getPartitionNames());
            return R.success(new RpcStatus("Success"));
        }
        catch (StatusRuntimeException e) {
            this.logError("LoadPartitionsRequest RPC failed! Collection name:{}, partition names:{}\n{}", requestParam.getCollectionName(), requestParam.getPartitionNames(), e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (IllegalResponseException e) {
            this.logError("LoadPartitionsRequest failed! Collection name:{}, partition names:{}\n{}", requestParam.getCollectionName(), requestParam.getPartitionNames(), e.getStatus().toString());
            return R.failed(e);
        }
        catch (Exception e) {
            this.logError("LoadPartitionsRequest failed! Collection name:{}, partition names:{}\n{}", requestParam.getCollectionName(), requestParam.getPartitionNames(), e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> releasePartitions(@NonNull ReleasePartitionsParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            ReleasePartitionsRequest releasePartitionsRequest = ReleasePartitionsRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).addAllPartitionNames(requestParam.getPartitionNames()).build();
            Status response = this.blockingStub().releasePartitions(releasePartitionsRequest);
            if (response.getErrorCode() == ErrorCode.Success) {
                this.logInfo("ReleasePartitionsRequest successfully! Collection name:{}, partition names:{}", requestParam.getCollectionName(), requestParam.getPartitionNames());
                return R.success(new RpcStatus("Success"));
            }
            this.logError("ReleasePartitionsRequest failed! Collection name:{}, partition names:{}\n{}", requestParam.getCollectionName(), requestParam.getPartitionNames(), response.getReason());
            return R.failed(R.Status.valueOf(response.getErrorCode().getNumber()), response.getReason());
        }
        catch (StatusRuntimeException e) {
            this.logError("ReleasePartitionsRequest RPC failed! Collection name:{}, partition names:{}\n{}", requestParam.getCollectionName(), requestParam.getPartitionNames(), e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("ReleasePartitionsRequest failed! Collection name:{}, partition names:{}\n{}", requestParam.getCollectionName(), requestParam.getPartitionNames(), e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<GetPartitionStatisticsResponse> getPartitionStatistics(@NonNull GetPartitionStatisticsParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            R<FlushResponse> response;
            if (requestParam.isFlushCollection() && (response = this.flush(FlushParam.newBuilder().addCollectionName(requestParam.getCollectionName()).withSyncFlush(Boolean.TRUE).build())).getStatus().intValue() != R.Status.Success.getCode()) {
                return R.failed(R.Status.valueOf(response.getStatus()), response.getMessage());
            }
            GetPartitionStatisticsRequest getPartitionStatisticsRequest = GetPartitionStatisticsRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).setPartitionName(requestParam.getPartitionName()).build();
            GetPartitionStatisticsResponse response2 = this.blockingStub().getPartitionStatistics(getPartitionStatisticsRequest);
            if (response2.getStatus().getErrorCode() == ErrorCode.Success) {
                this.logInfo("GetPartitionStatisticsRequest successfully!", new Object[0]);
                return R.success(response2);
            }
            this.logError("ReleasePartitionsRequest failed:\n{}", response2.getStatus().getReason());
            return R.failed(R.Status.valueOf(response2.getStatus().getErrorCode().getNumber()), response2.getStatus().getReason());
        }
        catch (StatusRuntimeException e) {
            this.logError("GetPartitionStatisticsRequest RPC failed:\n{}", e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("GetQuerySegmentInfoRequest failed:\n{}", e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<ShowPartitionsResponse> showPartitions(@NonNull ShowPartitionsParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            ShowPartitionsRequest showPartitionsRequest = ShowPartitionsRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).addAllPartitionNames(requestParam.getPartitionNames()).build();
            ShowPartitionsResponse response = this.blockingStub().showPartitions(showPartitionsRequest);
            if (response.getStatus().getErrorCode() == ErrorCode.Success) {
                this.logInfo("ShowPartitionsRequest successfully!", new Object[0]);
                return R.success(response);
            }
            this.logError("ShowPartitionsRequest failed:\n{}", response.getStatus().getReason());
            return R.failed(R.Status.valueOf(response.getStatus().getErrorCode().getNumber()), response.getStatus().getReason());
        }
        catch (StatusRuntimeException e) {
            this.logError("ShowPartitionsRequest RPC failed:\n{}", e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("ShowPartitionsRequest failed:\n{}", e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> createAlias(@NonNull CreateAliasParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            CreateAliasRequest createAliasRequest = CreateAliasRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).setAlias(requestParam.getAlias()).build();
            Status response = this.blockingStub().createAlias(createAliasRequest);
            if (response.getErrorCode() == ErrorCode.Success) {
                this.logInfo("CreateAliasRequest successfully! Collection name:{}, alias name:{}", requestParam.getCollectionName(), requestParam.getAlias());
                return R.success(new RpcStatus("Success"));
            }
            this.logError("CreateAliasRequest failed! Collection name:{}, alias name:{}\n{}", requestParam.getCollectionName(), requestParam.getAlias(), response.getReason());
            return R.failed(R.Status.valueOf(response.getErrorCode().getNumber()), response.getReason());
        }
        catch (StatusRuntimeException e) {
            this.logError("CreateAliasRequest RPC failed! Collection name:{}, alias name:{}\n{}", requestParam.getCollectionName(), requestParam.getAlias(), e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("CreateAliasRequest failed! Collection name:{}, alias name:{}\n{}", requestParam.getCollectionName(), requestParam.getAlias(), e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> dropAlias(@NonNull DropAliasParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            DropAliasRequest dropAliasRequest = DropAliasRequest.newBuilder().setAlias(requestParam.getAlias()).build();
            Status response = this.blockingStub().dropAlias(dropAliasRequest);
            if (response.getErrorCode() == ErrorCode.Success) {
                this.logInfo("DropAliasRequest successfully! Alias name:{}", requestParam.getAlias());
                return R.success(new RpcStatus("Success"));
            }
            this.logError("DropAliasRequest failed! Alias name:{}\n{}", requestParam.getAlias(), response.getReason());
            return R.failed(R.Status.valueOf(response.getErrorCode().getNumber()), response.getReason());
        }
        catch (StatusRuntimeException e) {
            this.logError("DropAliasRequest RPC failed! Alias name:{}\n{}", requestParam.getAlias(), e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("DropAliasRequest failed! Alias name:{}\n{}", requestParam.getAlias(), e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> alterAlias(@NonNull AlterAliasParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            AlterAliasRequest alterAliasRequest = AlterAliasRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).setAlias(requestParam.getAlias()).build();
            Status response = this.blockingStub().alterAlias(alterAliasRequest);
            if (response.getErrorCode() == ErrorCode.Success) {
                this.logInfo("AlterAliasRequest successfully! Collection name:{}, alias name:{}", requestParam.getCollectionName(), requestParam.getAlias());
                return R.success(new RpcStatus("Success"));
            }
            this.logError("AlterAliasRequest failed! Collection name:{}, alias name:{}\n{}", requestParam.getCollectionName(), requestParam.getAlias(), response.getReason());
            return R.failed(R.Status.valueOf(response.getErrorCode().getNumber()), response.getReason());
        }
        catch (StatusRuntimeException e) {
            this.logError("AlterAliasRequest RPC failed! Collection name:{}, alias name:{}\n{}", requestParam.getCollectionName(), requestParam.getAlias(), e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("AlterAliasRequest failed! Collection name:{}, alias name:{}\n{}", requestParam.getCollectionName(), requestParam.getAlias(), e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> createIndex(@NonNull CreateIndexParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            R<Boolean> res;
            CreateIndexRequest.Builder createIndexRequestBuilder = CreateIndexRequest.newBuilder();
            List<KeyValuePair> extraParamList = this.assembleKvPair(requestParam.getExtraParam());
            if (CollectionUtils.isNotEmpty(extraParamList)) {
                extraParamList.forEach(createIndexRequestBuilder::addExtraParams);
            }
            CreateIndexRequest createIndexRequest = createIndexRequestBuilder.setCollectionName(requestParam.getCollectionName()).setFieldName(requestParam.getFieldName()).build();
            Status response = this.blockingStub().createIndex(createIndexRequest);
            if (response.getErrorCode() != ErrorCode.Success) {
                this.logError("CreateIndexRequest failed! Collection name:{} Field name:{}\n{}", requestParam.getCollectionName(), requestParam.getFieldName(), response.getReason());
                return R.failed(R.Status.valueOf(response.getErrorCode().getNumber()), response.getReason());
            }
            if (requestParam.isSyncMode() && (res = this.waitForIndex(requestParam.getCollectionName(), requestParam.getFieldName(), requestParam.getSyncWaitingInterval(), requestParam.getSyncWaitingTimeout())).getStatus().intValue() != R.Status.Success.getCode()) {
                this.logError("CreateIndexRequest failed in sync mode! Collection name:{} Field name:{}\n{}", requestParam.getCollectionName(), requestParam.getFieldName(), response.getReason());
                return R.failed(R.Status.valueOf(res.getStatus()), res.getMessage());
            }
            this.logInfo("CreateIndexRequest successfully! Collection name:{} Field name:{}", requestParam.getCollectionName(), requestParam.getFieldName());
            return R.success(new RpcStatus("Success"));
        }
        catch (StatusRuntimeException e) {
            this.logError("CreateIndexRequest RPC failed! Collection name:{}\n{}", requestParam.getCollectionName(), e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("CreateIndexRequest failed! Collection name:{}\n{}", requestParam.getCollectionName(), e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> dropIndex(@NonNull DropIndexParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            DropIndexRequest dropIndexRequest = DropIndexRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).setFieldName(requestParam.getFieldName()).build();
            Status response = this.blockingStub().dropIndex(dropIndexRequest);
            if (response.getErrorCode() == ErrorCode.Success) {
                this.logInfo("DropIndexRequest successfully! Collection name:{}", requestParam.getCollectionName());
                return R.success(new RpcStatus("Success"));
            }
            this.logError("DropIndexRequest failed! Collection name:{}\n{}", requestParam.getCollectionName(), response.getReason());
            return R.failed(R.Status.valueOf(response.getErrorCode().getNumber()), response.getReason());
        }
        catch (StatusRuntimeException e) {
            this.logError("DropIndexRequest RPC failed! Collection name:{}\n{}", requestParam.getCollectionName(), e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("DropIndexRequest failed! Collection name:{}\n{}", requestParam.getCollectionName(), e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<DescribeIndexResponse> describeIndex(@NonNull DescribeIndexParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            DescribeIndexRequest describeIndexRequest = DescribeIndexRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).setFieldName(requestParam.getFieldName()).build();
            DescribeIndexResponse response = this.blockingStub().describeIndex(describeIndexRequest);
            if (response.getStatus().getErrorCode() == ErrorCode.Success) {
                this.logInfo("DescribeIndexRequest successfully!", new Object[0]);
                return R.success(response);
            }
            this.logError("DescribeIndexRequest failed:\n{}", response.getStatus().getReason());
            return R.failed(R.Status.valueOf(response.getStatus().getErrorCode().getNumber()), response.getStatus().getReason());
        }
        catch (StatusRuntimeException e) {
            this.logError("DescribeIndexRequest RPC failed:\n{}", e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("DescribeIndexRequest failed:\n{}", e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<GetIndexStateResponse> getIndexState(@NonNull GetIndexStateParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            GetIndexStateRequest getIndexStateRequest = GetIndexStateRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).setFieldName(requestParam.getFieldName()).build();
            GetIndexStateResponse response = this.blockingStub().getIndexState(getIndexStateRequest);
            if (response.getStatus().getErrorCode() == ErrorCode.Success) {
                this.logInfo("GetIndexStateRequest successfully!", new Object[0]);
                return R.success(response);
            }
            this.logError("GetIndexStateRequest failed:\n{}", response.getStatus().getReason());
            return R.failed(R.Status.valueOf(response.getStatus().getErrorCode().getNumber()), response.getStatus().getReason());
        }
        catch (StatusRuntimeException e) {
            this.logError("GetIndexStateRequest RPC failed:\n{}", e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("GetIndexStateRequest failed:\n{}", e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<GetIndexBuildProgressResponse> getIndexBuildProgress(@NonNull GetIndexBuildProgressParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            GetIndexBuildProgressRequest getIndexBuildProgressRequest = GetIndexBuildProgressRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).build();
            GetIndexBuildProgressResponse response = this.blockingStub().getIndexBuildProgress(getIndexBuildProgressRequest);
            if (response.getStatus().getErrorCode() == ErrorCode.Success) {
                this.logInfo("GetIndexBuildProgressRequest successfully!", new Object[0]);
                return R.success(response);
            }
            this.logError("GetIndexBuildProgressRequest failed:\n{}", response.getStatus().getReason());
            return R.failed(R.Status.valueOf(response.getStatus().getErrorCode().getNumber()), response.getStatus().getReason());
        }
        catch (StatusRuntimeException e) {
            this.logError("GetIndexBuildProgressRequest RPC failed:\n{}", e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("GetIndexBuildProgressRequest failed:\n{}", e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<MutationResult> delete(@NonNull DeleteParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            DeleteRequest deleteRequest = DeleteRequest.newBuilder().setBase(MsgBase.newBuilder().setMsgType(MsgType.Delete).build()).setCollectionName(requestParam.getCollectionName()).setPartitionName(requestParam.getPartitionName()).setExpr(requestParam.getExpr()).build();
            MutationResult response = this.blockingStub().delete(deleteRequest);
            if (response.getStatus().getErrorCode() == ErrorCode.Success) {
                this.logInfo("DeleteRequest successfully! Collection name:{}", requestParam.getCollectionName());
                return R.success(response);
            }
            this.logError("DeleteRequest failed! Collection name:{}\n{}", requestParam.getCollectionName(), response.getStatus().getReason());
            return R.failed(R.Status.valueOf(response.getStatus().getErrorCode().getNumber()), response.getStatus().getReason());
        }
        catch (StatusRuntimeException e) {
            this.logError("DeleteRequest RPC failed! Collection name:{}\n{}", requestParam.getCollectionName(), e.getMessage());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("DeleteRequest failed! Collection name:{}\n{}", requestParam.getCollectionName(), e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<MutationResult> insert(@NonNull InsertParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            String collectionName = requestParam.getCollectionName();
            String partitionName = requestParam.getPartitionName();
            List<InsertParam.Field> fields = requestParam.getFields();
            MsgBase msgBase = MsgBase.newBuilder().setMsgType(MsgType.Insert).build();
            InsertRequest.Builder insertBuilder = InsertRequest.newBuilder().setCollectionName(collectionName).setPartitionName(partitionName).setBase(msgBase).setNumRows(requestParam.getRowCount());
            for (InsertParam.Field field : fields) {
                insertBuilder.addFieldsData(this.genFieldData(field.getName(), field.getType(), field.getValues()));
            }
            InsertRequest insertRequest = insertBuilder.build();
            MutationResult response = this.blockingStub().insert(insertRequest);
            if (response.getStatus().getErrorCode() == ErrorCode.Success) {
                this.logInfo("InsertRequest successfully! Collection name:{}", requestParam.getCollectionName());
                return R.success(response);
            }
            this.logError("InsertRequest failed! Collection name:{}\n{}", requestParam.getCollectionName(), response.getStatus().getReason());
            return R.failed(R.Status.valueOf(response.getStatus().getErrorCode().getNumber()), response.getStatus().getReason());
        }
        catch (StatusRuntimeException e) {
            this.logError("InsertRequest RPC failed! Collection name:{}\n{}", requestParam.getCollectionName(), e.getMessage());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("InsertRequest failed! Collection name:{}\n{}", requestParam.getCollectionName(), e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<SearchResults> search(@NonNull SearchParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            SearchRequest.Builder builder = SearchRequest.newBuilder().setDbName("").setCollectionName(requestParam.getCollectionName());
            if (!requestParam.getPartitionNames().isEmpty()) {
                requestParam.getPartitionNames().forEach(builder::addPartitionNames);
            }
            PlaceholderType plType = PlaceholderType.None;
            List<?> vectors = requestParam.getVectors();
            ArrayList<ByteString> byteStrings = new ArrayList<ByteString>();
            for (Object vector : vectors) {
                if (vector instanceof List) {
                    plType = PlaceholderType.FloatVector;
                    List list = (List)vector;
                    ByteBuffer buf = ByteBuffer.allocate(4 * list.size());
                    buf.order(ByteOrder.LITTLE_ENDIAN);
                    list.forEach(buf::putFloat);
                    byte[] array = buf.array();
                    ByteString bs = ByteString.copyFrom((byte[])array);
                    byteStrings.add(bs);
                    continue;
                }
                if (vector instanceof ByteBuffer) {
                    plType = PlaceholderType.BinaryVector;
                    ByteBuffer buf = (ByteBuffer)vector;
                    byte[] array = buf.array();
                    ByteString bs = ByteString.copyFrom((byte[])array);
                    byteStrings.add(bs);
                    continue;
                }
                String msg = "Search target vector type is illegal(Only allow List<Float> or ByteBuffer)";
                this.logError(msg, new Object[0]);
                return R.failed(R.Status.UnexpectedError, msg);
            }
            PlaceholderValue.Builder pldBuilder = PlaceholderValue.newBuilder().setTag("$0").setType(plType);
            byteStrings.forEach(pldBuilder::addValues);
            PlaceholderValue plv = pldBuilder.build();
            PlaceholderGroup placeholderGroup = PlaceholderGroup.newBuilder().addPlaceholders(plv).build();
            ByteString byteStr = placeholderGroup.toByteString();
            builder.setPlaceholderGroup(byteStr);
            builder.addSearchParams(KeyValuePair.newBuilder().setKey("anns_field").setValue(requestParam.getVectorFieldName()).build()).addSearchParams(KeyValuePair.newBuilder().setKey("topk").setValue(String.valueOf(requestParam.getTopK())).build()).addSearchParams(KeyValuePair.newBuilder().setKey("metric_type").setValue(requestParam.getMetricType()).build()).addSearchParams(KeyValuePair.newBuilder().setKey("round_decimal").setValue(String.valueOf(requestParam.getRoundDecimal())).build());
            if (null != requestParam.getParams() && !requestParam.getParams().isEmpty()) {
                builder.addSearchParams(KeyValuePair.newBuilder().setKey("params").setValue(requestParam.getParams()).build());
            }
            if (!requestParam.getOutFields().isEmpty()) {
                requestParam.getOutFields().forEach(builder::addOutputFields);
            }
            builder.setDslType(DslType.BoolExprV1);
            if (requestParam.getExpr() != null && !requestParam.getExpr().isEmpty()) {
                builder.setDsl(requestParam.getExpr());
            }
            SearchRequest searchRequest = builder.build();
            SearchResults response = this.blockingStub().search(searchRequest);
            if (response.getStatus().getErrorCode() == ErrorCode.Success) {
                this.logInfo("SearchRequest successfully!", new Object[0]);
                return R.success(response);
            }
            this.logError("SearchRequest failed:\n{}", response.getStatus().getReason());
            return R.failed(R.Status.valueOf(response.getStatus().getErrorCode().getNumber()), response.getStatus().getReason());
        }
        catch (StatusRuntimeException e) {
            this.logError("SearchRequest RPC failed:{}", e.getMessage());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("SearchRequest failed:\n{}", e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<QueryResults> query(@NonNull QueryParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            QueryRequest queryRequest = QueryRequest.newBuilder().setDbName("").setCollectionName(requestParam.getCollectionName()).addAllPartitionNames(requestParam.getPartitionNames()).addAllOutputFields(requestParam.getOutFields()).setExpr(requestParam.getExpr()).build();
            QueryResults response = this.blockingStub().query(queryRequest);
            if (response.getStatus().getErrorCode() == ErrorCode.Success) {
                this.logInfo("QueryRequest successfully!", new Object[0]);
                return R.success(response);
            }
            this.logError("QueryRequest failed:\n{}", response.getStatus().getReason());
            return R.failed(R.Status.valueOf(response.getStatus().getErrorCode().getNumber()), response.getStatus().getReason());
        }
        catch (StatusRuntimeException e) {
            this.logError("QueryRequest RPC failed:{}", e.getMessage());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("QueryRequest failed:\n{}", e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<CalcDistanceResults> calcDistance(@NonNull CalcDistanceParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            List<List<Float>> vectors_left = requestParam.getVectorsLeft();
            List<List<Float>> vectors_right = requestParam.getVectorsRight();
            FloatArray.Builder left_float_array = FloatArray.newBuilder();
            for (List<Float> list : vectors_left) {
                left_float_array.addAllData(list);
            }
            FloatArray.Builder right_float_array = FloatArray.newBuilder();
            for (List<Float> list : vectors_right) {
                right_float_array.addAllData(list);
            }
            CalcDistanceRequest calcDistanceRequest = CalcDistanceRequest.newBuilder().setOpLeft(VectorsArray.newBuilder().setDataArray(VectorField.newBuilder().setFloatVector(left_float_array.build()).setDim(vectors_left.get(0).size()).build()).build()).setOpRight(VectorsArray.newBuilder().setDataArray(VectorField.newBuilder().setFloatVector(right_float_array.build()).setDim(vectors_right.get(0).size()).build()).build()).addParams(KeyValuePair.newBuilder().setKey("metric").setValue(requestParam.getMetricType()).build()).build();
            CalcDistanceResults calcDistanceResults = this.blockingStub().calcDistance(calcDistanceRequest);
            if (calcDistanceResults.getStatus().getErrorCode() == ErrorCode.Success) {
                this.logInfo("CalcDistanceRequest successfully!", new Object[0]);
                return R.success(calcDistanceResults);
            }
            this.logError("CalcDistanceRequest failed:\n{}", calcDistanceResults.getStatus().getReason());
            return R.failed(R.Status.valueOf(calcDistanceResults.getStatus().getErrorCode().getNumber()), calcDistanceResults.getStatus().getReason());
        }
        catch (StatusRuntimeException e) {
            this.logError("CalcDistanceRequest RPC failed:{}", e.getMessage());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("CalcDistanceRequest failed:\n{}", e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<GetMetricsResponse> getMetrics(@NonNull GetMetricsParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            GetMetricsRequest getMetricsRequest = GetMetricsRequest.newBuilder().setRequest(requestParam.getRequest()).build();
            GetMetricsResponse response = this.blockingStub().getMetrics(getMetricsRequest);
            if (response.getStatus().getErrorCode() == ErrorCode.Success) {
                this.logInfo("GetMetricsRequest successfully!", new Object[0]);
                return R.success(response);
            }
            this.logError("GetMetricsRequest failed:\n{}", response.getStatus().getReason());
            return R.failed(R.Status.valueOf(response.getStatus().getErrorCode().getNumber()), response.getStatus().getReason());
        }
        catch (StatusRuntimeException e) {
            this.logError("GetMetricsRequest RPC failed:\n{}", e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("GetMetricsRequest failed:\n{}", e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<GetFlushStateResponse> getFlushState(@NonNull GetFlushStateParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            GetFlushStateRequest getFlushStateRequest = GetFlushStateRequest.newBuilder().addAllSegmentIDs(requestParam.getSegmentIDs()).build();
            GetFlushStateResponse response = this.blockingStub().getFlushState(getFlushStateRequest);
            if (response.getStatus().getErrorCode() == ErrorCode.Success) {
                this.logInfo("GetFlushState successfully!", new Object[0]);
                return R.success(response);
            }
            this.logError("GetFlushState failed:\n{}", response.getStatus().getReason());
            return R.failed(R.Status.valueOf(response.getStatus().getErrorCode().getNumber()), response.getStatus().getReason());
        }
        catch (StatusRuntimeException e) {
            this.logError("GetFlushState RPC failed:\n{}", e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("GetFlushState failed:\n{}", e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<GetPersistentSegmentInfoResponse> getPersistentSegmentInfo(@NonNull GetPersistentSegmentInfoParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            GetPersistentSegmentInfoRequest getSegmentInfoRequest = GetPersistentSegmentInfoRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).build();
            GetPersistentSegmentInfoResponse response = this.blockingStub().getPersistentSegmentInfo(getSegmentInfoRequest);
            if (response.getStatus().getErrorCode() == ErrorCode.Success) {
                this.logInfo("GetPersistentSegmentInfoRequest successfully!", new Object[0]);
                return R.success(response);
            }
            this.logError("GetPersistentSegmentInfoRequest failed:\n{}", response.getStatus().getReason());
            return R.failed(R.Status.valueOf(response.getStatus().getErrorCode().getNumber()), response.getStatus().getReason());
        }
        catch (StatusRuntimeException e) {
            this.logError("GetPersistentSegmentInfoRequest RPC failed:\n{}", e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("GetPersistentSegmentInfoRequest failed:\n{}", e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<GetQuerySegmentInfoResponse> getQuerySegmentInfo(@NonNull GetQuerySegmentInfoParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            GetQuerySegmentInfoRequest getSegmentInfoRequest = GetQuerySegmentInfoRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).build();
            GetQuerySegmentInfoResponse response = this.blockingStub().getQuerySegmentInfo(getSegmentInfoRequest);
            if (response.getStatus().getErrorCode() == ErrorCode.Success) {
                this.logInfo("GetQuerySegmentInfoRequest successfully!", new Object[0]);
                return R.success(response);
            }
            this.logError("GetQuerySegmentInfoRequest failed:\n{}", response.getStatus().getReason());
            return R.failed(R.Status.valueOf(response.getStatus().getErrorCode().getNumber()), response.getStatus().getReason());
        }
        catch (StatusRuntimeException e) {
            this.logError("GetQuerySegmentInfoRequest RPC failed:\n{}", e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("GetQuerySegmentInfoRequest failed:\n{}", e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> loadBalance(LoadBalanceParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            LoadBalanceRequest loadBalanceRequest = LoadBalanceRequest.newBuilder().setSrcNodeID(requestParam.getSrcNodeID()).addAllDstNodeIDs(requestParam.getDestNodeIDs()).addAllSealedSegmentIDs(requestParam.getSegmentIDs()).build();
            Status response = this.blockingStub().loadBalance(loadBalanceRequest);
            if (response.getErrorCode() == ErrorCode.Success) {
                this.logInfo("LoadBalanceRequest successfully!", new Object[0]);
                return R.success(new RpcStatus("Success"));
            }
            this.logError("LoadBalanceRequest failed! \n{}", response.getReason());
            return R.failed(R.Status.valueOf(response.getErrorCode().getNumber()), response.getReason());
        }
        catch (StatusRuntimeException e) {
            this.logError("LoadBalanceRequest RPC failed:\n{}", e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("LoadBalanceRequest failed:\n{}", e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<GetCompactionStateResponse> getCompactionState(GetCompactionStateParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            GetCompactionStateRequest getCompactionStateRequest = GetCompactionStateRequest.newBuilder().setCompactionID(requestParam.getCompactionID()).build();
            GetCompactionStateResponse response = this.blockingStub().getCompactionState(getCompactionStateRequest);
            if (response.getStatus().getErrorCode() == ErrorCode.Success) {
                this.logInfo("GetCompactionStateRequest successfully!", new Object[0]);
                return R.success(response);
            }
            this.logError("GetCompactionStateRequest failed:\n{}", response.getStatus().getReason());
            return R.failed(R.Status.valueOf(response.getStatus().getErrorCode().getNumber()), response.getStatus().getReason());
        }
        catch (StatusRuntimeException e) {
            this.logError("GetCompactionStateRequest RPC failed:\n{}", e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("GetCompactionStateRequest failed:\n{}", e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<ManualCompactionResponse> manualCompaction(ManualCompactionParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            R<DescribeCollectionResponse> descResp = this.describeCollection(DescribeCollectionParam.newBuilder().withCollectionName(requestParam.getCollectionName()).build());
            if (descResp.getStatus().intValue() != R.Status.Success.getCode()) {
                this.logInfo("ManualCompactionRequest successfully!", new Object[0]);
                return R.failed(R.Status.valueOf(descResp.getStatus()), descResp.getMessage());
            }
            ManualCompactionRequest manualCompactionRequest = ManualCompactionRequest.newBuilder().setCollectionID(descResp.getData().getCollectionID()).build();
            ManualCompactionResponse response = this.blockingStub().manualCompaction(manualCompactionRequest);
            if (response.getStatus().getErrorCode() == ErrorCode.Success) {
                this.logInfo("ManualCompactionRequest successfully!", new Object[0]);
                return R.success(response);
            }
            this.logError("ManualCompactionRequest failed:\n{}", response.getStatus().getReason());
            return R.failed(R.Status.valueOf(response.getStatus().getErrorCode().getNumber()), response.getStatus().getReason());
        }
        catch (StatusRuntimeException e) {
            this.logError("ManualCompactionRequest RPC failed:\n{}", e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("ManualCompactionRequest failed:\n{}", e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<GetCompactionPlansResponse> getCompactionStateWithPlans(GetCompactionPlansParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            GetCompactionPlansRequest getCompactionPlansRequest = GetCompactionPlansRequest.newBuilder().setCompactionID(requestParam.getCompactionID()).build();
            GetCompactionPlansResponse response = this.blockingStub().getCompactionStateWithPlans(getCompactionPlansRequest);
            if (response.getStatus().getErrorCode() == ErrorCode.Success) {
                this.logInfo("GetCompactionPlansRequest successfully!", new Object[0]);
                return R.success(response);
            }
            this.logError("GetCompactionPlansRequest failed:\n{}", response.getStatus().getReason());
            return R.failed(R.Status.valueOf(response.getStatus().getErrorCode().getNumber()), response.getStatus().getReason());
        }
        catch (StatusRuntimeException e) {
            this.logError("GetCompactionPlansRequest RPC failed:\n{}", e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("GetCompactionPlansRequest failed:\n{}", e.getMessage());
            return R.failed(e);
        }
    }

    private void logInfo(String msg, Object ... params) {
        logger.info(msg, params);
    }

    private void logWarning(String msg, Object ... params) {
        logger.warn(msg, params);
    }

    private void logError(String msg, Object ... params) {
        logger.error(msg, params);
    }
}

