/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.collection;

import io.milvus.exception.ParamException;
import io.milvus.grpc.DataType;
import io.milvus.param.ParamUtils;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;

public class FieldType {
    private final String name;
    private final boolean primaryKey;
    private final String description;
    private final DataType dataType;
    private final Map<String, String> typeParams;
    private final boolean autoID;

    private FieldType(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.name = builder.name;
        this.primaryKey = builder.primaryKey;
        this.description = builder.description;
        this.dataType = builder.dataType;
        this.typeParams = builder.typeParams;
        this.autoID = builder.autoID;
    }

    public int getDimension() {
        if (this.typeParams.containsKey("dim")) {
            return Integer.parseInt(this.typeParams.get("dim"));
        }
        return 0;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return "FieldType{name='" + this.name + '\'' + ", type='" + this.dataType.name() + '\'' + ", primaryKey=" + this.primaryKey + ", autoID=" + this.autoID + ", params=" + this.typeParams.toString() + '}';
    }

    public String getName() {
        return this.name;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public String getDescription() {
        return this.description;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public Map<String, String> getTypeParams() {
        return this.typeParams;
    }

    public boolean isAutoID() {
        return this.autoID;
    }

    public static final class Builder {
        private String name;
        private boolean primaryKey = false;
        private String description = "";
        private DataType dataType;
        private final Map<String, String> typeParams = new HashMap<String, String>();
        private boolean autoID = false;

        private Builder() {
        }

        public Builder withName(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        public Builder withPrimaryKey(boolean primaryKey) {
            this.primaryKey = primaryKey;
            return this;
        }

        public Builder withDescription(@NonNull String description) {
            if (description == null) {
                throw new NullPointerException("description is marked non-null but is null");
            }
            this.description = description;
            return this;
        }

        public Builder withDataType(@NonNull DataType dataType) {
            if (dataType == null) {
                throw new NullPointerException("dataType is marked non-null but is null");
            }
            this.dataType = dataType;
            return this;
        }

        public Builder addTypeParam(@NonNull String key, @NonNull String value) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            this.typeParams.put(key, value);
            return this;
        }

        public Builder withTypeParams(@NonNull Map<String, String> typeParams) {
            if (typeParams == null) {
                throw new NullPointerException("typeParams is marked non-null but is null");
            }
            typeParams.forEach(this.typeParams::put);
            return this;
        }

        public Builder withDimension(@NonNull Integer dimension) {
            if (dimension == null) {
                throw new NullPointerException("dimension is marked non-null but is null");
            }
            this.typeParams.put("dim", dimension.toString());
            return this;
        }

        public Builder withAutoID(boolean autoID) {
            this.autoID = autoID;
            return this;
        }

        public FieldType build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.name, "Field name");
            if (this.dataType == null || this.dataType == DataType.None) {
                throw new ParamException("Field data type is illegal");
            }
            if (this.dataType == DataType.FloatVector || this.dataType == DataType.BinaryVector) {
                if (!this.typeParams.containsKey("dim")) {
                    throw new ParamException("Vector field dimension must be specified");
                }
                try {
                    int dim = Integer.parseInt(this.typeParams.get("dim"));
                    if (dim <= 0) {
                        throw new ParamException("Vector field dimension must be larger than zero");
                    }
                }
                catch (NumberFormatException e) {
                    throw new ParamException("Vector field dimension must be an integer number");
                }
            }
            return new FieldType(this);
        }
    }
}

