/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.collection;

import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;
import lombok.NonNull;

public class GetCollectionStatisticsParam {
    private final String collectionName;
    private final boolean flushCollection;

    private GetCollectionStatisticsParam(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.collectionName = builder.collectionName;
        this.flushCollection = builder.flushCollection;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return "GetCollectionStatisticsParam{collectionName='" + this.collectionName + '\'' + " flush=" + this.flushCollection + '}';
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public boolean isFlushCollection() {
        return this.flushCollection;
    }

    public static final class Builder {
        private String collectionName;
        private Boolean flushCollection = Boolean.TRUE;

        private Builder() {
        }

        public Builder withCollectionName(@NonNull String collectionName) {
            if (collectionName == null) {
                throw new NullPointerException("collectionName is marked non-null but is null");
            }
            this.collectionName = collectionName;
            return this;
        }

        public Builder withFlush(@NonNull Boolean flush) {
            if (flush == null) {
                throw new NullPointerException("flush is marked non-null but is null");
            }
            this.flushCollection = flush;
            return this;
        }

        public GetCollectionStatisticsParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.collectionName, "Collection name");
            return new GetCollectionStatisticsParam(this);
        }
    }
}

