/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.collection;

import io.milvus.exception.ParamException;
import io.milvus.param.Constant;
import io.milvus.param.ParamUtils;
import lombok.NonNull;

public class LoadCollectionParam {
    private final String collectionName;
    private final boolean syncLoad;
    private final long syncLoadWaitingInterval;
    private final long syncLoadWaitingTimeout;

    public LoadCollectionParam(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.collectionName = builder.collectionName;
        this.syncLoad = builder.syncLoad;
        this.syncLoadWaitingInterval = builder.syncLoadWaitingInterval;
        this.syncLoadWaitingTimeout = builder.syncLoadWaitingTimeout;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return "LoadCollectionParam{collectionName='" + this.collectionName + '\'' + ", syncLoad=" + this.syncLoad + ", syncLoadWaitingInterval=" + this.syncLoadWaitingInterval + '}';
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public boolean isSyncLoad() {
        return this.syncLoad;
    }

    public long getSyncLoadWaitingInterval() {
        return this.syncLoadWaitingInterval;
    }

    public long getSyncLoadWaitingTimeout() {
        return this.syncLoadWaitingTimeout;
    }

    public static final class Builder {
        private String collectionName;
        private Boolean syncLoad = Boolean.TRUE;
        private Long syncLoadWaitingInterval = 500L;
        private Long syncLoadWaitingTimeout = 60L;

        private Builder() {
        }

        public Builder withCollectionName(@NonNull String collectionName) {
            if (collectionName == null) {
                throw new NullPointerException("collectionName is marked non-null but is null");
            }
            this.collectionName = collectionName;
            return this;
        }

        public Builder withSyncLoad(@NonNull Boolean syncLoad) {
            if (syncLoad == null) {
                throw new NullPointerException("syncLoad is marked non-null but is null");
            }
            this.syncLoad = syncLoad;
            return this;
        }

        public Builder withSyncLoadWaitingInterval(@NonNull Long milliseconds) {
            if (milliseconds == null) {
                throw new NullPointerException("milliseconds is marked non-null but is null");
            }
            this.syncLoadWaitingInterval = milliseconds;
            return this;
        }

        public Builder withSyncLoadWaitingTimeout(@NonNull Long seconds) {
            if (seconds == null) {
                throw new NullPointerException("seconds is marked non-null but is null");
            }
            this.syncLoadWaitingTimeout = seconds;
            return this;
        }

        public LoadCollectionParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.collectionName, "Collection name");
            if (this.syncLoad == Boolean.TRUE) {
                if (this.syncLoadWaitingInterval <= 0L) {
                    throw new ParamException("Sync load waiting interval must be larger than zero");
                }
                if (this.syncLoadWaitingInterval > Constant.MAX_WAITING_LOADING_INTERVAL) {
                    throw new ParamException("Sync load waiting interval cannot be larger than " + Constant.MAX_WAITING_LOADING_INTERVAL.toString() + " milliseconds");
                }
                if (this.syncLoadWaitingTimeout <= 0L) {
                    throw new ParamException("Sync load waiting timeout must be larger than zero");
                }
                if (this.syncLoadWaitingTimeout > Constant.MAX_WAITING_LOADING_TIMEOUT) {
                    throw new ParamException("Sync load waiting timeout cannot be larger than " + Constant.MAX_WAITING_LOADING_TIMEOUT.toString() + " seconds");
                }
            }
            return new LoadCollectionParam(this);
        }
    }
}

