/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.dml;

import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;
import java.util.List;
import lombok.NonNull;

public class InsertParam {
    private final List<Field> fields;
    private final String collectionName;
    private final String partitionName;
    private final int rowCount;

    private InsertParam(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.collectionName = builder.collectionName;
        this.partitionName = builder.partitionName;
        this.fields = builder.fields;
        this.rowCount = builder.rowCount;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return "InsertParam{collectionName='" + this.collectionName + '\'' + ", partitionName='" + this.partitionName + '\'' + ", row_count=" + this.rowCount + ", fields=" + this.fields + '}';
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public static class Field {
        private final String name;
        private final List<?> values;

        public Field(String name, List<?> values) {
            this.name = name;
            this.values = values;
        }

        public String getName() {
            return this.name;
        }

        public List<?> getValues() {
            return this.values;
        }

        public String toString() {
            return "Field{fieldName='" + this.name + '\'' + ", row_count=" + this.values.size() + '}';
        }
    }

    public static class Builder {
        private String collectionName;
        private String partitionName = "_default";
        private List<Field> fields;
        private int rowCount;

        private Builder() {
        }

        public Builder withCollectionName(@NonNull String collectionName) {
            if (collectionName == null) {
                throw new NullPointerException("collectionName is marked non-null but is null");
            }
            this.collectionName = collectionName;
            return this;
        }

        public Builder withPartitionName(@NonNull String partitionName) {
            if (partitionName == null) {
                throw new NullPointerException("partitionName is marked non-null but is null");
            }
            this.partitionName = partitionName;
            return this;
        }

        public Builder withFields(@NonNull List<Field> fields) {
            if (fields == null) {
                throw new NullPointerException("fields is marked non-null but is null");
            }
            this.fields = fields;
            return this;
        }

        public InsertParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.collectionName, "Collection name");
            if (this.fields.isEmpty()) {
                throw new ParamException("Fields cannot be empty");
            }
            for (Field field : this.fields) {
                if (field == null) {
                    throw new ParamException("Field cannot be null. If the field is auto-id, just ignore it from withFields()");
                }
                ParamUtils.CheckNullEmptyString(field.getName(), "Field name");
                if (field.getValues() != null && !field.getValues().isEmpty()) continue;
                throw new ParamException("Field value cannot be empty. If the field is auto-id, just ignore it from withFields()");
            }
            int count = this.fields.get(0).getValues().size();
            for (Field field : this.fields) {
                if (field.getValues().size() == count) continue;
                throw new ParamException("Row count of fields must be equal");
            }
            this.rowCount = count;
            if (count == 0) {
                throw new ParamException("Zero row count is not allowed");
            }
            return new InsertParam(this);
        }
    }
}

