/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.grpc;

import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.LazyStringArrayList;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import io.milvus.grpc.ConsistencyLevel;
import io.milvus.grpc.DslType;
import io.milvus.grpc.KeyValuePair;
import io.milvus.grpc.KeyValuePairOrBuilder;
import io.milvus.grpc.MilvusProto;
import io.milvus.grpc.MsgBase;
import io.milvus.grpc.MsgBaseOrBuilder;
import io.milvus.grpc.SearchRequestOrBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class SearchRequest
extends GeneratedMessageV3
implements SearchRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int BASE_FIELD_NUMBER = 1;
    private MsgBase base_;
    public static final int DB_NAME_FIELD_NUMBER = 2;
    private volatile Object dbName_;
    public static final int COLLECTION_NAME_FIELD_NUMBER = 3;
    private volatile Object collectionName_;
    public static final int PARTITION_NAMES_FIELD_NUMBER = 4;
    private LazyStringList partitionNames_;
    public static final int DSL_FIELD_NUMBER = 5;
    private volatile Object dsl_;
    public static final int PLACEHOLDER_GROUP_FIELD_NUMBER = 6;
    private ByteString placeholderGroup_;
    public static final int DSL_TYPE_FIELD_NUMBER = 7;
    private int dslType_;
    public static final int OUTPUT_FIELDS_FIELD_NUMBER = 8;
    private LazyStringList outputFields_;
    public static final int SEARCH_PARAMS_FIELD_NUMBER = 9;
    private List<KeyValuePair> searchParams_;
    public static final int TRAVEL_TIMESTAMP_FIELD_NUMBER = 10;
    private long travelTimestamp_;
    public static final int GUARANTEE_TIMESTAMP_FIELD_NUMBER = 11;
    private long guaranteeTimestamp_;
    public static final int NQ_FIELD_NUMBER = 12;
    private long nq_;
    public static final int NOT_RETURN_ALL_META_FIELD_NUMBER = 13;
    private boolean notReturnAllMeta_;
    public static final int CONSISTENCY_LEVEL_FIELD_NUMBER = 14;
    private int consistencyLevel_;
    public static final int USE_DEFAULT_CONSISTENCY_FIELD_NUMBER = 15;
    private boolean useDefaultConsistency_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final SearchRequest DEFAULT_INSTANCE = new SearchRequest();
    private static final Parser<SearchRequest> PARSER = new AbstractParser<SearchRequest>(){

        public SearchRequest parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = SearchRequest.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private SearchRequest(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private SearchRequest() {
        this.dbName_ = "";
        this.collectionName_ = "";
        this.partitionNames_ = LazyStringArrayList.EMPTY;
        this.dsl_ = "";
        this.placeholderGroup_ = ByteString.EMPTY;
        this.dslType_ = 0;
        this.outputFields_ = LazyStringArrayList.EMPTY;
        this.searchParams_ = Collections.emptyList();
        this.consistencyLevel_ = 0;
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new SearchRequest();
    }

    public final UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return MilvusProto.internal_static_milvus_proto_milvus_SearchRequest_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return MilvusProto.internal_static_milvus_proto_milvus_SearchRequest_fieldAccessorTable.ensureFieldAccessorsInitialized(SearchRequest.class, Builder.class);
    }

    @Override
    public boolean hasBase() {
        return this.base_ != null;
    }

    @Override
    public MsgBase getBase() {
        return this.base_ == null ? MsgBase.getDefaultInstance() : this.base_;
    }

    @Override
    public MsgBaseOrBuilder getBaseOrBuilder() {
        return this.getBase();
    }

    @Override
    public String getDbName() {
        Object ref = this.dbName_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.dbName_ = s;
        return s;
    }

    @Override
    public ByteString getDbNameBytes() {
        Object ref = this.dbName_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.dbName_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getCollectionName() {
        Object ref = this.collectionName_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.collectionName_ = s;
        return s;
    }

    @Override
    public ByteString getCollectionNameBytes() {
        Object ref = this.collectionName_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.collectionName_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    public ProtocolStringList getPartitionNamesList() {
        return this.partitionNames_;
    }

    @Override
    public int getPartitionNamesCount() {
        return this.partitionNames_.size();
    }

    @Override
    public String getPartitionNames(int index) {
        return (String)this.partitionNames_.get(index);
    }

    @Override
    public ByteString getPartitionNamesBytes(int index) {
        return this.partitionNames_.getByteString(index);
    }

    @Override
    public String getDsl() {
        Object ref = this.dsl_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.dsl_ = s;
        return s;
    }

    @Override
    public ByteString getDslBytes() {
        Object ref = this.dsl_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.dsl_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public ByteString getPlaceholderGroup() {
        return this.placeholderGroup_;
    }

    @Override
    public int getDslTypeValue() {
        return this.dslType_;
    }

    @Override
    public DslType getDslType() {
        DslType result = DslType.valueOf(this.dslType_);
        return result == null ? DslType.UNRECOGNIZED : result;
    }

    public ProtocolStringList getOutputFieldsList() {
        return this.outputFields_;
    }

    @Override
    public int getOutputFieldsCount() {
        return this.outputFields_.size();
    }

    @Override
    public String getOutputFields(int index) {
        return (String)this.outputFields_.get(index);
    }

    @Override
    public ByteString getOutputFieldsBytes(int index) {
        return this.outputFields_.getByteString(index);
    }

    @Override
    public List<KeyValuePair> getSearchParamsList() {
        return this.searchParams_;
    }

    @Override
    public List<? extends KeyValuePairOrBuilder> getSearchParamsOrBuilderList() {
        return this.searchParams_;
    }

    @Override
    public int getSearchParamsCount() {
        return this.searchParams_.size();
    }

    @Override
    public KeyValuePair getSearchParams(int index) {
        return this.searchParams_.get(index);
    }

    @Override
    public KeyValuePairOrBuilder getSearchParamsOrBuilder(int index) {
        return this.searchParams_.get(index);
    }

    @Override
    public long getTravelTimestamp() {
        return this.travelTimestamp_;
    }

    @Override
    public long getGuaranteeTimestamp() {
        return this.guaranteeTimestamp_;
    }

    @Override
    public long getNq() {
        return this.nq_;
    }

    @Override
    public boolean getNotReturnAllMeta() {
        return this.notReturnAllMeta_;
    }

    @Override
    public int getConsistencyLevelValue() {
        return this.consistencyLevel_;
    }

    @Override
    public ConsistencyLevel getConsistencyLevel() {
        ConsistencyLevel result = ConsistencyLevel.valueOf(this.consistencyLevel_);
        return result == null ? ConsistencyLevel.UNRECOGNIZED : result;
    }

    @Override
    public boolean getUseDefaultConsistency() {
        return this.useDefaultConsistency_;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        if (this.base_ != null) {
            output.writeMessage(1, (MessageLite)this.getBase());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.dbName_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)2, (Object)this.dbName_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.collectionName_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)3, (Object)this.collectionName_);
        }
        for (i = 0; i < this.partitionNames_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)4, (Object)this.partitionNames_.getRaw(i));
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.dsl_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)5, (Object)this.dsl_);
        }
        if (!this.placeholderGroup_.isEmpty()) {
            output.writeBytes(6, this.placeholderGroup_);
        }
        if (this.dslType_ != DslType.Dsl.getNumber()) {
            output.writeEnum(7, this.dslType_);
        }
        for (i = 0; i < this.outputFields_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)8, (Object)this.outputFields_.getRaw(i));
        }
        for (i = 0; i < this.searchParams_.size(); ++i) {
            output.writeMessage(9, (MessageLite)this.searchParams_.get(i));
        }
        if (this.travelTimestamp_ != 0L) {
            output.writeUInt64(10, this.travelTimestamp_);
        }
        if (this.guaranteeTimestamp_ != 0L) {
            output.writeUInt64(11, this.guaranteeTimestamp_);
        }
        if (this.nq_ != 0L) {
            output.writeInt64(12, this.nq_);
        }
        if (this.notReturnAllMeta_) {
            output.writeBool(13, this.notReturnAllMeta_);
        }
        if (this.consistencyLevel_ != ConsistencyLevel.Strong.getNumber()) {
            output.writeEnum(14, this.consistencyLevel_);
        }
        if (this.useDefaultConsistency_) {
            output.writeBool(15, this.useDefaultConsistency_);
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (this.base_ != null) {
            size += CodedOutputStream.computeMessageSize((int)1, (MessageLite)this.getBase());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.dbName_)) {
            size += GeneratedMessageV3.computeStringSize((int)2, (Object)this.dbName_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.collectionName_)) {
            size += GeneratedMessageV3.computeStringSize((int)3, (Object)this.collectionName_);
        }
        int dataSize = 0;
        for (i = 0; i < this.partitionNames_.size(); ++i) {
            dataSize += SearchRequest.computeStringSizeNoTag((Object)this.partitionNames_.getRaw(i));
        }
        size += dataSize;
        size += 1 * this.getPartitionNamesList().size();
        if (!GeneratedMessageV3.isStringEmpty((Object)this.dsl_)) {
            size += GeneratedMessageV3.computeStringSize((int)5, (Object)this.dsl_);
        }
        if (!this.placeholderGroup_.isEmpty()) {
            size += CodedOutputStream.computeBytesSize((int)6, (ByteString)this.placeholderGroup_);
        }
        if (this.dslType_ != DslType.Dsl.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)7, (int)this.dslType_);
        }
        dataSize = 0;
        for (i = 0; i < this.outputFields_.size(); ++i) {
            dataSize += SearchRequest.computeStringSizeNoTag((Object)this.outputFields_.getRaw(i));
        }
        size += dataSize;
        size += 1 * this.getOutputFieldsList().size();
        for (int i2 = 0; i2 < this.searchParams_.size(); ++i2) {
            size += CodedOutputStream.computeMessageSize((int)9, (MessageLite)((MessageLite)this.searchParams_.get(i2)));
        }
        if (this.travelTimestamp_ != 0L) {
            size += CodedOutputStream.computeUInt64Size((int)10, (long)this.travelTimestamp_);
        }
        if (this.guaranteeTimestamp_ != 0L) {
            size += CodedOutputStream.computeUInt64Size((int)11, (long)this.guaranteeTimestamp_);
        }
        if (this.nq_ != 0L) {
            size += CodedOutputStream.computeInt64Size((int)12, (long)this.nq_);
        }
        if (this.notReturnAllMeta_) {
            size += CodedOutputStream.computeBoolSize((int)13, (boolean)this.notReturnAllMeta_);
        }
        if (this.consistencyLevel_ != ConsistencyLevel.Strong.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)14, (int)this.consistencyLevel_);
        }
        if (this.useDefaultConsistency_) {
            size += CodedOutputStream.computeBoolSize((int)15, (boolean)this.useDefaultConsistency_);
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SearchRequest)) {
            return super.equals(obj);
        }
        SearchRequest other = (SearchRequest)obj;
        if (this.hasBase() != other.hasBase()) {
            return false;
        }
        if (this.hasBase() && !this.getBase().equals(other.getBase())) {
            return false;
        }
        if (!this.getDbName().equals(other.getDbName())) {
            return false;
        }
        if (!this.getCollectionName().equals(other.getCollectionName())) {
            return false;
        }
        if (!this.getPartitionNamesList().equals(other.getPartitionNamesList())) {
            return false;
        }
        if (!this.getDsl().equals(other.getDsl())) {
            return false;
        }
        if (!this.getPlaceholderGroup().equals((Object)other.getPlaceholderGroup())) {
            return false;
        }
        if (this.dslType_ != other.dslType_) {
            return false;
        }
        if (!this.getOutputFieldsList().equals(other.getOutputFieldsList())) {
            return false;
        }
        if (!this.getSearchParamsList().equals(other.getSearchParamsList())) {
            return false;
        }
        if (this.getTravelTimestamp() != other.getTravelTimestamp()) {
            return false;
        }
        if (this.getGuaranteeTimestamp() != other.getGuaranteeTimestamp()) {
            return false;
        }
        if (this.getNq() != other.getNq()) {
            return false;
        }
        if (this.getNotReturnAllMeta() != other.getNotReturnAllMeta()) {
            return false;
        }
        if (this.consistencyLevel_ != other.consistencyLevel_) {
            return false;
        }
        if (this.getUseDefaultConsistency() != other.getUseDefaultConsistency()) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + SearchRequest.getDescriptor().hashCode();
        if (this.hasBase()) {
            hash = 37 * hash + 1;
            hash = 53 * hash + this.getBase().hashCode();
        }
        hash = 37 * hash + 2;
        hash = 53 * hash + this.getDbName().hashCode();
        hash = 37 * hash + 3;
        hash = 53 * hash + this.getCollectionName().hashCode();
        if (this.getPartitionNamesCount() > 0) {
            hash = 37 * hash + 4;
            hash = 53 * hash + this.getPartitionNamesList().hashCode();
        }
        hash = 37 * hash + 5;
        hash = 53 * hash + this.getDsl().hashCode();
        hash = 37 * hash + 6;
        hash = 53 * hash + this.getPlaceholderGroup().hashCode();
        hash = 37 * hash + 7;
        hash = 53 * hash + this.dslType_;
        if (this.getOutputFieldsCount() > 0) {
            hash = 37 * hash + 8;
            hash = 53 * hash + this.getOutputFieldsList().hashCode();
        }
        if (this.getSearchParamsCount() > 0) {
            hash = 37 * hash + 9;
            hash = 53 * hash + this.getSearchParamsList().hashCode();
        }
        hash = 37 * hash + 10;
        hash = 53 * hash + Internal.hashLong((long)this.getTravelTimestamp());
        hash = 37 * hash + 11;
        hash = 53 * hash + Internal.hashLong((long)this.getGuaranteeTimestamp());
        hash = 37 * hash + 12;
        hash = 53 * hash + Internal.hashLong((long)this.getNq());
        hash = 37 * hash + 13;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getNotReturnAllMeta());
        hash = 37 * hash + 14;
        hash = 53 * hash + this.consistencyLevel_;
        hash = 37 * hash + 15;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getUseDefaultConsistency());
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static SearchRequest parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (SearchRequest)PARSER.parseFrom(data);
    }

    public static SearchRequest parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (SearchRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static SearchRequest parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (SearchRequest)PARSER.parseFrom(data);
    }

    public static SearchRequest parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (SearchRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static SearchRequest parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (SearchRequest)PARSER.parseFrom(data);
    }

    public static SearchRequest parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (SearchRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static SearchRequest parseFrom(InputStream input) throws IOException {
        return (SearchRequest)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static SearchRequest parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (SearchRequest)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static SearchRequest parseDelimitedFrom(InputStream input) throws IOException {
        return (SearchRequest)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static SearchRequest parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (SearchRequest)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static SearchRequest parseFrom(CodedInputStream input) throws IOException {
        return (SearchRequest)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static SearchRequest parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (SearchRequest)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return SearchRequest.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(SearchRequest prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static SearchRequest getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<SearchRequest> parser() {
        return PARSER;
    }

    public Parser<SearchRequest> getParserForType() {
        return PARSER;
    }

    public SearchRequest getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements SearchRequestOrBuilder {
        private int bitField0_;
        private MsgBase base_;
        private SingleFieldBuilderV3<MsgBase, MsgBase.Builder, MsgBaseOrBuilder> baseBuilder_;
        private Object dbName_ = "";
        private Object collectionName_ = "";
        private LazyStringList partitionNames_ = LazyStringArrayList.EMPTY;
        private Object dsl_ = "";
        private ByteString placeholderGroup_ = ByteString.EMPTY;
        private int dslType_ = 0;
        private LazyStringList outputFields_ = LazyStringArrayList.EMPTY;
        private List<KeyValuePair> searchParams_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<KeyValuePair, KeyValuePair.Builder, KeyValuePairOrBuilder> searchParamsBuilder_;
        private long travelTimestamp_;
        private long guaranteeTimestamp_;
        private long nq_;
        private boolean notReturnAllMeta_;
        private int consistencyLevel_ = 0;
        private boolean useDefaultConsistency_;

        public static final Descriptors.Descriptor getDescriptor() {
            return MilvusProto.internal_static_milvus_proto_milvus_SearchRequest_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return MilvusProto.internal_static_milvus_proto_milvus_SearchRequest_fieldAccessorTable.ensureFieldAccessorsInitialized(SearchRequest.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
        }

        public Builder clear() {
            super.clear();
            if (this.baseBuilder_ == null) {
                this.base_ = null;
            } else {
                this.base_ = null;
                this.baseBuilder_ = null;
            }
            this.dbName_ = "";
            this.collectionName_ = "";
            this.partitionNames_ = LazyStringArrayList.EMPTY;
            this.bitField0_ &= 0xFFFFFFFE;
            this.dsl_ = "";
            this.placeholderGroup_ = ByteString.EMPTY;
            this.dslType_ = 0;
            this.outputFields_ = LazyStringArrayList.EMPTY;
            this.bitField0_ &= 0xFFFFFFFD;
            if (this.searchParamsBuilder_ == null) {
                this.searchParams_ = Collections.emptyList();
            } else {
                this.searchParams_ = null;
                this.searchParamsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFFB;
            this.travelTimestamp_ = 0L;
            this.guaranteeTimestamp_ = 0L;
            this.nq_ = 0L;
            this.notReturnAllMeta_ = false;
            this.consistencyLevel_ = 0;
            this.useDefaultConsistency_ = false;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return MilvusProto.internal_static_milvus_proto_milvus_SearchRequest_descriptor;
        }

        public SearchRequest getDefaultInstanceForType() {
            return SearchRequest.getDefaultInstance();
        }

        public SearchRequest build() {
            SearchRequest result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public SearchRequest buildPartial() {
            SearchRequest result = new SearchRequest(this);
            int from_bitField0_ = this.bitField0_;
            if (this.baseBuilder_ == null) {
                result.base_ = this.base_;
            } else {
                result.base_ = (MsgBase)this.baseBuilder_.build();
            }
            result.dbName_ = this.dbName_;
            result.collectionName_ = this.collectionName_;
            if ((this.bitField0_ & 1) != 0) {
                this.partitionNames_ = this.partitionNames_.getUnmodifiableView();
                this.bitField0_ &= 0xFFFFFFFE;
            }
            result.partitionNames_ = this.partitionNames_;
            result.dsl_ = this.dsl_;
            result.placeholderGroup_ = this.placeholderGroup_;
            result.dslType_ = this.dslType_;
            if ((this.bitField0_ & 2) != 0) {
                this.outputFields_ = this.outputFields_.getUnmodifiableView();
                this.bitField0_ &= 0xFFFFFFFD;
            }
            result.outputFields_ = this.outputFields_;
            if (this.searchParamsBuilder_ == null) {
                if ((this.bitField0_ & 4) != 0) {
                    this.searchParams_ = Collections.unmodifiableList(this.searchParams_);
                    this.bitField0_ &= 0xFFFFFFFB;
                }
                result.searchParams_ = this.searchParams_;
            } else {
                result.searchParams_ = this.searchParamsBuilder_.build();
            }
            result.travelTimestamp_ = this.travelTimestamp_;
            result.guaranteeTimestamp_ = this.guaranteeTimestamp_;
            result.nq_ = this.nq_;
            result.notReturnAllMeta_ = this.notReturnAllMeta_;
            result.consistencyLevel_ = this.consistencyLevel_;
            result.useDefaultConsistency_ = this.useDefaultConsistency_;
            this.onBuilt();
            return result;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof SearchRequest) {
                return this.mergeFrom((SearchRequest)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(SearchRequest other) {
            if (other == SearchRequest.getDefaultInstance()) {
                return this;
            }
            if (other.hasBase()) {
                this.mergeBase(other.getBase());
            }
            if (!other.getDbName().isEmpty()) {
                this.dbName_ = other.dbName_;
                this.onChanged();
            }
            if (!other.getCollectionName().isEmpty()) {
                this.collectionName_ = other.collectionName_;
                this.onChanged();
            }
            if (!other.partitionNames_.isEmpty()) {
                if (this.partitionNames_.isEmpty()) {
                    this.partitionNames_ = other.partitionNames_;
                    this.bitField0_ &= 0xFFFFFFFE;
                } else {
                    this.ensurePartitionNamesIsMutable();
                    this.partitionNames_.addAll((Collection)other.partitionNames_);
                }
                this.onChanged();
            }
            if (!other.getDsl().isEmpty()) {
                this.dsl_ = other.dsl_;
                this.onChanged();
            }
            if (other.getPlaceholderGroup() != ByteString.EMPTY) {
                this.setPlaceholderGroup(other.getPlaceholderGroup());
            }
            if (other.dslType_ != 0) {
                this.setDslTypeValue(other.getDslTypeValue());
            }
            if (!other.outputFields_.isEmpty()) {
                if (this.outputFields_.isEmpty()) {
                    this.outputFields_ = other.outputFields_;
                    this.bitField0_ &= 0xFFFFFFFD;
                } else {
                    this.ensureOutputFieldsIsMutable();
                    this.outputFields_.addAll((Collection)other.outputFields_);
                }
                this.onChanged();
            }
            if (this.searchParamsBuilder_ == null) {
                if (!other.searchParams_.isEmpty()) {
                    if (this.searchParams_.isEmpty()) {
                        this.searchParams_ = other.searchParams_;
                        this.bitField0_ &= 0xFFFFFFFB;
                    } else {
                        this.ensureSearchParamsIsMutable();
                        this.searchParams_.addAll(other.searchParams_);
                    }
                    this.onChanged();
                }
            } else if (!other.searchParams_.isEmpty()) {
                if (this.searchParamsBuilder_.isEmpty()) {
                    this.searchParamsBuilder_.dispose();
                    this.searchParamsBuilder_ = null;
                    this.searchParams_ = other.searchParams_;
                    this.bitField0_ &= 0xFFFFFFFB;
                    this.searchParamsBuilder_ = alwaysUseFieldBuilders ? this.getSearchParamsFieldBuilder() : null;
                } else {
                    this.searchParamsBuilder_.addAllMessages((Iterable)other.searchParams_);
                }
            }
            if (other.getTravelTimestamp() != 0L) {
                this.setTravelTimestamp(other.getTravelTimestamp());
            }
            if (other.getGuaranteeTimestamp() != 0L) {
                this.setGuaranteeTimestamp(other.getGuaranteeTimestamp());
            }
            if (other.getNq() != 0L) {
                this.setNq(other.getNq());
            }
            if (other.getNotReturnAllMeta()) {
                this.setNotReturnAllMeta(other.getNotReturnAllMeta());
            }
            if (other.consistencyLevel_ != 0) {
                this.setConsistencyLevelValue(other.getConsistencyLevelValue());
            }
            if (other.getUseDefaultConsistency()) {
                this.setUseDefaultConsistency(other.getUseDefaultConsistency());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block23: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block23;
                        }
                        case 10: {
                            input.readMessage((MessageLite.Builder)this.getBaseFieldBuilder().getBuilder(), extensionRegistry);
                            continue block23;
                        }
                        case 18: {
                            this.dbName_ = input.readStringRequireUtf8();
                            continue block23;
                        }
                        case 26: {
                            this.collectionName_ = input.readStringRequireUtf8();
                            continue block23;
                        }
                        case 34: {
                            String s = input.readStringRequireUtf8();
                            this.ensurePartitionNamesIsMutable();
                            this.partitionNames_.add((Object)s);
                            continue block23;
                        }
                        case 42: {
                            this.dsl_ = input.readStringRequireUtf8();
                            continue block23;
                        }
                        case 50: {
                            this.placeholderGroup_ = input.readBytes();
                            continue block23;
                        }
                        case 56: {
                            this.dslType_ = input.readEnum();
                            continue block23;
                        }
                        case 66: {
                            String s = input.readStringRequireUtf8();
                            this.ensureOutputFieldsIsMutable();
                            this.outputFields_.add((Object)s);
                            continue block23;
                        }
                        case 74: {
                            KeyValuePair m = (KeyValuePair)input.readMessage(KeyValuePair.parser(), extensionRegistry);
                            if (this.searchParamsBuilder_ == null) {
                                this.ensureSearchParamsIsMutable();
                                this.searchParams_.add(m);
                                continue block23;
                            }
                            this.searchParamsBuilder_.addMessage((AbstractMessage)m);
                            continue block23;
                        }
                        case 80: {
                            this.travelTimestamp_ = input.readUInt64();
                            continue block23;
                        }
                        case 88: {
                            this.guaranteeTimestamp_ = input.readUInt64();
                            continue block23;
                        }
                        case 96: {
                            this.nq_ = input.readInt64();
                            continue block23;
                        }
                        case 104: {
                            this.notReturnAllMeta_ = input.readBool();
                            continue block23;
                        }
                        case 112: {
                            this.consistencyLevel_ = input.readEnum();
                            continue block23;
                        }
                        case 120: {
                            this.useDefaultConsistency_ = input.readBool();
                            continue block23;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public boolean hasBase() {
            return this.baseBuilder_ != null || this.base_ != null;
        }

        @Override
        public MsgBase getBase() {
            if (this.baseBuilder_ == null) {
                return this.base_ == null ? MsgBase.getDefaultInstance() : this.base_;
            }
            return (MsgBase)this.baseBuilder_.getMessage();
        }

        public Builder setBase(MsgBase value) {
            if (this.baseBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.base_ = value;
                this.onChanged();
            } else {
                this.baseBuilder_.setMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder setBase(MsgBase.Builder builderForValue) {
            if (this.baseBuilder_ == null) {
                this.base_ = builderForValue.build();
                this.onChanged();
            } else {
                this.baseBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder mergeBase(MsgBase value) {
            if (this.baseBuilder_ == null) {
                this.base_ = this.base_ != null ? MsgBase.newBuilder(this.base_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else {
                this.baseBuilder_.mergeFrom((AbstractMessage)value);
            }
            return this;
        }

        public Builder clearBase() {
            if (this.baseBuilder_ == null) {
                this.base_ = null;
                this.onChanged();
            } else {
                this.base_ = null;
                this.baseBuilder_ = null;
            }
            return this;
        }

        public MsgBase.Builder getBaseBuilder() {
            this.onChanged();
            return (MsgBase.Builder)this.getBaseFieldBuilder().getBuilder();
        }

        @Override
        public MsgBaseOrBuilder getBaseOrBuilder() {
            if (this.baseBuilder_ != null) {
                return (MsgBaseOrBuilder)this.baseBuilder_.getMessageOrBuilder();
            }
            return this.base_ == null ? MsgBase.getDefaultInstance() : this.base_;
        }

        private SingleFieldBuilderV3<MsgBase, MsgBase.Builder, MsgBaseOrBuilder> getBaseFieldBuilder() {
            if (this.baseBuilder_ == null) {
                this.baseBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getBase(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.base_ = null;
            }
            return this.baseBuilder_;
        }

        @Override
        public String getDbName() {
            Object ref = this.dbName_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.dbName_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getDbNameBytes() {
            Object ref = this.dbName_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.dbName_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setDbName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.dbName_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearDbName() {
            this.dbName_ = SearchRequest.getDefaultInstance().getDbName();
            this.onChanged();
            return this;
        }

        public Builder setDbNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            SearchRequest.checkByteStringIsUtf8((ByteString)value);
            this.dbName_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public String getCollectionName() {
            Object ref = this.collectionName_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.collectionName_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getCollectionNameBytes() {
            Object ref = this.collectionName_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.collectionName_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setCollectionName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.collectionName_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearCollectionName() {
            this.collectionName_ = SearchRequest.getDefaultInstance().getCollectionName();
            this.onChanged();
            return this;
        }

        public Builder setCollectionNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            SearchRequest.checkByteStringIsUtf8((ByteString)value);
            this.collectionName_ = value;
            this.onChanged();
            return this;
        }

        private void ensurePartitionNamesIsMutable() {
            if ((this.bitField0_ & 1) == 0) {
                this.partitionNames_ = new LazyStringArrayList(this.partitionNames_);
                this.bitField0_ |= 1;
            }
        }

        public ProtocolStringList getPartitionNamesList() {
            return this.partitionNames_.getUnmodifiableView();
        }

        @Override
        public int getPartitionNamesCount() {
            return this.partitionNames_.size();
        }

        @Override
        public String getPartitionNames(int index) {
            return (String)this.partitionNames_.get(index);
        }

        @Override
        public ByteString getPartitionNamesBytes(int index) {
            return this.partitionNames_.getByteString(index);
        }

        public Builder setPartitionNames(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensurePartitionNamesIsMutable();
            this.partitionNames_.set(index, (Object)value);
            this.onChanged();
            return this;
        }

        public Builder addPartitionNames(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensurePartitionNamesIsMutable();
            this.partitionNames_.add((Object)value);
            this.onChanged();
            return this;
        }

        public Builder addAllPartitionNames(Iterable<String> values) {
            this.ensurePartitionNamesIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.partitionNames_);
            this.onChanged();
            return this;
        }

        public Builder clearPartitionNames() {
            this.partitionNames_ = LazyStringArrayList.EMPTY;
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder addPartitionNamesBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            SearchRequest.checkByteStringIsUtf8((ByteString)value);
            this.ensurePartitionNamesIsMutable();
            this.partitionNames_.add(value);
            this.onChanged();
            return this;
        }

        @Override
        public String getDsl() {
            Object ref = this.dsl_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.dsl_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getDslBytes() {
            Object ref = this.dsl_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.dsl_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setDsl(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.dsl_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearDsl() {
            this.dsl_ = SearchRequest.getDefaultInstance().getDsl();
            this.onChanged();
            return this;
        }

        public Builder setDslBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            SearchRequest.checkByteStringIsUtf8((ByteString)value);
            this.dsl_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public ByteString getPlaceholderGroup() {
            return this.placeholderGroup_;
        }

        public Builder setPlaceholderGroup(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.placeholderGroup_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearPlaceholderGroup() {
            this.placeholderGroup_ = SearchRequest.getDefaultInstance().getPlaceholderGroup();
            this.onChanged();
            return this;
        }

        @Override
        public int getDslTypeValue() {
            return this.dslType_;
        }

        public Builder setDslTypeValue(int value) {
            this.dslType_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public DslType getDslType() {
            DslType result = DslType.valueOf(this.dslType_);
            return result == null ? DslType.UNRECOGNIZED : result;
        }

        public Builder setDslType(DslType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.dslType_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearDslType() {
            this.dslType_ = 0;
            this.onChanged();
            return this;
        }

        private void ensureOutputFieldsIsMutable() {
            if ((this.bitField0_ & 2) == 0) {
                this.outputFields_ = new LazyStringArrayList(this.outputFields_);
                this.bitField0_ |= 2;
            }
        }

        public ProtocolStringList getOutputFieldsList() {
            return this.outputFields_.getUnmodifiableView();
        }

        @Override
        public int getOutputFieldsCount() {
            return this.outputFields_.size();
        }

        @Override
        public String getOutputFields(int index) {
            return (String)this.outputFields_.get(index);
        }

        @Override
        public ByteString getOutputFieldsBytes(int index) {
            return this.outputFields_.getByteString(index);
        }

        public Builder setOutputFields(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureOutputFieldsIsMutable();
            this.outputFields_.set(index, (Object)value);
            this.onChanged();
            return this;
        }

        public Builder addOutputFields(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureOutputFieldsIsMutable();
            this.outputFields_.add((Object)value);
            this.onChanged();
            return this;
        }

        public Builder addAllOutputFields(Iterable<String> values) {
            this.ensureOutputFieldsIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.outputFields_);
            this.onChanged();
            return this;
        }

        public Builder clearOutputFields() {
            this.outputFields_ = LazyStringArrayList.EMPTY;
            this.bitField0_ &= 0xFFFFFFFD;
            this.onChanged();
            return this;
        }

        public Builder addOutputFieldsBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            SearchRequest.checkByteStringIsUtf8((ByteString)value);
            this.ensureOutputFieldsIsMutable();
            this.outputFields_.add(value);
            this.onChanged();
            return this;
        }

        private void ensureSearchParamsIsMutable() {
            if ((this.bitField0_ & 4) == 0) {
                this.searchParams_ = new ArrayList<KeyValuePair>(this.searchParams_);
                this.bitField0_ |= 4;
            }
        }

        @Override
        public List<KeyValuePair> getSearchParamsList() {
            if (this.searchParamsBuilder_ == null) {
                return Collections.unmodifiableList(this.searchParams_);
            }
            return this.searchParamsBuilder_.getMessageList();
        }

        @Override
        public int getSearchParamsCount() {
            if (this.searchParamsBuilder_ == null) {
                return this.searchParams_.size();
            }
            return this.searchParamsBuilder_.getCount();
        }

        @Override
        public KeyValuePair getSearchParams(int index) {
            if (this.searchParamsBuilder_ == null) {
                return this.searchParams_.get(index);
            }
            return (KeyValuePair)this.searchParamsBuilder_.getMessage(index);
        }

        public Builder setSearchParams(int index, KeyValuePair value) {
            if (this.searchParamsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureSearchParamsIsMutable();
                this.searchParams_.set(index, value);
                this.onChanged();
            } else {
                this.searchParamsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setSearchParams(int index, KeyValuePair.Builder builderForValue) {
            if (this.searchParamsBuilder_ == null) {
                this.ensureSearchParamsIsMutable();
                this.searchParams_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.searchParamsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addSearchParams(KeyValuePair value) {
            if (this.searchParamsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureSearchParamsIsMutable();
                this.searchParams_.add(value);
                this.onChanged();
            } else {
                this.searchParamsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addSearchParams(int index, KeyValuePair value) {
            if (this.searchParamsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureSearchParamsIsMutable();
                this.searchParams_.add(index, value);
                this.onChanged();
            } else {
                this.searchParamsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addSearchParams(KeyValuePair.Builder builderForValue) {
            if (this.searchParamsBuilder_ == null) {
                this.ensureSearchParamsIsMutable();
                this.searchParams_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.searchParamsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addSearchParams(int index, KeyValuePair.Builder builderForValue) {
            if (this.searchParamsBuilder_ == null) {
                this.ensureSearchParamsIsMutable();
                this.searchParams_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.searchParamsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllSearchParams(Iterable<? extends KeyValuePair> values) {
            if (this.searchParamsBuilder_ == null) {
                this.ensureSearchParamsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.searchParams_);
                this.onChanged();
            } else {
                this.searchParamsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearSearchParams() {
            if (this.searchParamsBuilder_ == null) {
                this.searchParams_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFB;
                this.onChanged();
            } else {
                this.searchParamsBuilder_.clear();
            }
            return this;
        }

        public Builder removeSearchParams(int index) {
            if (this.searchParamsBuilder_ == null) {
                this.ensureSearchParamsIsMutable();
                this.searchParams_.remove(index);
                this.onChanged();
            } else {
                this.searchParamsBuilder_.remove(index);
            }
            return this;
        }

        public KeyValuePair.Builder getSearchParamsBuilder(int index) {
            return (KeyValuePair.Builder)this.getSearchParamsFieldBuilder().getBuilder(index);
        }

        @Override
        public KeyValuePairOrBuilder getSearchParamsOrBuilder(int index) {
            if (this.searchParamsBuilder_ == null) {
                return this.searchParams_.get(index);
            }
            return (KeyValuePairOrBuilder)this.searchParamsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends KeyValuePairOrBuilder> getSearchParamsOrBuilderList() {
            if (this.searchParamsBuilder_ != null) {
                return this.searchParamsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.searchParams_);
        }

        public KeyValuePair.Builder addSearchParamsBuilder() {
            return (KeyValuePair.Builder)this.getSearchParamsFieldBuilder().addBuilder((AbstractMessage)KeyValuePair.getDefaultInstance());
        }

        public KeyValuePair.Builder addSearchParamsBuilder(int index) {
            return (KeyValuePair.Builder)this.getSearchParamsFieldBuilder().addBuilder(index, (AbstractMessage)KeyValuePair.getDefaultInstance());
        }

        public List<KeyValuePair.Builder> getSearchParamsBuilderList() {
            return this.getSearchParamsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<KeyValuePair, KeyValuePair.Builder, KeyValuePairOrBuilder> getSearchParamsFieldBuilder() {
            if (this.searchParamsBuilder_ == null) {
                this.searchParamsBuilder_ = new RepeatedFieldBuilderV3(this.searchParams_, (this.bitField0_ & 4) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.searchParams_ = null;
            }
            return this.searchParamsBuilder_;
        }

        @Override
        public long getTravelTimestamp() {
            return this.travelTimestamp_;
        }

        public Builder setTravelTimestamp(long value) {
            this.travelTimestamp_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearTravelTimestamp() {
            this.travelTimestamp_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public long getGuaranteeTimestamp() {
            return this.guaranteeTimestamp_;
        }

        public Builder setGuaranteeTimestamp(long value) {
            this.guaranteeTimestamp_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearGuaranteeTimestamp() {
            this.guaranteeTimestamp_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public long getNq() {
            return this.nq_;
        }

        public Builder setNq(long value) {
            this.nq_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearNq() {
            this.nq_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public boolean getNotReturnAllMeta() {
            return this.notReturnAllMeta_;
        }

        public Builder setNotReturnAllMeta(boolean value) {
            this.notReturnAllMeta_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearNotReturnAllMeta() {
            this.notReturnAllMeta_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public int getConsistencyLevelValue() {
            return this.consistencyLevel_;
        }

        public Builder setConsistencyLevelValue(int value) {
            this.consistencyLevel_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public ConsistencyLevel getConsistencyLevel() {
            ConsistencyLevel result = ConsistencyLevel.valueOf(this.consistencyLevel_);
            return result == null ? ConsistencyLevel.UNRECOGNIZED : result;
        }

        public Builder setConsistencyLevel(ConsistencyLevel value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.consistencyLevel_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearConsistencyLevel() {
            this.consistencyLevel_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean getUseDefaultConsistency() {
            return this.useDefaultConsistency_;
        }

        public Builder setUseDefaultConsistency(boolean value) {
            this.useDefaultConsistency_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearUseDefaultConsistency() {
            this.useDefaultConsistency_ = false;
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }
}

