/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param;

import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;
import io.milvus.utils.URLParser;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class ConnectParam {
    private final String host;
    private final int port;
    private final String databaseName;
    private final String uri;
    private final String token;
    private final long connectTimeoutMs;
    private final long keepAliveTimeMs;
    private final long keepAliveTimeoutMs;
    private final boolean keepAliveWithoutCalls;
    private final long rpcDeadlineMs;
    private final boolean secure;
    private final long idleTimeoutMs;
    private final String authorization;
    private final String clientKeyPath;
    private final String clientPemPath;
    private final String caPemPath;
    private final String serverPemPath;
    private final String serverName;

    protected ConnectParam(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.host = builder.host;
        this.port = builder.port;
        this.token = builder.token;
        this.databaseName = builder.databaseName;
        this.uri = builder.uri;
        this.connectTimeoutMs = builder.connectTimeoutMs;
        this.keepAliveTimeMs = builder.keepAliveTimeMs;
        this.keepAliveTimeoutMs = builder.keepAliveTimeoutMs;
        this.keepAliveWithoutCalls = builder.keepAliveWithoutCalls;
        this.idleTimeoutMs = builder.idleTimeoutMs;
        this.rpcDeadlineMs = builder.rpcDeadlineMs;
        this.secure = builder.secure;
        this.authorization = builder.authorization;
        this.clientKeyPath = builder.clientKeyPath;
        this.clientPemPath = builder.clientPemPath;
        this.caPemPath = builder.caPemPath;
        this.serverPemPath = builder.serverPemPath;
        this.serverName = builder.serverName;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getUri() {
        return this.uri;
    }

    public String getToken() {
        return this.token;
    }

    public long getConnectTimeoutMs() {
        return this.connectTimeoutMs;
    }

    public long getKeepAliveTimeMs() {
        return this.keepAliveTimeMs;
    }

    public long getKeepAliveTimeoutMs() {
        return this.keepAliveTimeoutMs;
    }

    public boolean isKeepAliveWithoutCalls() {
        return this.keepAliveWithoutCalls;
    }

    public long getRpcDeadlineMs() {
        return this.rpcDeadlineMs;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public long getIdleTimeoutMs() {
        return this.idleTimeoutMs;
    }

    public String getAuthorization() {
        return this.authorization;
    }

    public String getClientKeyPath() {
        return this.clientKeyPath;
    }

    public String getClientPemPath() {
        return this.clientPemPath;
    }

    public String getCaPemPath() {
        return this.caPemPath;
    }

    public String getServerPemPath() {
        return this.serverPemPath;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String toString() {
        return "ConnectParam(host=" + this.getHost() + ", port=" + this.getPort() + ", databaseName=" + this.getDatabaseName() + ", uri=" + this.getUri() + ", token=" + this.getToken() + ", connectTimeoutMs=" + this.getConnectTimeoutMs() + ", keepAliveTimeMs=" + this.getKeepAliveTimeMs() + ", keepAliveTimeoutMs=" + this.getKeepAliveTimeoutMs() + ", keepAliveWithoutCalls=" + this.isKeepAliveWithoutCalls() + ", rpcDeadlineMs=" + this.getRpcDeadlineMs() + ", secure=" + this.isSecure() + ", idleTimeoutMs=" + this.getIdleTimeoutMs() + ", authorization=" + this.getAuthorization() + ", clientKeyPath=" + this.getClientKeyPath() + ", clientPemPath=" + this.getClientPemPath() + ", caPemPath=" + this.getCaPemPath() + ", serverPemPath=" + this.getServerPemPath() + ", serverName=" + this.getServerName() + ")";
    }

    public static class Builder {
        private String host = "localhost";
        private int port = 19530;
        private String databaseName = "default";
        private String uri;
        private String token;
        private long connectTimeoutMs = 10000L;
        private long keepAliveTimeMs = Long.MAX_VALUE;
        private long keepAliveTimeoutMs = 20000L;
        private boolean keepAliveWithoutCalls = false;
        private long rpcDeadlineMs = 0L;
        private String clientKeyPath;
        private String clientPemPath;
        private String caPemPath;
        private String serverPemPath;
        private String serverName;
        protected boolean secure = false;
        private long idleTimeoutMs = TimeUnit.MILLISECONDS.convert(24L, TimeUnit.HOURS);
        private String authorization = Base64.getEncoder().encodeToString("root:milvus".getBytes(StandardCharsets.UTF_8));

        protected Builder() {
        }

        public Builder withHost(@NonNull String host) {
            if (host == null) {
                throw new NullPointerException("host is marked non-null but is null");
            }
            this.host = host;
            return this;
        }

        public Builder withPort(int port) {
            this.port = port;
            return this;
        }

        public Builder withDatabaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public Builder withUri(String uri) {
            this.uri = uri;
            return this;
        }

        public Builder withToken(String token) {
            this.token = token;
            return this;
        }

        public Builder withConnectTimeout(long connectTimeout, @NonNull TimeUnit timeUnit) {
            if (timeUnit == null) {
                throw new NullPointerException("timeUnit is marked non-null but is null");
            }
            this.connectTimeoutMs = timeUnit.toMillis(connectTimeout);
            return this;
        }

        public Builder withKeepAliveTime(long keepAliveTime, @NonNull TimeUnit timeUnit) {
            if (timeUnit == null) {
                throw new NullPointerException("timeUnit is marked non-null but is null");
            }
            this.keepAliveTimeMs = timeUnit.toMillis(keepAliveTime);
            return this;
        }

        public Builder withKeepAliveTimeout(long keepAliveTimeout, @NonNull TimeUnit timeUnit) {
            if (timeUnit == null) {
                throw new NullPointerException("timeUnit is marked non-null but is null");
            }
            this.keepAliveTimeoutMs = timeUnit.toMillis(keepAliveTimeout);
            return this;
        }

        public Builder keepAliveWithoutCalls(boolean enable) {
            this.keepAliveWithoutCalls = enable;
            return this;
        }

        @Deprecated
        public Builder secure(boolean enable) {
            this.secure = enable;
            return this;
        }

        public Builder withIdleTimeout(long idleTimeout, @NonNull TimeUnit timeUnit) {
            if (timeUnit == null) {
                throw new NullPointerException("timeUnit is marked non-null but is null");
            }
            this.idleTimeoutMs = timeUnit.toMillis(idleTimeout);
            return this;
        }

        public Builder withRpcDeadline(long deadline, @NonNull TimeUnit timeUnit) {
            if (timeUnit == null) {
                throw new NullPointerException("timeUnit is marked non-null but is null");
            }
            this.rpcDeadlineMs = timeUnit.toMillis(deadline);
            return this;
        }

        public Builder withAuthorization(String username, String password) {
            this.authorization = Base64.getEncoder().encodeToString(String.format("%s:%s", username, password).getBytes(StandardCharsets.UTF_8));
            return this;
        }

        public Builder withSecure(boolean secure) {
            this.secure = secure;
            return this;
        }

        public Builder withAuthorization(@NonNull String authorization) {
            if (authorization == null) {
                throw new NullPointerException("authorization is marked non-null but is null");
            }
            this.authorization = authorization;
            return this;
        }

        public Builder withClientKeyPath(@NonNull String clientKeyPath) {
            if (clientKeyPath == null) {
                throw new NullPointerException("clientKeyPath is marked non-null but is null");
            }
            this.clientKeyPath = clientKeyPath;
            return this;
        }

        public Builder withClientPemPath(@NonNull String clientPemPath) {
            if (clientPemPath == null) {
                throw new NullPointerException("clientPemPath is marked non-null but is null");
            }
            this.clientPemPath = clientPemPath;
            return this;
        }

        public Builder withCaPemPath(@NonNull String caPemPath) {
            if (caPemPath == null) {
                throw new NullPointerException("caPemPath is marked non-null but is null");
            }
            this.caPemPath = caPemPath;
            return this;
        }

        public Builder withServerPemPath(@NonNull String serverPemPath) {
            if (serverPemPath == null) {
                throw new NullPointerException("serverPemPath is marked non-null but is null");
            }
            this.serverPemPath = serverPemPath;
            return this;
        }

        public Builder withServerName(@NonNull String serverName) {
            if (serverName == null) {
                throw new NullPointerException("serverName is marked non-null but is null");
            }
            this.serverName = serverName;
            return this;
        }

        public ConnectParam build() throws ParamException {
            this.verify();
            return new ConnectParam(this);
        }

        protected void verify() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.host, "Host name");
            if (StringUtils.isNotEmpty((CharSequence)this.uri)) {
                URLParser result = new URLParser(this.uri);
                this.secure = result.isSecure();
                this.host = result.getHostname();
                this.port = result.getPort();
                this.databaseName = result.getDatabase();
            }
            if (StringUtils.isNotEmpty((CharSequence)this.token)) {
                this.authorization = Base64.getEncoder().encodeToString(String.format("%s", this.token).getBytes(StandardCharsets.UTF_8));
                if (!this.token.contains(":")) {
                    this.port = 443;
                }
                this.secure = true;
            }
            if (this.port < 0 || this.port > 65535) {
                throw new ParamException("Port is out of range!");
            }
            if (this.keepAliveTimeMs <= 0L) {
                throw new ParamException("Keep alive time must be positive!");
            }
            if (this.connectTimeoutMs <= 0L) {
                throw new ParamException("Connect timeout must be positive!");
            }
            if (this.keepAliveTimeoutMs <= 0L) {
                throw new ParamException("Keep alive timeout must be positive!");
            }
            if (this.idleTimeoutMs <= 0L) {
                throw new ParamException("Idle timeout must be positive!");
            }
            if (StringUtils.isNotEmpty((CharSequence)this.serverPemPath) || StringUtils.isNotEmpty((CharSequence)this.caPemPath) || StringUtils.isNotEmpty((CharSequence)this.clientPemPath) || StringUtils.isNotEmpty((CharSequence)this.clientKeyPath)) {
                this.secure = true;
            }
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public String getDatabaseName() {
            return this.databaseName;
        }

        public String getUri() {
            return this.uri;
        }

        public String getToken() {
            return this.token;
        }

        public long getConnectTimeoutMs() {
            return this.connectTimeoutMs;
        }

        public long getKeepAliveTimeMs() {
            return this.keepAliveTimeMs;
        }

        public long getKeepAliveTimeoutMs() {
            return this.keepAliveTimeoutMs;
        }

        public boolean isKeepAliveWithoutCalls() {
            return this.keepAliveWithoutCalls;
        }

        public long getRpcDeadlineMs() {
            return this.rpcDeadlineMs;
        }

        public String getClientKeyPath() {
            return this.clientKeyPath;
        }

        public String getClientPemPath() {
            return this.clientPemPath;
        }

        public String getCaPemPath() {
            return this.caPemPath;
        }

        public String getServerPemPath() {
            return this.serverPemPath;
        }

        public String getServerName() {
            return this.serverName;
        }

        public boolean isSecure() {
            return this.secure;
        }

        public long getIdleTimeoutMs() {
            return this.idleTimeoutMs;
        }

        public String getAuthorization() {
            return this.authorization;
        }
    }
}

