/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.collection;

import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;
import io.milvus.param.collection.FieldType;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;

public class CreateCollectionParam {
    private final String collectionName;
    private final int shardsNum;
    private final String description;
    private final List<FieldType> fieldTypes;

    private CreateCollectionParam(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.collectionName = builder.collectionName;
        this.shardsNum = builder.shardsNum;
        this.description = builder.description;
        this.fieldTypes = builder.fieldTypes;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return "CreateCollectionParam{collectionName='" + this.collectionName + '\'' + ", shardsNum=" + this.shardsNum + ", description='" + this.description + '\'' + ", fields=" + this.fieldTypes.toString() + '}';
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public int getShardsNum() {
        return this.shardsNum;
    }

    public String getDescription() {
        return this.description;
    }

    public List<FieldType> getFieldTypes() {
        return this.fieldTypes;
    }

    public static final class Builder {
        private String collectionName;
        private int shardsNum = 2;
        private String description = "";
        private final List<FieldType> fieldTypes = new ArrayList<FieldType>();

        private Builder() {
        }

        public Builder withCollectionName(@NonNull String collectionName) {
            if (collectionName == null) {
                throw new NullPointerException("collectionName is marked non-null but is null");
            }
            this.collectionName = collectionName;
            return this;
        }

        public Builder withShardsNum(int shardsNum) {
            this.shardsNum = shardsNum;
            return this;
        }

        public Builder withDescription(@NonNull String description) {
            if (description == null) {
                throw new NullPointerException("description is marked non-null but is null");
            }
            this.description = description;
            return this;
        }

        public Builder withFieldTypes(@NonNull List<FieldType> fieldTypes) {
            if (fieldTypes == null) {
                throw new NullPointerException("fieldTypes is marked non-null but is null");
            }
            this.fieldTypes.addAll(fieldTypes);
            return this;
        }

        public Builder addFieldType(@NonNull FieldType fieldType) {
            if (fieldType == null) {
                throw new NullPointerException("fieldType is marked non-null but is null");
            }
            this.fieldTypes.add(fieldType);
            return this;
        }

        public CreateCollectionParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.collectionName, "Collection name");
            if (this.shardsNum <= 0) {
                throw new ParamException("ShardNum must be larger than 0");
            }
            if (this.fieldTypes.isEmpty()) {
                throw new ParamException("Field numbers must be larger than 0");
            }
            for (FieldType fieldType : this.fieldTypes) {
                if (fieldType != null) continue;
                throw new ParamException("Collection field cannot be null");
            }
            return new CreateCollectionParam(this);
        }
    }
}

