/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.highlevel.collection;

import com.google.common.collect.Lists;
import io.milvus.common.clientenum.ConsistencyLevelEnum;
import io.milvus.exception.ParamException;
import io.milvus.grpc.DataType;
import io.milvus.param.IndexType;
import io.milvus.param.MetricType;
import io.milvus.param.ParamUtils;
import io.milvus.param.collection.CreateCollectionParam;
import io.milvus.param.collection.FieldType;
import io.milvus.param.collection.LoadCollectionParam;
import io.milvus.param.index.CreateIndexParam;
import java.util.ArrayList;
import java.util.HashMap;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class CreateSimpleCollectionParam {
    private final CreateCollectionParam createCollectionParam;
    private final CreateIndexParam createIndexParam;
    private final LoadCollectionParam loadCollectionParam;

    private CreateSimpleCollectionParam(CreateCollectionParam createCollectionParam, CreateIndexParam createIndexParam, LoadCollectionParam loadCollectionParam) {
        this.createCollectionParam = createCollectionParam;
        this.createIndexParam = createIndexParam;
        this.loadCollectionParam = loadCollectionParam;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public CreateCollectionParam getCreateCollectionParam() {
        return this.createCollectionParam;
    }

    public CreateIndexParam getCreateIndexParam() {
        return this.createIndexParam;
    }

    public LoadCollectionParam getLoadCollectionParam() {
        return this.loadCollectionParam;
    }

    public String toString() {
        return "CreateSimpleCollectionParam(createCollectionParam=" + this.getCreateCollectionParam() + ", createIndexParam=" + this.getCreateIndexParam() + ", loadCollectionParam=" + this.getLoadCollectionParam() + ")";
    }

    public static final class Builder {
        private String collectionName;
        private int dimension;
        private MetricType metricType = MetricType.L2;
        private String description = "";
        private String primaryField;
        private String vectorField;
        private boolean autoId = Boolean.FALSE;
        private boolean syncLoad = Boolean.TRUE;

        private Builder() {
        }

        public Builder withCollectionName(@NonNull String collectionName) {
            if (collectionName == null) {
                throw new NullPointerException("collectionName is marked non-null but is null");
            }
            this.collectionName = collectionName;
            return this;
        }

        public Builder withDimension(int dimension) {
            this.dimension = dimension;
            return this;
        }

        public Builder withMetricType(@NonNull MetricType metricType) {
            if (metricType == null) {
                throw new NullPointerException("metricType is marked non-null but is null");
            }
            this.metricType = metricType;
            return this;
        }

        public Builder withDescription(@NonNull String description) {
            if (description == null) {
                throw new NullPointerException("description is marked non-null but is null");
            }
            this.description = description;
            return this;
        }

        public Builder withPrimaryField(@NonNull String primaryField) {
            if (primaryField == null) {
                throw new NullPointerException("primaryField is marked non-null but is null");
            }
            this.primaryField = primaryField;
            return this;
        }

        public Builder withVectorField(@NonNull String vectorField) {
            if (vectorField == null) {
                throw new NullPointerException("vectorField is marked non-null but is null");
            }
            this.vectorField = vectorField;
            return this;
        }

        public Builder withAutoId(boolean autoId) {
            this.autoId = autoId;
            return this;
        }

        public Builder withSyncLoad(boolean syncLoad) {
            this.syncLoad = syncLoad;
            return this;
        }

        public CreateSimpleCollectionParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.collectionName, "Collection name");
            if (this.dimension <= 0) {
                throw new ParamException("Dimension must be larger than 0");
            }
            String primaryFieldName = (String)StringUtils.defaultIfEmpty((CharSequence)this.primaryField, (CharSequence)"id");
            String vectorFieldName = StringUtils.defaultString((String)this.vectorField, (String)"vector");
            HashMap<String, String> typeParams = new HashMap<String, String>();
            typeParams.put("dim", String.valueOf(this.dimension));
            ArrayList fieldTypes = Lists.newArrayList((Object[])new FieldType[]{FieldType.newBuilder().withName(primaryFieldName).withDataType(DataType.Int64).withPrimaryKey(Boolean.TRUE).withAutoID(this.autoId).build(), FieldType.newBuilder().withName(vectorFieldName).withDataType(DataType.FloatVector).withTypeParams(typeParams).build()});
            CreateCollectionParam createCollectionParam = CreateCollectionParam.newBuilder().withCollectionName(this.collectionName).withShardsNum(2).withDescription(this.description).withFieldTypes(fieldTypes).withConsistencyLevel(ConsistencyLevelEnum.BOUNDED).withEnableDynamicField(Boolean.TRUE).build();
            CreateIndexParam createIndexParam = CreateIndexParam.newBuilder().withCollectionName(this.collectionName).withFieldName(vectorFieldName).withIndexName("vector_idx").withMetricType(this.metricType).withIndexType(IndexType.AUTOINDEX).build();
            LoadCollectionParam loadCollectionParam = LoadCollectionParam.newBuilder().withCollectionName(this.collectionName).withSyncLoad(this.syncLoad).build();
            return new CreateSimpleCollectionParam(createCollectionParam, createIndexParam, loadCollectionParam);
        }
    }
}

