/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.highlevel.dml;

import com.google.common.collect.Lists;
import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;

public class GetIdsParam {
    private final String collectionName;
    private final List<?> primaryIds;
    private final List<String> outputFields;

    private GetIdsParam(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.collectionName = builder.collectionName;
        this.primaryIds = builder.primaryIds;
        this.outputFields = builder.outputFields;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public List<?> getPrimaryIds() {
        return this.primaryIds;
    }

    public List<String> getOutputFields() {
        return this.outputFields;
    }

    public String toString() {
        return "GetIdsParam(collectionName=" + this.getCollectionName() + ", primaryIds=" + this.getPrimaryIds() + ", outputFields=" + this.getOutputFields() + ")";
    }

    public static class Builder<T> {
        private String collectionName;
        private List<T> primaryIds = new ArrayList<T>();
        private final List<String> outputFields = Lists.newArrayList();

        private Builder() {
        }

        public Builder withCollectionName(@NonNull String collectionName) {
            if (collectionName == null) {
                throw new NullPointerException("collectionName is marked non-null but is null");
            }
            this.collectionName = collectionName;
            return this;
        }

        public Builder withOutputFields(@NonNull List<String> outputFields) {
            if (outputFields == null) {
                throw new NullPointerException("outputFields is marked non-null but is null");
            }
            this.outputFields.addAll(outputFields);
            return this;
        }

        public Builder withPrimaryIds(@NonNull List<T> primaryIds) {
            if (primaryIds == null) {
                throw new NullPointerException("primaryIds is marked non-null but is null");
            }
            this.primaryIds.addAll(primaryIds);
            return this;
        }

        public Builder addPrimaryId(@NonNull T primaryId) {
            if (primaryId == null) {
                throw new NullPointerException("primaryId is marked non-null but is null");
            }
            this.primaryIds.add(primaryId);
            return this;
        }

        public GetIdsParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.collectionName, "Collection name");
            if (CollectionUtils.isEmpty(this.primaryIds)) {
                throw new ParamException("PrimaryIds cannot be empty");
            }
            return new GetIdsParam(this);
        }
    }
}

