/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.highlevel.dml;

import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import org.jetbrains.annotations.NotNull;

public class QuerySimpleParam {
    private final String collectionName;
    private final List<String> outputFields;
    private final String filter;
    private final Long offset;
    private final Long limit;

    private QuerySimpleParam(@NotNull Builder builder) {
        this.collectionName = builder.collectionName;
        this.outputFields = builder.outputFields;
        this.filter = builder.filter;
        this.offset = builder.offset;
        this.limit = builder.limit;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public List<String> getOutputFields() {
        return this.outputFields;
    }

    public String getFilter() {
        return this.filter;
    }

    public Long getOffset() {
        return this.offset;
    }

    public Long getLimit() {
        return this.limit;
    }

    public String toString() {
        return "QuerySimpleParam(collectionName=" + this.getCollectionName() + ", outputFields=" + this.getOutputFields() + ", filter=" + this.getFilter() + ", offset=" + this.getOffset() + ", limit=" + this.getLimit() + ")";
    }

    public static class Builder {
        private String collectionName;
        private final List<String> outputFields = new ArrayList<String>();
        private String filter = "";
        private Long offset;
        private Long limit;

        private Builder() {
        }

        public Builder withCollectionName(@NonNull String collectionName) {
            if (collectionName == null) {
                throw new NullPointerException("collectionName is marked non-null but is null");
            }
            this.collectionName = collectionName;
            return this;
        }

        public Builder withOutFields(@NonNull List<String> outFields) {
            if (outFields == null) {
                throw new NullPointerException("outFields is marked non-null but is null");
            }
            this.outputFields.addAll(outFields);
            return this;
        }

        public Builder withFilter(@NonNull String filter) {
            if (filter == null) {
                throw new NullPointerException("filter is marked non-null but is null");
            }
            this.filter = filter;
            return this;
        }

        public Builder withOffset(@NonNull Long offset) {
            if (offset == null) {
                throw new NullPointerException("offset is marked non-null but is null");
            }
            this.offset = offset;
            return this;
        }

        public Builder withLimit(@NonNull Long limit) {
            if (limit == null) {
                throw new NullPointerException("limit is marked non-null but is null");
            }
            this.limit = limit;
            return this;
        }

        public QuerySimpleParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.collectionName, "Collection name");
            ParamUtils.CheckNullEmptyString(this.filter, "Filter");
            if (this.offset < 0L) {
                throw new ParamException("The offset value cannot be less than 0");
            }
            if (this.limit < 0L) {
                throw new ParamException("The limit value cannot be less than 0");
            }
            return new QuerySimpleParam(this);
        }
    }
}

