/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.grpc;

import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import io.milvus.grpc.SchemaProto;
import io.milvus.grpc.ValueFieldOrBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public final class ValueField
extends GeneratedMessageV3
implements ValueFieldOrBuilder {
    private static final long serialVersionUID = 0L;
    private int dataCase_ = 0;
    private Object data_;
    public static final int BOOL_DATA_FIELD_NUMBER = 1;
    public static final int INT_DATA_FIELD_NUMBER = 2;
    public static final int LONG_DATA_FIELD_NUMBER = 3;
    public static final int FLOAT_DATA_FIELD_NUMBER = 4;
    public static final int DOUBLE_DATA_FIELD_NUMBER = 5;
    public static final int STRING_DATA_FIELD_NUMBER = 6;
    public static final int BYTES_DATA_FIELD_NUMBER = 7;
    private byte memoizedIsInitialized = (byte)-1;
    private static final ValueField DEFAULT_INSTANCE = new ValueField();
    private static final Parser<ValueField> PARSER = new AbstractParser<ValueField>(){

        public ValueField parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = ValueField.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private ValueField(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private ValueField() {
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new ValueField();
    }

    public final UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return SchemaProto.internal_static_milvus_proto_schema_ValueField_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return SchemaProto.internal_static_milvus_proto_schema_ValueField_fieldAccessorTable.ensureFieldAccessorsInitialized(ValueField.class, Builder.class);
    }

    @Override
    public DataCase getDataCase() {
        return DataCase.forNumber(this.dataCase_);
    }

    @Override
    public boolean hasBoolData() {
        return this.dataCase_ == 1;
    }

    @Override
    public boolean getBoolData() {
        if (this.dataCase_ == 1) {
            return (Boolean)this.data_;
        }
        return false;
    }

    @Override
    public boolean hasIntData() {
        return this.dataCase_ == 2;
    }

    @Override
    public int getIntData() {
        if (this.dataCase_ == 2) {
            return (Integer)this.data_;
        }
        return 0;
    }

    @Override
    public boolean hasLongData() {
        return this.dataCase_ == 3;
    }

    @Override
    public long getLongData() {
        if (this.dataCase_ == 3) {
            return (Long)this.data_;
        }
        return 0L;
    }

    @Override
    public boolean hasFloatData() {
        return this.dataCase_ == 4;
    }

    @Override
    public float getFloatData() {
        if (this.dataCase_ == 4) {
            return ((Float)this.data_).floatValue();
        }
        return 0.0f;
    }

    @Override
    public boolean hasDoubleData() {
        return this.dataCase_ == 5;
    }

    @Override
    public double getDoubleData() {
        if (this.dataCase_ == 5) {
            return (Double)this.data_;
        }
        return 0.0;
    }

    @Override
    public boolean hasStringData() {
        return this.dataCase_ == 6;
    }

    @Override
    public String getStringData() {
        Object ref = "";
        if (this.dataCase_ == 6) {
            ref = this.data_;
        }
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        if (this.dataCase_ == 6) {
            this.data_ = s;
        }
        return s;
    }

    @Override
    public ByteString getStringDataBytes() {
        Object ref = "";
        if (this.dataCase_ == 6) {
            ref = this.data_;
        }
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            if (this.dataCase_ == 6) {
                this.data_ = b;
            }
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasBytesData() {
        return this.dataCase_ == 7;
    }

    @Override
    public ByteString getBytesData() {
        if (this.dataCase_ == 7) {
            return (ByteString)this.data_;
        }
        return ByteString.EMPTY;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        if (this.dataCase_ == 1) {
            output.writeBool(1, ((Boolean)this.data_).booleanValue());
        }
        if (this.dataCase_ == 2) {
            output.writeInt32(2, ((Integer)this.data_).intValue());
        }
        if (this.dataCase_ == 3) {
            output.writeInt64(3, ((Long)this.data_).longValue());
        }
        if (this.dataCase_ == 4) {
            output.writeFloat(4, ((Float)this.data_).floatValue());
        }
        if (this.dataCase_ == 5) {
            output.writeDouble(5, ((Double)this.data_).doubleValue());
        }
        if (this.dataCase_ == 6) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)6, (Object)this.data_);
        }
        if (this.dataCase_ == 7) {
            output.writeBytes(7, (ByteString)this.data_);
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (this.dataCase_ == 1) {
            size += CodedOutputStream.computeBoolSize((int)1, (boolean)((Boolean)this.data_));
        }
        if (this.dataCase_ == 2) {
            size += CodedOutputStream.computeInt32Size((int)2, (int)((Integer)this.data_));
        }
        if (this.dataCase_ == 3) {
            size += CodedOutputStream.computeInt64Size((int)3, (long)((Long)this.data_));
        }
        if (this.dataCase_ == 4) {
            size += CodedOutputStream.computeFloatSize((int)4, (float)((Float)this.data_).floatValue());
        }
        if (this.dataCase_ == 5) {
            size += CodedOutputStream.computeDoubleSize((int)5, (double)((Double)this.data_));
        }
        if (this.dataCase_ == 6) {
            size += GeneratedMessageV3.computeStringSize((int)6, (Object)this.data_);
        }
        if (this.dataCase_ == 7) {
            size += CodedOutputStream.computeBytesSize((int)7, (ByteString)((ByteString)this.data_));
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ValueField)) {
            return super.equals(obj);
        }
        ValueField other = (ValueField)obj;
        if (!this.getDataCase().equals((Object)other.getDataCase())) {
            return false;
        }
        switch (this.dataCase_) {
            case 1: {
                if (this.getBoolData() == other.getBoolData()) break;
                return false;
            }
            case 2: {
                if (this.getIntData() == other.getIntData()) break;
                return false;
            }
            case 3: {
                if (this.getLongData() == other.getLongData()) break;
                return false;
            }
            case 4: {
                if (Float.floatToIntBits(this.getFloatData()) == Float.floatToIntBits(other.getFloatData())) break;
                return false;
            }
            case 5: {
                if (Double.doubleToLongBits(this.getDoubleData()) == Double.doubleToLongBits(other.getDoubleData())) break;
                return false;
            }
            case 6: {
                if (this.getStringData().equals(other.getStringData())) break;
                return false;
            }
            case 7: {
                if (this.getBytesData().equals((Object)other.getBytesData())) break;
                return false;
            }
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + ValueField.getDescriptor().hashCode();
        switch (this.dataCase_) {
            case 1: {
                hash = 37 * hash + 1;
                hash = 53 * hash + Internal.hashBoolean((boolean)this.getBoolData());
                break;
            }
            case 2: {
                hash = 37 * hash + 2;
                hash = 53 * hash + this.getIntData();
                break;
            }
            case 3: {
                hash = 37 * hash + 3;
                hash = 53 * hash + Internal.hashLong((long)this.getLongData());
                break;
            }
            case 4: {
                hash = 37 * hash + 4;
                hash = 53 * hash + Float.floatToIntBits(this.getFloatData());
                break;
            }
            case 5: {
                hash = 37 * hash + 5;
                hash = 53 * hash + Internal.hashLong((long)Double.doubleToLongBits(this.getDoubleData()));
                break;
            }
            case 6: {
                hash = 37 * hash + 6;
                hash = 53 * hash + this.getStringData().hashCode();
                break;
            }
            case 7: {
                hash = 37 * hash + 7;
                hash = 53 * hash + this.getBytesData().hashCode();
                break;
            }
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static ValueField parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (ValueField)PARSER.parseFrom(data);
    }

    public static ValueField parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (ValueField)PARSER.parseFrom(data, extensionRegistry);
    }

    public static ValueField parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (ValueField)PARSER.parseFrom(data);
    }

    public static ValueField parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (ValueField)PARSER.parseFrom(data, extensionRegistry);
    }

    public static ValueField parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (ValueField)PARSER.parseFrom(data);
    }

    public static ValueField parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (ValueField)PARSER.parseFrom(data, extensionRegistry);
    }

    public static ValueField parseFrom(InputStream input) throws IOException {
        return (ValueField)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static ValueField parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (ValueField)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static ValueField parseDelimitedFrom(InputStream input) throws IOException {
        return (ValueField)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static ValueField parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (ValueField)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static ValueField parseFrom(CodedInputStream input) throws IOException {
        return (ValueField)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static ValueField parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (ValueField)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return ValueField.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(ValueField prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static ValueField getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<ValueField> parser() {
        return PARSER;
    }

    public Parser<ValueField> getParserForType() {
        return PARSER;
    }

    public ValueField getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements ValueFieldOrBuilder {
        private int dataCase_ = 0;
        private Object data_;

        public static final Descriptors.Descriptor getDescriptor() {
            return SchemaProto.internal_static_milvus_proto_schema_ValueField_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return SchemaProto.internal_static_milvus_proto_schema_ValueField_fieldAccessorTable.ensureFieldAccessorsInitialized(ValueField.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
        }

        public Builder clear() {
            super.clear();
            this.dataCase_ = 0;
            this.data_ = null;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return SchemaProto.internal_static_milvus_proto_schema_ValueField_descriptor;
        }

        public ValueField getDefaultInstanceForType() {
            return ValueField.getDefaultInstance();
        }

        public ValueField build() {
            ValueField result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public ValueField buildPartial() {
            ValueField result = new ValueField(this);
            if (this.dataCase_ == 1) {
                result.data_ = this.data_;
            }
            if (this.dataCase_ == 2) {
                result.data_ = this.data_;
            }
            if (this.dataCase_ == 3) {
                result.data_ = this.data_;
            }
            if (this.dataCase_ == 4) {
                result.data_ = this.data_;
            }
            if (this.dataCase_ == 5) {
                result.data_ = this.data_;
            }
            if (this.dataCase_ == 6) {
                result.data_ = this.data_;
            }
            if (this.dataCase_ == 7) {
                result.data_ = this.data_;
            }
            result.dataCase_ = this.dataCase_;
            this.onBuilt();
            return result;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof ValueField) {
                return this.mergeFrom((ValueField)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(ValueField other) {
            if (other == ValueField.getDefaultInstance()) {
                return this;
            }
            switch (other.getDataCase()) {
                case BOOL_DATA: {
                    this.setBoolData(other.getBoolData());
                    break;
                }
                case INT_DATA: {
                    this.setIntData(other.getIntData());
                    break;
                }
                case LONG_DATA: {
                    this.setLongData(other.getLongData());
                    break;
                }
                case FLOAT_DATA: {
                    this.setFloatData(other.getFloatData());
                    break;
                }
                case DOUBLE_DATA: {
                    this.setDoubleData(other.getDoubleData());
                    break;
                }
                case STRING_DATA: {
                    this.dataCase_ = 6;
                    this.data_ = other.data_;
                    this.onChanged();
                    break;
                }
                case BYTES_DATA: {
                    this.setBytesData(other.getBytesData());
                    break;
                }
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block15: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block15;
                        }
                        case 8: {
                            this.data_ = input.readBool();
                            this.dataCase_ = 1;
                            continue block15;
                        }
                        case 16: {
                            this.data_ = input.readInt32();
                            this.dataCase_ = 2;
                            continue block15;
                        }
                        case 24: {
                            this.data_ = input.readInt64();
                            this.dataCase_ = 3;
                            continue block15;
                        }
                        case 37: {
                            this.data_ = Float.valueOf(input.readFloat());
                            this.dataCase_ = 4;
                            continue block15;
                        }
                        case 41: {
                            this.data_ = input.readDouble();
                            this.dataCase_ = 5;
                            continue block15;
                        }
                        case 50: {
                            String s = input.readStringRequireUtf8();
                            this.dataCase_ = 6;
                            this.data_ = s;
                            continue block15;
                        }
                        case 58: {
                            this.data_ = input.readBytes();
                            this.dataCase_ = 7;
                            continue block15;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public DataCase getDataCase() {
            return DataCase.forNumber(this.dataCase_);
        }

        public Builder clearData() {
            this.dataCase_ = 0;
            this.data_ = null;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasBoolData() {
            return this.dataCase_ == 1;
        }

        @Override
        public boolean getBoolData() {
            if (this.dataCase_ == 1) {
                return (Boolean)this.data_;
            }
            return false;
        }

        public Builder setBoolData(boolean value) {
            this.dataCase_ = 1;
            this.data_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearBoolData() {
            if (this.dataCase_ == 1) {
                this.dataCase_ = 0;
                this.data_ = null;
                this.onChanged();
            }
            return this;
        }

        @Override
        public boolean hasIntData() {
            return this.dataCase_ == 2;
        }

        @Override
        public int getIntData() {
            if (this.dataCase_ == 2) {
                return (Integer)this.data_;
            }
            return 0;
        }

        public Builder setIntData(int value) {
            this.dataCase_ = 2;
            this.data_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearIntData() {
            if (this.dataCase_ == 2) {
                this.dataCase_ = 0;
                this.data_ = null;
                this.onChanged();
            }
            return this;
        }

        @Override
        public boolean hasLongData() {
            return this.dataCase_ == 3;
        }

        @Override
        public long getLongData() {
            if (this.dataCase_ == 3) {
                return (Long)this.data_;
            }
            return 0L;
        }

        public Builder setLongData(long value) {
            this.dataCase_ = 3;
            this.data_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearLongData() {
            if (this.dataCase_ == 3) {
                this.dataCase_ = 0;
                this.data_ = null;
                this.onChanged();
            }
            return this;
        }

        @Override
        public boolean hasFloatData() {
            return this.dataCase_ == 4;
        }

        @Override
        public float getFloatData() {
            if (this.dataCase_ == 4) {
                return ((Float)this.data_).floatValue();
            }
            return 0.0f;
        }

        public Builder setFloatData(float value) {
            this.dataCase_ = 4;
            this.data_ = Float.valueOf(value);
            this.onChanged();
            return this;
        }

        public Builder clearFloatData() {
            if (this.dataCase_ == 4) {
                this.dataCase_ = 0;
                this.data_ = null;
                this.onChanged();
            }
            return this;
        }

        @Override
        public boolean hasDoubleData() {
            return this.dataCase_ == 5;
        }

        @Override
        public double getDoubleData() {
            if (this.dataCase_ == 5) {
                return (Double)this.data_;
            }
            return 0.0;
        }

        public Builder setDoubleData(double value) {
            this.dataCase_ = 5;
            this.data_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearDoubleData() {
            if (this.dataCase_ == 5) {
                this.dataCase_ = 0;
                this.data_ = null;
                this.onChanged();
            }
            return this;
        }

        @Override
        public boolean hasStringData() {
            return this.dataCase_ == 6;
        }

        @Override
        public String getStringData() {
            Object ref = "";
            if (this.dataCase_ == 6) {
                ref = this.data_;
            }
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                if (this.dataCase_ == 6) {
                    this.data_ = s;
                }
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getStringDataBytes() {
            Object ref = "";
            if (this.dataCase_ == 6) {
                ref = this.data_;
            }
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                if (this.dataCase_ == 6) {
                    this.data_ = b;
                }
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setStringData(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.dataCase_ = 6;
            this.data_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearStringData() {
            if (this.dataCase_ == 6) {
                this.dataCase_ = 0;
                this.data_ = null;
                this.onChanged();
            }
            return this;
        }

        public Builder setStringDataBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ValueField.checkByteStringIsUtf8((ByteString)value);
            this.dataCase_ = 6;
            this.data_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasBytesData() {
            return this.dataCase_ == 7;
        }

        @Override
        public ByteString getBytesData() {
            if (this.dataCase_ == 7) {
                return (ByteString)this.data_;
            }
            return ByteString.EMPTY;
        }

        public Builder setBytesData(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.dataCase_ = 7;
            this.data_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearBytesData() {
            if (this.dataCase_ == 7) {
                this.dataCase_ = 0;
                this.data_ = null;
                this.onChanged();
            }
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    public static enum DataCase implements Internal.EnumLite,
    AbstractMessageLite.InternalOneOfEnum
    {
        BOOL_DATA(1),
        INT_DATA(2),
        LONG_DATA(3),
        FLOAT_DATA(4),
        DOUBLE_DATA(5),
        STRING_DATA(6),
        BYTES_DATA(7),
        DATA_NOT_SET(0);

        private final int value;

        private DataCase(int value) {
            this.value = value;
        }

        @Deprecated
        public static DataCase valueOf(int value) {
            return DataCase.forNumber(value);
        }

        public static DataCase forNumber(int value) {
            switch (value) {
                case 1: {
                    return BOOL_DATA;
                }
                case 2: {
                    return INT_DATA;
                }
                case 3: {
                    return LONG_DATA;
                }
                case 4: {
                    return FLOAT_DATA;
                }
                case 5: {
                    return DOUBLE_DATA;
                }
                case 6: {
                    return STRING_DATA;
                }
                case 7: {
                    return BYTES_DATA;
                }
                case 0: {
                    return DATA_NOT_SET;
                }
            }
            return null;
        }

        public int getNumber() {
            return this.value;
        }
    }
}

