/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.response;

import com.alibaba.fastjson.JSONObject;
import com.google.protobuf.ByteString;
import com.google.protobuf.ProtocolStringList;
import io.milvus.exception.IllegalResponseException;
import io.milvus.exception.ParamException;
import io.milvus.grpc.DataType;
import io.milvus.grpc.FieldData;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;

public class FieldDataWrapper {
    private final FieldData fieldData;

    public FieldDataWrapper(@NonNull FieldData fieldData) {
        if (fieldData == null) {
            throw new NullPointerException("fieldData is marked non-null but is null");
        }
        this.fieldData = fieldData;
    }

    public boolean isVectorField() {
        return this.fieldData.getType() == DataType.FloatVector || this.fieldData.getType() == DataType.BinaryVector;
    }

    public boolean isJsonField() {
        return this.fieldData.getType() == DataType.JSON;
    }

    public boolean isDynamicField() {
        return this.fieldData.getType() == DataType.JSON && this.fieldData.getIsDynamic();
    }

    public int getDim() throws IllegalResponseException {
        if (!this.isVectorField()) {
            throw new IllegalResponseException("Not a vector field");
        }
        return (int)this.fieldData.getVectors().getDim();
    }

    public long getRowCount() throws IllegalResponseException {
        DataType dt = this.fieldData.getType();
        switch (dt) {
            case FloatVector: {
                int dim = this.getDim();
                List<Float> data = this.fieldData.getVectors().getFloatVector().getDataList();
                if (data.size() % dim != 0) {
                    throw new IllegalResponseException("Returned float vector field data array size doesn't match dimension");
                }
                return data.size() / dim;
            }
            case BinaryVector: {
                int dim = this.getDim();
                ByteString data = this.fieldData.getVectors().getBinaryVector();
                if (data.size() % dim != 0) {
                    throw new IllegalResponseException("Returned binary vector field data array size doesn't match dimension");
                }
                return data.size() / dim;
            }
            case Int64: {
                return this.fieldData.getScalars().getLongData().getDataList().size();
            }
            case Int32: 
            case Int16: 
            case Int8: {
                return this.fieldData.getScalars().getIntData().getDataList().size();
            }
            case Bool: {
                return this.fieldData.getScalars().getBoolData().getDataList().size();
            }
            case Float: {
                return this.fieldData.getScalars().getFloatData().getDataList().size();
            }
            case Double: {
                return this.fieldData.getScalars().getDoubleData().getDataList().size();
            }
            case VarChar: 
            case String: {
                return this.fieldData.getScalars().getStringData().getDataList().size();
            }
            case JSON: {
                return this.fieldData.getScalars().getJsonData().getDataList().size();
            }
        }
        throw new IllegalResponseException("Unsupported data type returned by FieldData");
    }

    public List<?> getFieldData() throws IllegalResponseException {
        DataType dt = this.fieldData.getType();
        switch (dt) {
            case FloatVector: {
                int dim = this.getDim();
                List<Float> data = this.fieldData.getVectors().getFloatVector().getDataList();
                if (data.size() % dim != 0) {
                    throw new IllegalResponseException("Returned float vector field data array size doesn't match dimension");
                }
                ArrayList<List<Float>> packData = new ArrayList<List<Float>>();
                int count = data.size() / dim;
                for (int i = 0; i < count; ++i) {
                    packData.add(data.subList(i * dim, (i + 1) * dim));
                }
                return packData;
            }
            case BinaryVector: {
                int dim = this.getDim();
                ByteString data = this.fieldData.getVectors().getBinaryVector();
                if (data.size() % dim != 0) {
                    throw new IllegalResponseException("Returned binary vector field data array size doesn't match dimension");
                }
                ArrayList<ByteBuffer> packData = new ArrayList<ByteBuffer>();
                int count = data.size() / dim;
                for (int i = 0; i < count; ++i) {
                    ByteBuffer bf = ByteBuffer.allocate(dim);
                    bf.put(data.substring(i * dim, (i + 1) * dim).toByteArray());
                    packData.add(bf);
                }
                return packData;
            }
            case Int64: {
                return this.fieldData.getScalars().getLongData().getDataList();
            }
            case Int32: 
            case Int16: 
            case Int8: {
                return this.fieldData.getScalars().getIntData().getDataList();
            }
            case Bool: {
                return this.fieldData.getScalars().getBoolData().getDataList();
            }
            case Float: {
                return this.fieldData.getScalars().getFloatData().getDataList();
            }
            case Double: {
                return this.fieldData.getScalars().getDoubleData().getDataList();
            }
            case VarChar: 
            case String: {
                ProtocolStringList protoStrList = this.fieldData.getScalars().getStringData().getDataList();
                return protoStrList.subList(0, protoStrList.size());
            }
            case JSON: {
                List<ByteString> dataList = this.fieldData.getScalars().getJsonData().getDataList();
                return dataList.stream().map(ByteString::toByteArray).collect(Collectors.toList());
            }
        }
        throw new IllegalResponseException("Unsupported data type returned by FieldData");
    }

    public Integer getAsInt(int index, String paramName) throws IllegalResponseException {
        if (this.isJsonField()) {
            String result = this.getAsString(index, paramName);
            return result == null ? null : Integer.valueOf(Integer.parseInt(result));
        }
        throw new IllegalResponseException("Only JSON type support this operation");
    }

    public String getAsString(int index, String paramName) throws IllegalResponseException {
        if (this.isJsonField()) {
            JSONObject jsonObject = this.parseObjectData(index);
            return jsonObject.getString(paramName);
        }
        throw new IllegalResponseException("Only JSON type support this operation");
    }

    public Boolean getAsBool(int index, String paramName) throws IllegalResponseException {
        if (this.isJsonField()) {
            String result = this.getAsString(index, paramName);
            return result == null ? null : Boolean.valueOf(Boolean.parseBoolean(result));
        }
        throw new IllegalResponseException("Only JSON type support this operation");
    }

    public Double getAsDouble(int index, String paramName) throws IllegalResponseException {
        if (this.isJsonField()) {
            String result = this.getAsString(index, paramName);
            return result == null ? null : Double.valueOf(Double.parseDouble(result));
        }
        throw new IllegalResponseException("Only JSON type support this operation");
    }

    public Object get(int index, String paramName) throws IllegalResponseException {
        if (this.isJsonField()) {
            JSONObject jsonObject = this.parseObjectData(index);
            return jsonObject.get((Object)paramName);
        }
        throw new IllegalResponseException("Only JSON type support this operation");
    }

    public Object valueByIdx(int index) throws ParamException {
        if (index < 0 || index >= this.getFieldData().size()) {
            throw new ParamException("index out of range");
        }
        return this.getFieldData().get(index);
    }

    private JSONObject parseObjectData(int index) {
        Object object = this.valueByIdx(index);
        return JSONObject.parseObject((String)new String((byte[])object));
    }
}

