/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.service.utility;

import io.milvus.grpc.AlterAliasRequest;
import io.milvus.grpc.CreateAliasRequest;
import io.milvus.grpc.DescribeAliasRequest;
import io.milvus.grpc.DescribeAliasResponse;
import io.milvus.grpc.DropAliasRequest;
import io.milvus.grpc.FlushRequest;
import io.milvus.grpc.FlushResponse;
import io.milvus.grpc.ListAliasesRequest;
import io.milvus.grpc.ListAliasesResponse;
import io.milvus.grpc.MilvusServiceGrpc;
import io.milvus.grpc.Status;
import io.milvus.param.R;
import io.milvus.param.RpcStatus;
import io.milvus.v2.service.BaseService;
import io.milvus.v2.service.utility.request.AlterAliasReq;
import io.milvus.v2.service.utility.request.CreateAliasReq;
import io.milvus.v2.service.utility.request.DescribeAliasReq;
import io.milvus.v2.service.utility.request.DropAliasReq;
import io.milvus.v2.service.utility.request.FlushReq;
import io.milvus.v2.service.utility.request.ListAliasesReq;
import io.milvus.v2.service.utility.response.DescribeAliasResp;
import io.milvus.v2.service.utility.response.ListAliasResp;
import java.util.List;

public class UtilityService
extends BaseService {
    public R<RpcStatus> flush(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, FlushReq request) {
        String title = String.format("Flush collection %s", request.getCollectionName());
        FlushRequest flushRequest = FlushRequest.newBuilder().addCollectionNames(request.getCollectionName()).build();
        FlushResponse status = blockingStub.flush(flushRequest);
        this.rpcUtils.handleResponse(title, status.getStatus());
        return R.success(new RpcStatus("Success"));
    }

    public Void createAlias(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, CreateAliasReq request) {
        String title = String.format("Create alias %s for collection %s", request.getAlias(), request.getCollectionName());
        CreateAliasRequest createAliasRequest = CreateAliasRequest.newBuilder().setCollectionName(request.getCollectionName()).setAlias(request.getAlias()).build();
        Status status = blockingStub.createAlias(createAliasRequest);
        this.rpcUtils.handleResponse(title, status);
        return null;
    }

    public Void dropAlias(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, DropAliasReq request) {
        String title = String.format("Drop alias %s", request.getAlias());
        DropAliasRequest dropAliasRequest = DropAliasRequest.newBuilder().setAlias(request.getAlias()).build();
        Status status = blockingStub.dropAlias(dropAliasRequest);
        this.rpcUtils.handleResponse(title, status);
        return null;
    }

    public Void alterAlias(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, AlterAliasReq request) {
        String title = String.format("Alter alias %s for collection %s", request.getAlias(), request.getCollectionName());
        AlterAliasRequest alterAliasRequest = AlterAliasRequest.newBuilder().setCollectionName(request.getCollectionName()).setAlias(request.getAlias()).build();
        Status status = blockingStub.alterAlias(alterAliasRequest);
        this.rpcUtils.handleResponse(title, status);
        return null;
    }

    public DescribeAliasResp describeAlias(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, DescribeAliasReq request) {
        String title = String.format("Describe alias %s", request.getAlias());
        DescribeAliasRequest describeAliasRequest = DescribeAliasRequest.newBuilder().setAlias(request.getAlias()).build();
        DescribeAliasResponse response = blockingStub.describeAlias(describeAliasRequest);
        this.rpcUtils.handleResponse(title, response.getStatus());
        return ((DescribeAliasResp.DescribeAliasRespBuilder)((DescribeAliasResp.DescribeAliasRespBuilder)DescribeAliasResp.builder().collectionName(response.getCollection())).alias(response.getAlias())).build();
    }

    public ListAliasResp listAliases(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, ListAliasesReq request) {
        String title = "List aliases";
        ListAliasesRequest listAliasesRequest = ListAliasesRequest.newBuilder().setCollectionName(request.getCollectionName()).build();
        ListAliasesResponse response = blockingStub.listAliases(listAliasesRequest);
        this.rpcUtils.handleResponse(title, response.getStatus());
        return ((ListAliasResp.ListAliasRespBuilder)((ListAliasResp.ListAliasRespBuilder)ListAliasResp.builder().collectionName(response.getCollectionName())).alias((List<String>)response.getAliasesList())).build();
    }
}

