/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.client;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.milvus.grpc.ClientInfo;
import io.milvus.grpc.ConnectRequest;
import io.milvus.grpc.ConnectResponse;
import io.milvus.grpc.ErrorCode;
import io.milvus.grpc.MilvusServiceGrpc;
import io.milvus.orm.iterator.QueryIterator;
import io.milvus.orm.iterator.SearchIterator;
import io.milvus.v2.client.ConnectConfig;
import io.milvus.v2.client.RetryConfig;
import io.milvus.v2.exception.MilvusClientException;
import io.milvus.v2.service.collection.CollectionService;
import io.milvus.v2.service.collection.request.CreateCollectionReq;
import io.milvus.v2.service.collection.request.DescribeCollectionReq;
import io.milvus.v2.service.collection.request.DropCollectionReq;
import io.milvus.v2.service.collection.request.GetCollectionStatsReq;
import io.milvus.v2.service.collection.request.GetLoadStateReq;
import io.milvus.v2.service.collection.request.HasCollectionReq;
import io.milvus.v2.service.collection.request.LoadCollectionReq;
import io.milvus.v2.service.collection.request.ReleaseCollectionReq;
import io.milvus.v2.service.collection.request.RenameCollectionReq;
import io.milvus.v2.service.collection.response.DescribeCollectionResp;
import io.milvus.v2.service.collection.response.GetCollectionStatsResp;
import io.milvus.v2.service.collection.response.ListCollectionsResp;
import io.milvus.v2.service.database.DatabaseService;
import io.milvus.v2.service.database.request.CreateDatabaseReq;
import io.milvus.v2.service.database.request.DropDatabaseReq;
import io.milvus.v2.service.database.response.ListDatabasesResp;
import io.milvus.v2.service.index.IndexService;
import io.milvus.v2.service.index.request.CreateIndexReq;
import io.milvus.v2.service.index.request.DescribeIndexReq;
import io.milvus.v2.service.index.request.DropIndexReq;
import io.milvus.v2.service.index.request.ListIndexesReq;
import io.milvus.v2.service.index.response.DescribeIndexResp;
import io.milvus.v2.service.partition.PartitionService;
import io.milvus.v2.service.partition.request.CreatePartitionReq;
import io.milvus.v2.service.partition.request.DropPartitionReq;
import io.milvus.v2.service.partition.request.HasPartitionReq;
import io.milvus.v2.service.partition.request.ListPartitionsReq;
import io.milvus.v2.service.partition.request.LoadPartitionsReq;
import io.milvus.v2.service.partition.request.ReleasePartitionsReq;
import io.milvus.v2.service.rbac.RoleService;
import io.milvus.v2.service.rbac.UserService;
import io.milvus.v2.service.rbac.request.CreateRoleReq;
import io.milvus.v2.service.rbac.request.CreateUserReq;
import io.milvus.v2.service.rbac.request.DescribeRoleReq;
import io.milvus.v2.service.rbac.request.DescribeUserReq;
import io.milvus.v2.service.rbac.request.DropRoleReq;
import io.milvus.v2.service.rbac.request.DropUserReq;
import io.milvus.v2.service.rbac.request.GrantPrivilegeReq;
import io.milvus.v2.service.rbac.request.GrantRoleReq;
import io.milvus.v2.service.rbac.request.RevokePrivilegeReq;
import io.milvus.v2.service.rbac.request.RevokeRoleReq;
import io.milvus.v2.service.rbac.request.UpdatePasswordReq;
import io.milvus.v2.service.rbac.response.DescribeRoleResp;
import io.milvus.v2.service.rbac.response.DescribeUserResp;
import io.milvus.v2.service.utility.UtilityService;
import io.milvus.v2.service.utility.request.AlterAliasReq;
import io.milvus.v2.service.utility.request.CreateAliasReq;
import io.milvus.v2.service.utility.request.DescribeAliasReq;
import io.milvus.v2.service.utility.request.DropAliasReq;
import io.milvus.v2.service.utility.request.ListAliasesReq;
import io.milvus.v2.service.utility.response.DescribeAliasResp;
import io.milvus.v2.service.utility.response.ListAliasResp;
import io.milvus.v2.service.vector.VectorService;
import io.milvus.v2.service.vector.request.DeleteReq;
import io.milvus.v2.service.vector.request.GetReq;
import io.milvus.v2.service.vector.request.InsertReq;
import io.milvus.v2.service.vector.request.QueryIteratorReq;
import io.milvus.v2.service.vector.request.QueryReq;
import io.milvus.v2.service.vector.request.SearchIteratorReq;
import io.milvus.v2.service.vector.request.SearchReq;
import io.milvus.v2.service.vector.request.UpsertReq;
import io.milvus.v2.service.vector.response.DeleteResp;
import io.milvus.v2.service.vector.response.GetResp;
import io.milvus.v2.service.vector.response.InsertResp;
import io.milvus.v2.service.vector.response.QueryResp;
import io.milvus.v2.service.vector.response.SearchResp;
import io.milvus.v2.service.vector.response.UpsertResp;
import io.milvus.v2.utils.ClientUtils;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MilvusClientV2 {
    private static final Logger logger = LoggerFactory.getLogger(MilvusClientV2.class);
    private ManagedChannel channel;
    private MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub;
    private final ClientUtils clientUtils = new ClientUtils();
    private final DatabaseService databaseService = new DatabaseService();
    private final CollectionService collectionService = new CollectionService();
    private final IndexService indexService = new IndexService();
    private final VectorService vectorService = new VectorService();
    private final PartitionService partitionService = new PartitionService();
    private final UserService userService = new UserService();
    private final RoleService roleService = new RoleService();
    private final UtilityService utilityService = new UtilityService();
    private ConnectConfig connectConfig;
    private RetryConfig retryConfig = RetryConfig.builder().build();

    public MilvusClientV2(ConnectConfig connectConfig) {
        if (connectConfig != null) {
            this.connect(connectConfig);
        }
    }

    private void connect(ConnectConfig connectConfig) {
        this.connectConfig = connectConfig;
        try {
            if (this.channel != null) {
                this.close(3L);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        this.channel = this.clientUtils.getChannel(connectConfig);
        this.blockingStub = MilvusServiceGrpc.newBlockingStub((Channel)this.channel);
        this.connect(connectConfig, this.blockingStub);
        if (connectConfig.getRpcDeadlineMs() > 0L) {
            this.blockingStub = (MilvusServiceGrpc.MilvusServiceBlockingStub)((MilvusServiceGrpc.MilvusServiceBlockingStub)this.blockingStub.withWaitForReady()).withDeadlineAfter(connectConfig.getRpcDeadlineMs(), TimeUnit.MILLISECONDS);
        }
        if (connectConfig.getDbName() != null) {
            this.clientUtils.checkDatabaseExist(this.blockingStub, connectConfig.getDbName());
        }
    }

    private void connect(ConnectConfig connectConfig, MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub) {
        String userName = connectConfig.getUsername();
        if (userName == null) {
            userName = "";
        }
        ClientInfo info = ClientInfo.newBuilder().setSdkType("Java").setSdkVersion(this.clientUtils.getSDKVersion()).setUser(userName).setHost(this.clientUtils.getHostName()).setLocalTime(this.clientUtils.getLocalTimeStr()).build();
        ConnectRequest req = ConnectRequest.newBuilder().setClientInfo(info).build();
        ConnectResponse resp = ((MilvusServiceGrpc.MilvusServiceBlockingStub)blockingStub.withDeadlineAfter(1L, TimeUnit.SECONDS)).connect(req);
        if (resp.getStatus().getCode() != 0 || !resp.getStatus().getErrorCode().equals((Object)ErrorCode.Success)) {
            throw new RuntimeException("Failed to initialize connection. Error: " + resp.getStatus().getReason());
        }
    }

    public void retryConfig(RetryConfig retryConfig) {
        this.retryConfig = retryConfig;
    }

    private <T> T retry(Callable<T> callable) {
        int maxRetryTimes = this.retryConfig.getMaxRetryTimes();
        if (maxRetryTimes <= 1) {
            try {
                return callable.call();
            }
            catch (StatusRuntimeException e) {
                throw new MilvusClientException(io.milvus.v2.exception.ErrorCode.RPC_ERROR, (Throwable)e);
            }
            catch (MilvusClientException e) {
                throw e;
            }
            catch (Exception e) {
                throw new MilvusClientException(io.milvus.v2.exception.ErrorCode.CLIENT_ERROR, (Throwable)e);
            }
        }
        long begin = System.currentTimeMillis();
        long maxRetryTimeoutMs = this.retryConfig.getMaxRetryTimeoutMs();
        Callable<Boolean> timeoutChecker = () -> {
            long current = System.currentTimeMillis();
            long cost = current - begin;
            if (maxRetryTimeoutMs > 0L && cost >= maxRetryTimeoutMs) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        };
        long retryIntervalMs = this.retryConfig.getInitialBackOffMs();
        for (int k = 1; k <= maxRetryTimes; ++k) {
            try {
                return callable.call();
            }
            catch (StatusRuntimeException e) {
                Status.Code code = e.getStatus().getCode();
                if (code == Status.DEADLINE_EXCEEDED.getCode() || code == Status.PERMISSION_DENIED.getCode() || code == Status.UNAUTHENTICATED.getCode() || code == Status.INVALID_ARGUMENT.getCode() || code == Status.ALREADY_EXISTS.getCode() || code == Status.RESOURCE_EXHAUSTED.getCode() || code == Status.UNIMPLEMENTED.getCode()) {
                    String msg = String.format("Encounter rpc error that cannot be retried, reason: %s", new Object[]{e});
                    logger.error(msg);
                    throw new MilvusClientException(io.milvus.v2.exception.ErrorCode.RPC_ERROR, msg);
                }
                try {
                    if (timeoutChecker.call() == Boolean.TRUE) {
                        String msg = String.format("Retry timeout: %dms, maxRetry:%d, retries: %d, reason: %s", maxRetryTimeoutMs, maxRetryTimes, k, e.getMessage());
                        logger.warn(msg);
                        throw new MilvusClientException(io.milvus.v2.exception.ErrorCode.TIMEOUT, msg);
                    }
                }
                catch (Exception exception) {}
            }
            catch (MilvusClientException e) {
                try {
                    if (timeoutChecker.call() == Boolean.TRUE) {
                        String msg = String.format("Retry timeout: %dms, maxRetry:%d, retries: %d, reason: %s", maxRetryTimeoutMs, maxRetryTimes, k, e.getMessage());
                        logger.warn(msg);
                        throw new MilvusClientException(io.milvus.v2.exception.ErrorCode.TIMEOUT, msg);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!this.retryConfig.isRetryOnRateLimit() || e.getLegacyServerCode() != ErrorCode.RateLimit.getNumber() && e.getServerErrCode() != 8) {
                    throw e;
                }
            }
            catch (Exception e) {
                throw new MilvusClientException(io.milvus.v2.exception.ErrorCode.CLIENT_ERROR, (Throwable)e);
            }
            try {
                if (k >= maxRetryTimes) {
                    String msg = String.format("Finish %d retry times, stop retry", maxRetryTimes);
                    logger.warn(msg);
                    throw new MilvusClientException(io.milvus.v2.exception.ErrorCode.TIMEOUT, msg);
                }
                if (k > 3) {
                    logger.warn(String.format("Retry(%d) with interval %dms", k, retryIntervalMs));
                }
                TimeUnit.MILLISECONDS.sleep(retryIntervalMs);
                if ((retryIntervalMs *= (long)this.retryConfig.getBackOffMultiplier()) <= this.retryConfig.getMaxBackOffMs()) continue;
                retryIntervalMs = this.retryConfig.getMaxBackOffMs();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public void useDatabase(@NonNull String dbName) throws InterruptedException {
        if (dbName == null) {
            throw new NullPointerException("dbName is marked non-null but is null");
        }
        this.clientUtils.checkDatabaseExist(this.blockingStub, dbName);
        try {
            this.connectConfig.setDbName(dbName);
            this.close(3L);
            this.connect(this.connectConfig);
        }
        catch (InterruptedException e) {
            logger.error("close connect error");
            throw new RuntimeException(e);
        }
    }

    public void createDatabase(CreateDatabaseReq request) {
        this.retry(() -> this.databaseService.createDatabase(this.blockingStub, request));
    }

    public void dropDatabase(DropDatabaseReq request) {
        this.retry(() -> this.databaseService.dropDatabase(this.blockingStub, request));
    }

    public ListDatabasesResp listDatabases() {
        return this.retry(() -> this.databaseService.listDatabases(this.blockingStub));
    }

    public void createCollection(CreateCollectionReq request) {
        this.retry(() -> this.collectionService.createCollection(this.blockingStub, request));
    }

    public CreateCollectionReq.CollectionSchema createSchema() {
        return this.collectionService.createSchema();
    }

    public ListCollectionsResp listCollections() {
        return this.retry(() -> this.collectionService.listCollections(this.blockingStub));
    }

    public void dropCollection(DropCollectionReq request) {
        this.retry(() -> this.collectionService.dropCollection(this.blockingStub, request));
    }

    public Boolean hasCollection(HasCollectionReq request) {
        return this.retry(() -> this.collectionService.hasCollection(this.blockingStub, request));
    }

    public DescribeCollectionResp describeCollection(DescribeCollectionReq request) {
        return this.retry(() -> this.collectionService.describeCollection(this.blockingStub, request));
    }

    public GetCollectionStatsResp getCollectionStats(GetCollectionStatsReq request) {
        return this.retry(() -> this.collectionService.getCollectionStats(this.blockingStub, request));
    }

    public void renameCollection(RenameCollectionReq request) {
        this.retry(() -> this.collectionService.renameCollection(this.blockingStub, request));
    }

    public void loadCollection(LoadCollectionReq request) {
        this.retry(() -> this.collectionService.loadCollection(this.blockingStub, request));
    }

    public void releaseCollection(ReleaseCollectionReq request) {
        this.retry(() -> this.collectionService.releaseCollection(this.blockingStub, request));
    }

    public Boolean getLoadState(GetLoadStateReq request) {
        return this.retry(() -> this.collectionService.getLoadState(this.blockingStub, request));
    }

    public void createIndex(CreateIndexReq request) {
        this.retry(() -> this.indexService.createIndex(this.blockingStub, request));
    }

    public void dropIndex(DropIndexReq request) {
        this.retry(() -> this.indexService.dropIndex(this.blockingStub, request));
    }

    public DescribeIndexResp describeIndex(DescribeIndexReq request) {
        return this.retry(() -> this.indexService.describeIndex(this.blockingStub, request));
    }

    public List<String> listIndexes(ListIndexesReq request) {
        return this.retry(() -> this.indexService.listIndexes(this.blockingStub, request));
    }

    public InsertResp insert(InsertReq request) {
        return this.retry(() -> this.vectorService.insert(this.blockingStub, request));
    }

    public UpsertResp upsert(UpsertReq request) {
        return this.retry(() -> this.vectorService.upsert(this.blockingStub, request));
    }

    public DeleteResp delete(DeleteReq request) {
        return this.retry(() -> this.vectorService.delete(this.blockingStub, request));
    }

    public GetResp get(GetReq request) {
        return this.retry(() -> this.vectorService.get(this.blockingStub, request));
    }

    public QueryResp query(QueryReq request) {
        return this.retry(() -> this.vectorService.query(this.blockingStub, request));
    }

    public SearchResp search(SearchReq request) {
        return this.retry(() -> this.vectorService.search(this.blockingStub, request));
    }

    public QueryIterator queryIterator(QueryIteratorReq request) {
        return this.retry(() -> this.vectorService.queryIterator(this.blockingStub, request));
    }

    public SearchIterator searchIterator(SearchIteratorReq request) {
        return this.retry(() -> this.vectorService.searchIterator(this.blockingStub, request));
    }

    public void createPartition(CreatePartitionReq request) {
        this.retry(() -> this.partitionService.createPartition(this.blockingStub, request));
    }

    public void dropPartition(DropPartitionReq request) {
        this.retry(() -> this.partitionService.dropPartition(this.blockingStub, request));
    }

    public Boolean hasPartition(HasPartitionReq request) {
        return this.retry(() -> this.partitionService.hasPartition(this.blockingStub, request));
    }

    public List<String> listPartitions(ListPartitionsReq request) {
        return this.retry(() -> this.partitionService.listPartitions(this.blockingStub, request));
    }

    public void loadPartitions(LoadPartitionsReq request) {
        this.retry(() -> this.partitionService.loadPartitions(this.blockingStub, request));
    }

    public void releasePartitions(ReleasePartitionsReq request) {
        this.retry(() -> this.partitionService.releasePartitions(this.blockingStub, request));
    }

    public List<String> listUsers() {
        return this.retry(() -> this.userService.listUsers(this.blockingStub));
    }

    public DescribeUserResp describeUser(DescribeUserReq request) {
        return this.retry(() -> this.userService.describeUser(this.blockingStub, request));
    }

    public void createUser(CreateUserReq request) {
        this.retry(() -> this.userService.createUser(this.blockingStub, request));
    }

    public void updatePassword(UpdatePasswordReq request) {
        this.retry(() -> this.userService.updatePassword(this.blockingStub, request));
    }

    public void dropUser(DropUserReq request) {
        this.retry(() -> this.userService.dropUser(this.blockingStub, request));
    }

    public List<String> listRoles() {
        return this.retry(() -> this.roleService.listRoles(this.blockingStub));
    }

    public DescribeRoleResp describeRole(DescribeRoleReq request) {
        return this.retry(() -> this.roleService.describeRole(this.blockingStub, request));
    }

    public void createRole(CreateRoleReq request) {
        this.retry(() -> this.roleService.createRole(this.blockingStub, request));
    }

    public void dropRole(DropRoleReq request) {
        this.retry(() -> this.roleService.dropRole(this.blockingStub, request));
    }

    public void grantPrivilege(GrantPrivilegeReq request) {
        this.retry(() -> this.roleService.grantPrivilege(this.blockingStub, request));
    }

    public void revokePrivilege(RevokePrivilegeReq request) {
        this.retry(() -> this.roleService.revokePrivilege(this.blockingStub, request));
    }

    public void grantRole(GrantRoleReq request) {
        this.retry(() -> this.roleService.grantRole(this.blockingStub, request));
    }

    public void revokeRole(RevokeRoleReq request) {
        this.retry(() -> this.roleService.revokeRole(this.blockingStub, request));
    }

    public void createAlias(CreateAliasReq request) {
        this.retry(() -> this.utilityService.createAlias(this.blockingStub, request));
    }

    public void dropAlias(DropAliasReq request) {
        this.retry(() -> this.utilityService.dropAlias(this.blockingStub, request));
    }

    public void alterAlias(AlterAliasReq request) {
        this.retry(() -> this.utilityService.alterAlias(this.blockingStub, request));
    }

    public ListAliasResp listAliases(ListAliasesReq request) {
        return this.retry(() -> this.utilityService.listAliases(this.blockingStub, request));
    }

    public DescribeAliasResp describeAlias(DescribeAliasReq request) {
        return this.retry(() -> this.utilityService.describeAlias(this.blockingStub, request));
    }

    public String getServerVersion() {
        return this.retry(() -> this.clientUtils.getServerVersion(this.blockingStub));
    }

    public void close(long maxWaitSeconds) throws InterruptedException {
        if (this.channel != null) {
            this.channel.shutdownNow();
            this.channel.awaitTermination(maxWaitSeconds, TimeUnit.SECONDS);
        }
    }

    public void close() {
        try {
            this.close(TimeUnit.MINUTES.toSeconds(1L));
        }
        catch (InterruptedException e) {
            System.out.println("Interrupted during shutdown Milvus client!");
        }
    }

    public boolean clientIsReady() {
        return this.channel != null && !this.channel.isShutdown() && !this.channel.isTerminated();
    }

    public void setBlockingStub(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub) {
        this.blockingStub = blockingStub;
    }
}

