/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.service.rbac;

import io.milvus.grpc.CreateCredentialRequest;
import io.milvus.grpc.DeleteCredentialRequest;
import io.milvus.grpc.ListCredUsersRequest;
import io.milvus.grpc.ListCredUsersResponse;
import io.milvus.grpc.MilvusServiceGrpc;
import io.milvus.grpc.RoleEntity;
import io.milvus.grpc.SelectUserRequest;
import io.milvus.grpc.SelectUserResponse;
import io.milvus.grpc.Status;
import io.milvus.grpc.UpdateCredentialRequest;
import io.milvus.grpc.UserEntity;
import io.milvus.v2.service.BaseService;
import io.milvus.v2.service.rbac.request.CreateUserReq;
import io.milvus.v2.service.rbac.request.DescribeUserReq;
import io.milvus.v2.service.rbac.request.DropUserReq;
import io.milvus.v2.service.rbac.request.UpdatePasswordReq;
import io.milvus.v2.service.rbac.response.DescribeUserResp;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.stream.Collectors;

public class UserService
extends BaseService {
    public List<String> listUsers(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub) {
        String title = "list users";
        ListCredUsersRequest request = ListCredUsersRequest.newBuilder().build();
        ListCredUsersResponse response = blockingStub.listCredUsers(request);
        this.rpcUtils.handleResponse(title, response.getStatus());
        return response.getUsernamesList();
    }

    public DescribeUserResp describeUser(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, DescribeUserReq request) {
        String title = String.format("describe user %s", request.getUserName());
        SelectUserRequest selectUserRequest = SelectUserRequest.newBuilder().setUser(UserEntity.newBuilder().setName(request.getUserName()).build()).setIncludeRoleInfo(Boolean.TRUE).build();
        SelectUserResponse response = blockingStub.selectUser(selectUserRequest);
        this.rpcUtils.handleResponse(title, response.getStatus());
        Object describeUserResp = ((DescribeUserResp.DescribeUserRespBuilder)DescribeUserResp.builder().roles(response.getResultsList().isEmpty() ? null : response.getResultsList().get(0).getRolesList().stream().map(RoleEntity::getName).collect(Collectors.toList()))).build();
        return describeUserResp;
    }

    public Void createUser(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, CreateUserReq request) {
        String title = String.format("create user %s", request.getUserName());
        CreateCredentialRequest createCredentialRequest = CreateCredentialRequest.newBuilder().setUsername(request.getUserName()).setPassword(Base64.getEncoder().encodeToString(request.getPassword().getBytes(StandardCharsets.UTF_8))).build();
        Status response = blockingStub.createCredential(createCredentialRequest);
        this.rpcUtils.handleResponse(title, response);
        return null;
    }

    public Void updatePassword(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, UpdatePasswordReq request) {
        String title = String.format("update password for user %s", request.getUserName());
        UpdateCredentialRequest updateCredentialRequest = UpdateCredentialRequest.newBuilder().setUsername(request.getUserName()).setOldPassword(Base64.getEncoder().encodeToString(request.getPassword().getBytes(StandardCharsets.UTF_8))).setNewPassword(Base64.getEncoder().encodeToString(request.getNewPassword().getBytes(StandardCharsets.UTF_8))).build();
        Status response = blockingStub.updateCredential(updateCredentialRequest);
        this.rpcUtils.handleResponse(title, response);
        return null;
    }

    public Void dropUser(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, DropUserReq request) {
        String title = String.format("drop user %s", request.getUserName());
        DeleteCredentialRequest deleteCredentialRequest = DeleteCredentialRequest.newBuilder().setUsername(request.getUserName()).build();
        Status response = blockingStub.deleteCredential(deleteCredentialRequest);
        this.rpcUtils.handleResponse(title, response);
        return null;
    }
}

