/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.resourcegroup;

import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;
import lombok.NonNull;

public class TransferReplicaParam {
    private final String sourceGroupName;
    private final String targetGroupName;
    private final String collectionName;
    private final String databaseName;
    private final long replicaNumber;

    private TransferReplicaParam(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.sourceGroupName = builder.sourceGroupName;
        this.targetGroupName = builder.targetGroupName;
        this.collectionName = builder.collectionName;
        this.databaseName = builder.databaseName;
        this.replicaNumber = builder.replicaNumber;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return "TransferReplicaParam{sourceGroupName='" + this.sourceGroupName + '\'' + "targetGroupName='" + this.targetGroupName + '\'' + "collectionName='" + this.collectionName + '\'' + "databaseName='" + this.databaseName + '\'' + "replicaNumber='" + this.replicaNumber + '}';
    }

    public String getSourceGroupName() {
        return this.sourceGroupName;
    }

    public String getTargetGroupName() {
        return this.targetGroupName;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public long getReplicaNumber() {
        return this.replicaNumber;
    }

    public static final class Builder {
        private String sourceGroupName;
        private String targetGroupName;
        private String collectionName;
        private String databaseName;
        private Long replicaNumber = 0L;

        private Builder() {
        }

        public Builder withSourceGroupName(@NonNull String groupName) {
            if (groupName == null) {
                throw new NullPointerException("groupName is marked non-null but is null");
            }
            this.sourceGroupName = groupName;
            return this;
        }

        public Builder withTargetGroupName(@NonNull String groupName) {
            if (groupName == null) {
                throw new NullPointerException("groupName is marked non-null but is null");
            }
            this.targetGroupName = groupName;
            return this;
        }

        public Builder withCollectionName(@NonNull String collectionName) {
            if (collectionName == null) {
                throw new NullPointerException("collectionName is marked non-null but is null");
            }
            this.collectionName = collectionName;
            return this;
        }

        public Builder withDatabaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public Builder withReplicaNumber(@NonNull Long replicaNumber) {
            if (replicaNumber == null) {
                throw new NullPointerException("replicaNumber is marked non-null but is null");
            }
            this.replicaNumber = replicaNumber;
            return this;
        }

        public TransferReplicaParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.sourceGroupName, "Source group name");
            ParamUtils.CheckNullEmptyString(this.targetGroupName, "Target group name");
            ParamUtils.CheckNullEmptyString(this.collectionName, "Collection name");
            if (this.replicaNumber <= 0L) {
                throw new ParamException("Replica number must be specified and greater than zero");
            }
            return new TransferReplicaParam(this);
        }
    }
}

