/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.dml;

import com.alibaba.fastjson.JSONObject;
import io.milvus.exception.ParamException;
import io.milvus.param.dml.InsertParam;
import java.util.Collection;
import java.util.List;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;

public class UpsertParam
extends InsertParam {
    private UpsertParam(@NonNull Builder builder) {
        super(builder);
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public String toString() {
        String baseStr = "UpsertParam{collectionName='" + this.collectionName + '\'' + ", partitionName='" + this.partitionName + '\'' + ", rowCount=" + this.rowCount;
        if (!CollectionUtils.isEmpty((Collection)this.fields)) {
            return baseStr + ", columns=" + this.fields + '}';
        }
        return baseStr + '}';
    }

    public static class Builder
    extends InsertParam.Builder {
        private Builder() {
        }

        @Override
        public Builder withDatabaseName(String databaseName) {
            super.withDatabaseName(databaseName);
            return this;
        }

        @Override
        public Builder withCollectionName(@NonNull String collectionName) {
            if (collectionName == null) {
                throw new NullPointerException("collectionName is marked non-null but is null");
            }
            super.withCollectionName(collectionName);
            return this;
        }

        @Override
        public Builder withPartitionName(@NonNull String partitionName) {
            if (partitionName == null) {
                throw new NullPointerException("partitionName is marked non-null but is null");
            }
            super.withPartitionName(partitionName);
            return this;
        }

        @Override
        public Builder withFields(@NonNull List<InsertParam.Field> fields) {
            if (fields == null) {
                throw new NullPointerException("fields is marked non-null but is null");
            }
            super.withFields(fields);
            return this;
        }

        @Override
        public Builder withRows(@NonNull List<JSONObject> rows) {
            if (rows == null) {
                throw new NullPointerException("rows is marked non-null but is null");
            }
            super.withRows(rows);
            return this;
        }

        @Override
        public UpsertParam build() throws ParamException {
            super.build();
            return new UpsertParam(this);
        }
    }
}

