/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.bulkwriter;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import io.milvus.bulkwriter.Buffer;
import io.milvus.bulkwriter.common.clientenum.BulkFileType;
import io.milvus.bulkwriter.common.clientenum.TypeSize;
import io.milvus.common.utils.ExceptionUtils;
import io.milvus.grpc.DataType;
import io.milvus.param.ParamUtils;
import io.milvus.param.collection.CollectionSchemaParam;
import io.milvus.param.collection.FieldType;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BulkWriter {
    private static final Logger logger = LoggerFactory.getLogger(BulkWriter.class);
    protected CollectionSchemaParam collectionSchema;
    protected int chunkSize;
    protected BulkFileType fileType;
    protected int bufferSize;
    protected int bufferRowCount;
    protected int totalRowCount;
    protected Buffer buffer;
    protected ReentrantLock bufferLock;

    protected BulkWriter(CollectionSchemaParam collectionSchema, int chunkSize, BulkFileType fileType) {
        this.collectionSchema = collectionSchema;
        this.chunkSize = chunkSize;
        this.fileType = fileType;
        if (CollectionUtils.isEmpty(collectionSchema.getFieldTypes())) {
            ExceptionUtils.throwUnExpectedException("collection schema fields list is empty");
        }
        if (!this.hasPrimaryField(collectionSchema.getFieldTypes())) {
            ExceptionUtils.throwUnExpectedException("primary field is null");
        }
        this.bufferLock = new ReentrantLock();
        this.buffer = null;
        this.newBuffer();
    }

    protected Integer getBufferSize() {
        return this.bufferSize;
    }

    public Integer getBufferRowCount() {
        return this.bufferRowCount;
    }

    public Integer getTotalRowCount() {
        return this.totalRowCount;
    }

    protected Integer getChunkSize() {
        return this.chunkSize;
    }

    protected Buffer newBuffer() {
        Buffer oldBuffer = this.buffer;
        this.bufferLock.lock();
        this.buffer = new Buffer(this.collectionSchema, this.fileType);
        this.bufferLock.unlock();
        return oldBuffer;
    }

    public void appendRow(JSONObject row) throws IOException, InterruptedException {
        this.verifyRow(row);
        this.bufferLock.lock();
        this.buffer.appendRow(row);
        this.bufferLock.unlock();
    }

    protected void commit(boolean async) throws InterruptedException {
        this.bufferLock.lock();
        this.bufferSize = 0;
        this.bufferRowCount = 0;
        this.bufferLock.unlock();
    }

    protected String getDataPath() {
        return "";
    }

    private void verifyRow(JSONObject row) {
        int rowSize = 0;
        block6: for (FieldType fieldType : this.collectionSchema.getFieldTypes()) {
            String msg;
            if (fieldType.isPrimaryKey() && fieldType.isAutoID()) {
                if (!row.containsKey((Object)fieldType.getName())) continue;
                msg = String.format("The primary key field '%s' is auto-id, no need to provide", fieldType.getName());
                ExceptionUtils.throwUnExpectedException(msg);
            }
            if (!row.containsKey((Object)fieldType.getName())) {
                msg = String.format("The field '%s' is missed in the row", fieldType.getName());
                ExceptionUtils.throwUnExpectedException(msg);
            }
            switch (fieldType.getDataType()) {
                case BinaryVector: 
                case FloatVector: {
                    rowSize += this.verifyVector(row.get((Object)fieldType.getName()), fieldType).intValue();
                    continue block6;
                }
                case VarChar: {
                    rowSize += this.verifyVarchar(row.get((Object)fieldType.getName()), fieldType, false).intValue();
                    continue block6;
                }
                case JSON: {
                    Pair<Object, Integer> objectRowSize = this.verifyJSON(row.get((Object)fieldType.getName()), fieldType);
                    row.put(fieldType.getName(), objectRowSize.getLeft());
                    rowSize += ((Integer)objectRowSize.getRight()).intValue();
                    continue block6;
                }
                case Array: {
                    rowSize += this.verifyArray(row.get((Object)fieldType.getName()), fieldType).intValue();
                    continue block6;
                }
            }
            rowSize += TypeSize.getSize(fieldType.getDataType()).intValue();
        }
        this.bufferLock.lock();
        this.bufferSize += rowSize;
        ++this.bufferRowCount;
        ++this.totalRowCount;
        this.bufferLock.unlock();
    }

    private Integer verifyVector(Object object, FieldType fieldType) {
        if (fieldType.getDataType() == DataType.FloatVector) {
            ParamUtils.checkFieldData(fieldType, Lists.newArrayList((Object[])new Object[]{object}), false);
            return ((List)object).size() * 4;
        }
        ParamUtils.checkFieldData(fieldType, Lists.newArrayList((Object[])new Object[]{object}), false);
        return ((ByteBuffer)object).position();
    }

    private Integer verifyVarchar(Object object, FieldType fieldType, boolean verifyElementType) {
        ParamUtils.checkFieldData(fieldType, Lists.newArrayList((Object[])new Object[]{object}), verifyElementType);
        return String.valueOf(object).length();
    }

    private Pair<Object, Integer> verifyJSON(Object object, FieldType fieldType) {
        int size = 0;
        if (object instanceof String) {
            size = String.valueOf(object).length();
            object = this.tryConvertJson(fieldType.getName(), object);
        } else if (object instanceof JSONObject) {
            size = ((JSONObject)object).toJSONString().length();
        } else {
            String msg = String.format("Illegal JSON value for field '%s', type mismatch", fieldType.getName());
            ExceptionUtils.throwUnExpectedException(msg);
        }
        return Pair.of((Object)object, (Object)size);
    }

    private Integer verifyArray(Object object, FieldType fieldType) {
        ParamUtils.checkFieldData(fieldType, (List)object, true);
        int rowSize = 0;
        DataType elementType = fieldType.getElementType();
        if (TypeSize.contains(elementType)) {
            rowSize = TypeSize.getSize(elementType) * ((List)object).size();
        } else if (elementType == DataType.VarChar) {
            for (String ele : (List)object) {
                rowSize += this.verifyVarchar(ele, fieldType, true).intValue();
            }
        } else {
            String msg = String.format("Unsupported element type for array field '%s'", fieldType.getName());
            ExceptionUtils.throwUnExpectedException(msg);
        }
        return rowSize;
    }

    private Object tryConvertJson(String fieldName, Object object) {
        if (object instanceof String) {
            try {
                return JSONObject.parseObject((String)String.valueOf(object));
            }
            catch (Exception e) {
                String msg = String.format("Illegal JSON value for field '%s', type mismatch or illegal format, error: %s", fieldName, e);
                ExceptionUtils.throwUnExpectedException(msg);
            }
        }
        return object;
    }

    private boolean hasPrimaryField(List<FieldType> fieldTypes) {
        Optional<FieldType> primaryKeyField = fieldTypes.stream().filter(FieldType::isPrimaryKey).findFirst();
        return primaryKeyField.isPresent();
    }
}

